/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.runtime.datasource;

import io.quarkus.redis.datasource.ReactiveRedisDataSource;
import io.quarkus.redis.datasource.autosuggest.ReactiveAutoSuggestCommands;
import io.quarkus.redis.datasource.bitmap.ReactiveBitMapCommands;
import io.quarkus.redis.datasource.bloom.ReactiveBloomCommands;
import io.quarkus.redis.datasource.countmin.ReactiveCountMinCommands;
import io.quarkus.redis.datasource.cuckoo.ReactiveCuckooCommands;
import io.quarkus.redis.datasource.geo.ReactiveGeoCommands;
import io.quarkus.redis.datasource.graph.ReactiveGraphCommands;
import io.quarkus.redis.datasource.hash.ReactiveHashCommands;
import io.quarkus.redis.datasource.hyperloglog.ReactiveHyperLogLogCommands;
import io.quarkus.redis.datasource.json.ReactiveJsonCommands;
import io.quarkus.redis.datasource.keys.ReactiveKeyCommands;
import io.quarkus.redis.datasource.list.ReactiveListCommands;
import io.quarkus.redis.datasource.pubsub.ReactivePubSubCommands;
import io.quarkus.redis.datasource.search.ReactiveSearchCommands;
import io.quarkus.redis.datasource.set.ReactiveSetCommands;
import io.quarkus.redis.datasource.sortedset.ReactiveSortedSetCommands;
import io.quarkus.redis.datasource.string.ReactiveStringCommands;
import io.quarkus.redis.datasource.timeseries.ReactiveTimeSeriesCommands;
import io.quarkus.redis.datasource.topk.ReactiveTopKCommands;
import io.quarkus.redis.datasource.transactions.OptimisticLockingTransactionResult;
import io.quarkus.redis.datasource.transactions.ReactiveTransactionalRedisDataSource;
import io.quarkus.redis.datasource.transactions.TransactionResult;
import io.quarkus.redis.datasource.value.ReactiveValueCommands;
import io.quarkus.redis.runtime.datasource.OptimisticLockingTransactionResultImpl;
import io.quarkus.redis.runtime.datasource.ReactiveAutoSuggestCommandsImpl;
import io.quarkus.redis.runtime.datasource.ReactiveBitMapCommandsImpl;
import io.quarkus.redis.runtime.datasource.ReactiveBloomCommandsImpl;
import io.quarkus.redis.runtime.datasource.ReactiveCountMinCommandsImpl;
import io.quarkus.redis.runtime.datasource.ReactiveCuckooCommandsImpl;
import io.quarkus.redis.runtime.datasource.ReactiveGeoCommandsImpl;
import io.quarkus.redis.runtime.datasource.ReactiveGraphCommandsImpl;
import io.quarkus.redis.runtime.datasource.ReactiveHashCommandsImpl;
import io.quarkus.redis.runtime.datasource.ReactiveHyperLogLogCommandsImpl;
import io.quarkus.redis.runtime.datasource.ReactiveJsonCommandsImpl;
import io.quarkus.redis.runtime.datasource.ReactiveKeyCommandsImpl;
import io.quarkus.redis.runtime.datasource.ReactiveListCommandsImpl;
import io.quarkus.redis.runtime.datasource.ReactivePubSubCommandsImpl;
import io.quarkus.redis.runtime.datasource.ReactiveSearchCommandsImpl;
import io.quarkus.redis.runtime.datasource.ReactiveSetCommandsImpl;
import io.quarkus.redis.runtime.datasource.ReactiveSortedSetCommandsImpl;
import io.quarkus.redis.runtime.datasource.ReactiveStringCommandsImpl;
import io.quarkus.redis.runtime.datasource.ReactiveTimeSeriesCommandsImpl;
import io.quarkus.redis.runtime.datasource.ReactiveTopKCommandsImpl;
import io.quarkus.redis.runtime.datasource.ReactiveTransactionalRedisDataSourceImpl;
import io.quarkus.redis.runtime.datasource.RedisCommandExecutor;
import io.quarkus.redis.runtime.datasource.TransactionHolder;
import io.quarkus.redis.runtime.datasource.TransactionResultImpl;
import io.quarkus.redis.runtime.datasource.Validation;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.vertx.mutiny.core.Vertx;
import io.vertx.mutiny.redis.client.Redis;
import io.vertx.mutiny.redis.client.RedisAPI;
import io.vertx.mutiny.redis.client.RedisConnection;
import io.vertx.mutiny.redis.client.Response;
import io.vertx.redis.client.Command;
import io.vertx.redis.client.Request;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;

public class ReactiveRedisDataSourceImpl
implements ReactiveRedisDataSource,
RedisCommandExecutor {
    final Redis redis;
    final RedisConnection connection;
    private final Vertx vertx;

    public ReactiveRedisDataSourceImpl(Vertx vertx, Redis redis, RedisAPI api) {
        ParameterValidation.nonNull((Object)redis, (String)"redis");
        ParameterValidation.nonNull((Object)api, (String)"api");
        ParameterValidation.nonNull((Object)vertx, (String)"vertx");
        this.vertx = vertx;
        this.redis = redis;
        this.connection = null;
    }

    public ReactiveRedisDataSourceImpl(Vertx vertx, Redis redis, RedisConnection connection) {
        ParameterValidation.nonNull((Object)redis, (String)"redis");
        ParameterValidation.nonNull((Object)connection, (String)"connection");
        ParameterValidation.nonNull((Object)vertx, (String)"vertx");
        this.vertx = vertx;
        this.redis = redis;
        this.connection = connection;
    }

    @Override
    public Uni<Response> execute(io.vertx.mutiny.redis.client.Request request) {
        if (this.connection != null) {
            return this.connection.send(request);
        }
        return this.redis.send(request);
    }

    @Override
    public Uni<TransactionResult> withTransaction(Function<ReactiveTransactionalRedisDataSource, Uni<Void>> function) {
        ParameterValidation.nonNull(function, (String)"function");
        return this.redis.connect().onItem().transformToUni(connection -> {
            ReactiveRedisDataSourceImpl singleConnectionDS = new ReactiveRedisDataSourceImpl(this.vertx, this.redis, (RedisConnection)connection);
            TransactionHolder th = new TransactionHolder();
            return connection.send(io.vertx.mutiny.redis.client.Request.cmd((io.vertx.mutiny.redis.client.Command)io.vertx.mutiny.redis.client.Command.MULTI)).chain(x -> (Uni)function.apply(new ReactiveTransactionalRedisDataSourceImpl(singleConnectionDS, th))).chain(ignored -> {
                if (!th.discarded()) {
                    return connection.send(io.vertx.mutiny.redis.client.Request.cmd((io.vertx.mutiny.redis.client.Command)io.vertx.mutiny.redis.client.Command.EXEC));
                }
                return Uni.createFrom().nullItem();
            }).onTermination().call(() -> ((RedisConnection)connection).close()).map(r -> ReactiveRedisDataSourceImpl.toTransactionResult(r, th));
        });
    }

    @Override
    public Uni<TransactionResult> withTransaction(Function<ReactiveTransactionalRedisDataSource, Uni<Void>> function, String ... keys) {
        ParameterValidation.nonNull(function, (String)"function");
        Validation.notNullOrEmpty(keys, "keys");
        ParameterValidation.doesNotContainNull((Object[])keys, (String)"keys");
        return this.redis.connect().onItem().transformToUni(connection -> {
            ReactiveRedisDataSourceImpl singleConnectionDS = new ReactiveRedisDataSourceImpl(this.vertx, this.redis, (RedisConnection)connection);
            List<String> watched = List.of(keys);
            TransactionHolder th = new TransactionHolder();
            return this.watch((RedisConnection)connection, keys).chain(() -> connection.send(io.vertx.mutiny.redis.client.Request.cmd((io.vertx.mutiny.redis.client.Command)io.vertx.mutiny.redis.client.Command.MULTI)).chain(x -> (Uni)function.apply(new ReactiveTransactionalRedisDataSourceImpl(singleConnectionDS, th))).onItemOrFailure().transformToUni((x, failure) -> {
                if (!th.discarded() && failure == null) {
                    return connection.send(io.vertx.mutiny.redis.client.Request.cmd((io.vertx.mutiny.redis.client.Command)io.vertx.mutiny.redis.client.Command.EXEC));
                }
                if (!th.discarded()) {
                    return connection.send(io.vertx.mutiny.redis.client.Request.cmd((io.vertx.mutiny.redis.client.Command)io.vertx.mutiny.redis.client.Command.DISCARD));
                }
                return Uni.createFrom().nullItem();
            }).onTermination().call(() -> ((RedisConnection)connection).close()).map(r -> ReactiveRedisDataSourceImpl.toTransactionResult(r, th)));
        });
    }

    private Uni<Void> watch(RedisConnection connection, String ... keys) {
        List<String> watched = List.of(keys);
        io.vertx.mutiny.redis.client.Request request = io.vertx.mutiny.redis.client.Request.cmd((io.vertx.mutiny.redis.client.Command)io.vertx.mutiny.redis.client.Command.WATCH);
        for (String s : watched) {
            request.arg(s);
        }
        return connection.send(request).replaceWithVoid();
    }

    @Override
    public <I> Uni<OptimisticLockingTransactionResult<I>> withTransaction(Function<ReactiveRedisDataSource, Uni<I>> preTxBlock, BiFunction<I, ReactiveTransactionalRedisDataSource, Uni<Void>> tx, String ... watchedKeys) {
        ParameterValidation.nonNull(tx, (String)"tx");
        Validation.notNullOrEmpty(watchedKeys, "watchedKeys");
        ParameterValidation.doesNotContainNull((Object[])watchedKeys, (String)"watchedKeys");
        ParameterValidation.nonNull(preTxBlock, (String)"preTxBlock");
        return this.redis.connect().onItem().transformToUni(connection -> {
            ReactiveRedisDataSourceImpl singleConnectionDS = new ReactiveRedisDataSourceImpl(this.vertx, this.redis, (RedisConnection)connection);
            TransactionHolder th = new TransactionHolder();
            return this.watch((RedisConnection)connection, watchedKeys).chain(x -> (Uni)preTxBlock.apply(new ReactiveRedisDataSourceImpl(this.vertx, this.redis, (RedisConnection)connection))).chain(input -> connection.send(io.vertx.mutiny.redis.client.Request.cmd((io.vertx.mutiny.redis.client.Command)io.vertx.mutiny.redis.client.Command.MULTI)).chain(x -> (Uni)tx.apply(input, new ReactiveTransactionalRedisDataSourceImpl(singleConnectionDS, th))).onItemOrFailure().transformToUni((x, failure) -> {
                if (!th.discarded() && failure == null) {
                    return connection.send(io.vertx.mutiny.redis.client.Request.cmd((io.vertx.mutiny.redis.client.Command)io.vertx.mutiny.redis.client.Command.EXEC));
                }
                if (!th.discarded()) {
                    return connection.send(io.vertx.mutiny.redis.client.Request.cmd((io.vertx.mutiny.redis.client.Command)io.vertx.mutiny.redis.client.Command.DISCARD)).replaceWithNull();
                }
                return Uni.createFrom().nullItem();
            }).onTermination().call(() -> ((RedisConnection)connection).close()).map(r -> ReactiveRedisDataSourceImpl.toTransactionResult(r, input, th)));
        });
    }

    public static TransactionResult toTransactionResult(Response response, TransactionHolder th) {
        if (response == null) {
            return TransactionResultImpl.DISCARDED;
        }
        return new TransactionResultImpl(th.discarded(), th.map(response));
    }

    public static <I> OptimisticLockingTransactionResult<I> toTransactionResult(Response response, I input, TransactionHolder th) {
        if (response == null) {
            return OptimisticLockingTransactionResultImpl.discarded(input);
        }
        return new OptimisticLockingTransactionResultImpl<I>(th.discarded(), input, th.map(response));
    }

    @Override
    public Uni<Response> execute(String command, String ... args) {
        ParameterValidation.nonNull((Object)command, (String)"command");
        return this.execute(io.vertx.mutiny.redis.client.Command.create((String)command), args);
    }

    @Override
    public Uni<Response> execute(io.vertx.mutiny.redis.client.Command command, String ... args) {
        ParameterValidation.nonNull((Object)command, (String)"command");
        io.vertx.mutiny.redis.client.Request request = io.vertx.mutiny.redis.client.Request.cmd((io.vertx.mutiny.redis.client.Command)command);
        for (String arg : args) {
            request.arg(arg);
        }
        return this.execute(request);
    }

    @Override
    public Uni<Response> execute(Command command, String ... args) {
        ParameterValidation.nonNull((Object)command, (String)"command");
        io.vertx.mutiny.redis.client.Request request = io.vertx.mutiny.redis.client.Request.newInstance((Request)Request.cmd((Command)command));
        for (String arg : args) {
            request.arg(arg);
        }
        return this.execute(request);
    }

    @Override
    public Uni<Void> withConnection(Function<ReactiveRedisDataSource, Uni<Void>> function) {
        if (this.connection != null) {
            return function.apply(this);
        }
        return this.redis.connect().onItem().transformToUni(connection -> {
            ReactiveRedisDataSourceImpl singleConnectionDS = new ReactiveRedisDataSourceImpl(this.vertx, this.redis, (RedisConnection)connection);
            return ((Uni)function.apply(singleConnectionDS)).onTermination().call(() -> ((RedisConnection)connection).close());
        });
    }

    @Override
    public Uni<Void> select(long index) {
        ParameterValidation.positiveOrZero((long)index, (String)"index");
        return this.execute(io.vertx.mutiny.redis.client.Request.cmd((io.vertx.mutiny.redis.client.Command)io.vertx.mutiny.redis.client.Command.SELECT).arg(index)).replaceWithVoid();
    }

    @Override
    public Uni<Void> flushall() {
        return this.execute(io.vertx.mutiny.redis.client.Request.cmd((io.vertx.mutiny.redis.client.Command)io.vertx.mutiny.redis.client.Command.FLUSHALL)).replaceWithVoid();
    }

    @Override
    public <K, F, V> ReactiveHashCommands<K, F, V> hash(Class<K> redisKeyType, Class<F> fieldType, Class<V> valueType) {
        return new ReactiveHashCommandsImpl<K, F, V>(this, redisKeyType, fieldType, valueType);
    }

    @Override
    public <K, V> ReactiveGeoCommands<K, V> geo(Class<K> redisKeyType, Class<V> memberType) {
        return new ReactiveGeoCommandsImpl<K, V>(this, redisKeyType, memberType);
    }

    @Override
    public <K> ReactiveKeyCommands<K> key(Class<K> redisKeyType) {
        return new ReactiveKeyCommandsImpl<K>(this, redisKeyType);
    }

    @Override
    public <K, V> ReactiveSortedSetCommands<K, V> sortedSet(Class<K> redisKeyType, Class<V> valueType) {
        return new ReactiveSortedSetCommandsImpl<K, V>(this, redisKeyType, valueType);
    }

    @Override
    public <K, V> ReactiveStringCommands<K, V> string(Class<K> redisKeyType, Class<V> valueType) {
        return new ReactiveStringCommandsImpl<K, V>(this, redisKeyType, valueType);
    }

    @Override
    public <K, V> ReactiveValueCommands<K, V> value(Class<K> redisKeyType, Class<V> valueType) {
        return new ReactiveStringCommandsImpl<K, V>(this, redisKeyType, valueType);
    }

    @Override
    public <K, V> ReactiveSetCommands<K, V> set(Class<K> redisKeyType, Class<V> memberType) {
        return new ReactiveSetCommandsImpl<K, V>(this, redisKeyType, memberType);
    }

    @Override
    public <K, V> ReactiveListCommands<K, V> list(Class<K> redisKeyType, Class<V> memberType) {
        return new ReactiveListCommandsImpl<K, V>(this, redisKeyType, memberType);
    }

    @Override
    public <K, V> ReactiveHyperLogLogCommands<K, V> hyperloglog(Class<K> redisKeyType, Class<V> memberType) {
        return new ReactiveHyperLogLogCommandsImpl<K, V>(this, redisKeyType, memberType);
    }

    @Override
    public <K> ReactiveBitMapCommands<K> bitmap(Class<K> redisKeyType) {
        return new ReactiveBitMapCommandsImpl<K>(this, redisKeyType);
    }

    @Override
    public <K> ReactiveJsonCommands<K> json(Class<K> redisKeyType) {
        return new ReactiveJsonCommandsImpl<K>(this, redisKeyType);
    }

    @Override
    public <K, V> ReactiveBloomCommands<K, V> bloom(Class<K> redisKeyType, Class<V> valueType) {
        return new ReactiveBloomCommandsImpl<K, V>(this, redisKeyType, valueType);
    }

    @Override
    public <K, V> ReactiveCuckooCommands<K, V> cuckoo(Class<K> redisKeyType, Class<V> valueType) {
        return new ReactiveCuckooCommandsImpl<K, V>(this, redisKeyType, valueType);
    }

    @Override
    public <K, V> ReactiveCountMinCommands<K, V> countmin(Class<K> redisKeyType, Class<V> valueType) {
        return new ReactiveCountMinCommandsImpl<K, V>(this, redisKeyType, valueType);
    }

    @Override
    public <K, V> ReactiveTopKCommands<K, V> topk(Class<K> redisKeyType, Class<V> valueType) {
        return new ReactiveTopKCommandsImpl<K, V>(this, redisKeyType, valueType);
    }

    @Override
    public <K> ReactiveGraphCommands<K> graph(Class<K> redisKeyType) {
        return new ReactiveGraphCommandsImpl<K>(this, redisKeyType);
    }

    @Override
    public <V> ReactivePubSubCommands<V> pubsub(Class<V> messageType) {
        return new ReactivePubSubCommandsImpl<V>(this, messageType);
    }

    @Override
    public <K> ReactiveSearchCommands<K> search(Class<K> redisKeyType) {
        return new ReactiveSearchCommandsImpl<K>(this, redisKeyType);
    }

    @Override
    public <K> ReactiveAutoSuggestCommands<K> autosuggest(Class<K> redisKeyType) {
        return new ReactiveAutoSuggestCommandsImpl<K>(this, redisKeyType);
    }

    @Override
    public <K> ReactiveTimeSeriesCommands<K> timeseries(Class<K> redisKeyType) {
        return new ReactiveTimeSeriesCommandsImpl<K>(this, redisKeyType);
    }

    @Override
    public Redis getRedis() {
        return this.redis;
    }

    public Vertx getVertx() {
        return this.vertx;
    }
}

