/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.client.runtime.health;

import io.quarkus.arc.Arc;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.redis.client.RedisClient;
import io.quarkus.redis.client.RedisClientName;
import io.quarkus.redis.client.reactive.ReactiveRedisClient;
import io.quarkus.redis.client.runtime.RedisClientUtil;
import io.quarkus.redis.client.runtime.RedisConfig;
import io.vertx.mutiny.redis.client.Response;
import java.lang.annotation.Annotation;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.spi.Bean;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.eclipse.microprofile.health.HealthCheckResponseBuilder;
import org.eclipse.microprofile.health.Readiness;

@Readiness
@ApplicationScoped
class RedisHealthCheck
implements HealthCheck {
    private final Map<String, RedisClient> clients = new HashMap<String, RedisClient>();
    private final Map<String, ReactiveRedisClient> reactiveClients = new HashMap<String, ReactiveRedisClient>();
    private final RedisConfig redisConfig;

    public RedisHealthCheck(RedisConfig redisConfig) {
        this.redisConfig = redisConfig;
    }

    @PostConstruct
    protected void init() {
        String clientName;
        for (InstanceHandle handle : Arc.container().select(RedisClient.class, new Annotation[]{Any.Literal.INSTANCE}).handles()) {
            clientName = this.getClientName((Bean)handle.getBean());
            this.clients.put(clientName == null ? "<default>" : clientName, (RedisClient)handle.get());
        }
        for (InstanceHandle handle : Arc.container().select(ReactiveRedisClient.class, new Annotation[]{Any.Literal.INSTANCE}).handles()) {
            clientName = this.getClientName((Bean)handle.getBean());
            this.reactiveClients.put(clientName == null ? "<default>" : clientName, (ReactiveRedisClient)handle.get());
        }
    }

    private String getClientName(Bean bean) {
        for (Object qualifier : bean.getQualifiers()) {
            if (!(qualifier instanceof RedisClientName)) continue;
            return ((RedisClientName)qualifier).value();
        }
        return null;
    }

    public HealthCheckResponse call() {
        Object redisClient;
        boolean isDefault;
        HealthCheckResponseBuilder builder = HealthCheckResponse.named((String)"Redis connection health check").up();
        for (Map.Entry<String, RedisClient> entry : this.clients.entrySet()) {
            try {
                isDefault = "<default>".equals(entry.getKey());
                redisClient = entry.getValue();
                String redisClientName = isDefault ? "default" : entry.getKey();
                io.vertx.redis.client.Response response = redisClient.ping(Collections.emptyList());
                builder.up().withData(redisClientName, response.toString());
            }
            catch (Exception e) {
                return builder.down().withData("reason", "client [" + entry.getKey() + "]: " + e.getMessage()).build();
            }
        }
        for (Map.Entry<String, Object> entry : this.reactiveClients.entrySet()) {
            if (this.clients.containsKey(entry.getKey())) continue;
            try {
                isDefault = "<default>".equals(entry.getKey());
                redisClient = (ReactiveRedisClient)entry.getValue();
                RedisConfig.RedisConfiguration redisConfig = RedisClientUtil.getConfiguration(this.redisConfig, isDefault ? "<default>" : entry.getKey());
                long timeout = 10L;
                if (redisConfig.timeout.isPresent()) {
                    timeout = redisConfig.timeout.get().getSeconds();
                }
                String redisClientName = isDefault ? "default" : entry.getKey();
                Response response = (Response)redisClient.ping(Collections.emptyList()).await().atMost(Duration.ofSeconds(timeout));
                builder.up().withData(redisClientName, response.toString());
            }
            catch (Exception e) {
                return builder.down().withData("reason", "client [" + entry.getKey() + "]: " + e.getMessage()).build();
            }
        }
        return builder.build();
    }
}

