/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.client.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.redis.client.RedisHostsProvider;
import io.quarkus.redis.client.runtime.RedisConfig;
import io.quarkus.redis.client.runtime.SslConfig;
import io.quarkus.runtime.configuration.ConfigurationException;
import io.quarkus.vertx.core.runtime.SSLConfigHelper;
import io.quarkus.vertx.core.runtime.config.JksConfiguration;
import io.quarkus.vertx.core.runtime.config.PemKeyCertConfiguration;
import io.quarkus.vertx.core.runtime.config.PemTrustCertConfiguration;
import io.quarkus.vertx.core.runtime.config.PfxConfiguration;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.net.TCPSSLOptions;
import io.vertx.redis.client.RedisClientType;
import io.vertx.redis.client.RedisOptions;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.util.Collections;
import java.util.Set;

public class RedisClientUtil {
    public static final String DEFAULT_CLIENT = "<default>";

    public static RedisOptions buildOptions(RedisConfig.RedisConfiguration redisConfig) {
        RedisOptions options = new RedisOptions();
        options.setType(redisConfig.clientType);
        Set<Object> hosts = Collections.emptySet();
        if (redisConfig.hosts.isPresent()) {
            hosts = redisConfig.hosts.get();
        } else if (redisConfig.hostsProviderName.isPresent()) {
            RedisHostsProvider hostsProvider = RedisClientUtil.findProvider(redisConfig.hostsProviderName.get());
            hosts = hostsProvider.getHosts();
        }
        if (RedisClientType.STANDALONE == redisConfig.clientType && hosts.size() > 1) {
            throw new ConfigurationException("Multiple hosts supplied for non clustered configuration");
        }
        for (URI uRI : hosts) {
            options.addConnectionString(uRI.toString());
        }
        options.setMaxNestedArrays(redisConfig.maxNestedArrays);
        options.setMaxWaitingHandlers(redisConfig.maxWaitingHandlers);
        options.setMaxPoolSize(redisConfig.maxPoolSize);
        options.setMaxPoolWaiting(redisConfig.maxPoolWaiting);
        options.setPoolRecycleTimeout(Math.toIntExact(redisConfig.poolRecycleTimeout.toMillis()));
        if (redisConfig.poolCleanerInterval.isPresent()) {
            options.setPoolCleanerInterval(Math.toIntExact(redisConfig.poolCleanerInterval.get().toMillis()));
        }
        if (redisConfig.role.isPresent()) {
            options.setRole(redisConfig.role.get());
        }
        if (redisConfig.masterName.isPresent()) {
            options.setMasterName(redisConfig.masterName.get());
        }
        if (redisConfig.replicas.isPresent()) {
            options.setUseReplicas(redisConfig.replicas.get());
        }
        if (redisConfig.password.isPresent()) {
            options.setPassword(redisConfig.password.get());
        }
        options.setNetClientOptions(RedisClientUtil.toNetClientOptions(redisConfig));
        return options;
    }

    private static NetClientOptions toNetClientOptions(RedisConfig.RedisConfiguration redisConfig) {
        NetClientOptions netClientOptions = new NetClientOptions().setTcpKeepAlive(redisConfig.tcpKeepAlive).setTcpNoDelay(redisConfig.tcpNoDelay);
        SslConfig sslConfig = redisConfig.ssl;
        netClientOptions.setSsl(sslConfig.enabled).setTrustAll(sslConfig.trustAll);
        SSLConfigHelper.configurePemTrustOptions((TCPSSLOptions)netClientOptions, (PemTrustCertConfiguration)sslConfig.trustCertificatePem);
        SSLConfigHelper.configureJksTrustOptions((TCPSSLOptions)netClientOptions, (JksConfiguration)sslConfig.trustCertificateJks);
        SSLConfigHelper.configurePfxTrustOptions((TCPSSLOptions)netClientOptions, (PfxConfiguration)sslConfig.trustCertificatePfx);
        SSLConfigHelper.configurePemKeyCertOptions((TCPSSLOptions)netClientOptions, (PemKeyCertConfiguration)sslConfig.keyCertificatePem);
        SSLConfigHelper.configureJksKeyCertOptions((TCPSSLOptions)netClientOptions, (JksConfiguration)sslConfig.keyCertificateJks);
        SSLConfigHelper.configurePfxKeyCertOptions((TCPSSLOptions)netClientOptions, (PfxConfiguration)sslConfig.keyCertificatePfx);
        netClientOptions.setReconnectAttempts(redisConfig.reconnectAttempts);
        netClientOptions.setReconnectInterval(redisConfig.reconnectInterval.toMillis());
        if (redisConfig.idleTimeout.isPresent()) {
            netClientOptions.setIdleTimeout(redisConfig.idleTimeout.get().intValue());
        }
        if (sslConfig.hostnameVerificationAlgorithm.isPresent()) {
            netClientOptions.setHostnameVerificationAlgorithm(sslConfig.hostnameVerificationAlgorithm.get());
        }
        return netClientOptions;
    }

    public static boolean isDefault(String clientName) {
        return DEFAULT_CLIENT.equals(clientName);
    }

    public static RedisConfig.RedisConfiguration getConfiguration(RedisConfig config, String name) {
        if (RedisClientUtil.isDefault(name)) {
            return config.defaultClient;
        }
        RedisConfig.RedisConfiguration redisConfiguration = config.additionalRedisClients.get(name);
        if (redisConfiguration != null) {
            return redisConfiguration;
        }
        throw new IllegalArgumentException(String.format("Configuration for %s redis client does not exists", name));
    }

    public static RedisHostsProvider findProvider(String name) {
        RedisHostsProvider hostsProvider;
        ArcContainer container = Arc.container();
        RedisHostsProvider redisHostsProvider = hostsProvider = name != null ? (RedisHostsProvider)container.instance(name).get() : (RedisHostsProvider)container.instance(RedisHostsProvider.class, new Annotation[0]).get();
        if (hostsProvider == null) {
            throw new RuntimeException("unable to find redis host provider named: " + (name == null ? "default" : name));
        }
        return hostsProvider;
    }
}

