/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.client.runtime;

import io.quarkus.redis.client.runtime.SslConfig;
import io.quarkus.runtime.annotations.ConfigGroup;
import io.quarkus.runtime.annotations.ConfigItem;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import io.vertx.redis.client.RedisClientType;
import io.vertx.redis.client.RedisReplicas;
import io.vertx.redis.client.RedisRole;
import java.net.URI;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

@ConfigRoot(phase=ConfigPhase.RUN_TIME, name="redis")
public class RedisConfig {
    public static final String REDIS_CONFIG_ROOT_NAME = "redis";
    public static final String HOSTS_CONFIG_NAME = "hosts";
    @ConfigItem(name="<<parent>>")
    public RedisConfiguration defaultClient;
    @ConfigItem(name="<<parent>>")
    Map<String, RedisConfiguration> additionalRedisClients;

    @ConfigGroup
    public static class RedisConfiguration {
        @ConfigItem(defaultValueDocumentation="redis://localhost:6379", name="hosts")
        public Optional<Set<URI>> hosts;
        @ConfigItem
        public Optional<String> hostsProviderName;
        @ConfigItem(defaultValue="10s")
        public Optional<Duration> timeout;
        @ConfigItem(defaultValue="standalone")
        public RedisClientType clientType;
        @ConfigItem(defaultValueDocumentation="mymaster")
        public Optional<String> masterName;
        @ConfigItem(defaultValueDocumentation="master")
        public Optional<RedisRole> role;
        @ConfigItem(defaultValueDocumentation="never")
        public Optional<RedisReplicas> replicas;
        @ConfigItem
        public Optional<String> password;
        @ConfigItem(defaultValue="6")
        public int maxPoolSize;
        @ConfigItem(defaultValue="24")
        public int maxPoolWaiting;
        @ConfigItem
        public Optional<Duration> poolCleanerInterval;
        @ConfigItem(defaultValue="15")
        public Duration poolRecycleTimeout;
        @ConfigItem(defaultValue="2048")
        public int maxWaitingHandlers;
        @ConfigItem(defaultValue="32")
        public int maxNestedArrays;
        @ConfigItem(defaultValue="0")
        public int reconnectAttempts;
        @ConfigItem(defaultValue="1")
        public Duration reconnectInterval;
        @ConfigItem(defaultValueDocumentation="no timeout")
        public Optional<Integer> idleTimeout;
        @ConfigItem(defaultValue="true")
        public boolean tcpKeepAlive;
        @ConfigItem(defaultValue="true")
        public boolean tcpNoDelay;
        @ConfigItem
        public SslConfig ssl;
    }
}

