/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.runtime.datasource;

import io.quarkus.redis.datasource.keys.CopyArgs;
import io.quarkus.redis.datasource.keys.ExpireArgs;
import io.quarkus.redis.datasource.keys.RedisKeyNotFoundException;
import io.quarkus.redis.datasource.keys.RedisValueType;
import io.quarkus.redis.runtime.datasource.AbstractRedisCommands;
import io.quarkus.redis.runtime.datasource.Marshaller;
import io.quarkus.redis.runtime.datasource.RedisCommand;
import io.quarkus.redis.runtime.datasource.RedisCommandExecutor;
import io.quarkus.redis.runtime.datasource.Validation;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.vertx.mutiny.redis.client.Command;
import io.vertx.mutiny.redis.client.Response;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.NoSuchElementException;

class AbstractKeyCommands<K>
extends AbstractRedisCommands {
    protected final Class<K> typeOfKey;

    AbstractKeyCommands(RedisCommandExecutor redis, Class<K> k) {
        super(redis, new Marshaller(k));
        this.typeOfKey = k;
    }

    Uni<Response> _copy(K source, K destination) {
        ParameterValidation.nonNull(source, (String)"source");
        ParameterValidation.nonNull(destination, (String)"destination");
        return this.execute(RedisCommand.of(Command.COPY).put(this.marshaller.encode(source)).put(this.marshaller.encode(destination)));
    }

    Uni<Response> _copy(K source, K destination, CopyArgs copyArgs) {
        ParameterValidation.nonNull(source, (String)"source");
        ParameterValidation.nonNull(destination, (String)"destination");
        ParameterValidation.nonNull((Object)copyArgs, (String)"copyArgs");
        RedisCommand cmd = RedisCommand.of(Command.COPY);
        cmd.put(this.marshaller.encode(source));
        cmd.put(this.marshaller.encode(destination));
        cmd.putAll(copyArgs.toArgs());
        return this.execute(cmd);
    }

    Uni<Response> _del(K ... keys) {
        Validation.notNullOrEmpty(keys, "keys");
        ParameterValidation.doesNotContainNull((Object[])keys, (String)"keys");
        RedisCommand cmd = RedisCommand.of(Command.DEL);
        for (K key : keys) {
            cmd.put(this.marshaller.encode(key));
        }
        return this.execute(cmd);
    }

    Uni<Response> _dump(K key) {
        ParameterValidation.nonNull(key, (String)"key");
        return this.execute(RedisCommand.of(Command.DUMP).put(this.marshaller.encode(key)));
    }

    String decodeStringOrNull(Response r) {
        if (r == null) {
            return null;
        }
        return r.toString();
    }

    Uni<Response> _exists(K key) {
        ParameterValidation.nonNull(key, (String)"key");
        return this.execute(RedisCommand.of(Command.EXISTS).put(this.marshaller.encode(key)));
    }

    Uni<Response> _exists(K ... keys) {
        Validation.notNullOrEmpty(keys, "keys");
        ParameterValidation.doesNotContainNull((Object[])keys, (String)"keys");
        return this.execute(RedisCommand.of(Command.EXISTS).put(this.marshaller.encode(keys)));
    }

    Uni<Response> _expire(K key, long seconds, ExpireArgs expireArgs) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.positive((long)seconds, (String)"seconds");
        ParameterValidation.nonNull((Object)expireArgs, (String)"expireArgs");
        RedisCommand cmd = RedisCommand.of(Command.EXPIRE);
        cmd.put(this.marshaller.encode(key));
        cmd.put(seconds);
        cmd.putArgs(expireArgs);
        return this.execute(cmd);
    }

    Uni<Response> _expire(K key, Duration duration, ExpireArgs expireArgs) {
        return this._expire(key, duration.toSeconds(), expireArgs);
    }

    Uni<Response> _expire(K key, long seconds) {
        return this._expire(key, seconds, new ExpireArgs());
    }

    Uni<Response> _expire(K key, Duration duration) {
        return this._expire(key, duration.toSeconds(), new ExpireArgs());
    }

    Uni<Response> _expireat(K key, long timestamp) {
        return this._expireat(key, timestamp, new ExpireArgs());
    }

    Uni<Response> _expireat(K key, Instant timestamp) {
        return this._expireat(key, timestamp.getEpochSecond(), new ExpireArgs());
    }

    Uni<Response> _expireat(K key, long timestamp, ExpireArgs expireArgs) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.positive((long)timestamp, (String)"timestamp");
        ParameterValidation.nonNull((Object)expireArgs, (String)"expireArgs");
        RedisCommand cmd = RedisCommand.of(Command.EXPIREAT);
        cmd.put(this.marshaller.encode(key));
        cmd.put(timestamp);
        cmd.putArgs(expireArgs);
        return this.execute(cmd);
    }

    Uni<Response> _expireat(K key, Instant timestamp, ExpireArgs expireArgs) {
        return this._expireat(key, timestamp.getEpochSecond(), expireArgs);
    }

    Uni<Response> _expiretime(K key) {
        ParameterValidation.nonNull(key, (String)"key");
        return this.execute(RedisCommand.of(Command.EXPIRETIME).put(this.marshaller.encode(key)));
    }

    long decodeExpireResponse(K key, Response r) {
        long res = r.toLong();
        if (res == -2L) {
            throw new RedisKeyNotFoundException(new String(this.marshaller.encode(key), StandardCharsets.UTF_8));
        }
        return res;
    }

    Uni<Response> _keys(String pattern) {
        ParameterValidation.nonNull((Object)pattern, (String)"pattern");
        if (pattern.isBlank()) {
            throw new IllegalArgumentException("`pattern` must not be blank");
        }
        return this.execute(RedisCommand.of(Command.KEYS).put(pattern));
    }

    List<K> decodeKeys(Response response) {
        return this.marshaller.decodeAsList(response, this.typeOfKey);
    }

    Uni<Response> _move(K key, long db) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.positiveOrZero((long)db, (String)"db");
        return this.execute(RedisCommand.of(Command.MOVE).put(this.marshaller.encode(key)).put(db));
    }

    Uni<Response> _persist(K key) {
        ParameterValidation.nonNull(key, (String)"key");
        return this.execute(RedisCommand.of(Command.PERSIST).put(this.marshaller.encode(key)));
    }

    Uni<Response> _pexpire(K key, long milliseconds, ExpireArgs expireArgs) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.positive((long)milliseconds, (String)"milliseconds");
        ParameterValidation.nonNull((Object)expireArgs, (String)"expireArgs");
        RedisCommand cmd = RedisCommand.of(Command.PEXPIRE);
        cmd.put(this.marshaller.encode(key));
        cmd.put(Long.toString(milliseconds));
        cmd.put(expireArgs);
        return this.execute(cmd);
    }

    Uni<Response> _pexpire(K key, Duration duration, ExpireArgs expireArgs) {
        return this._pexpire(key, duration.toMillis(), expireArgs);
    }

    Uni<Response> _pexpire(K key, long ms) {
        return this._pexpire(key, ms, new ExpireArgs());
    }

    Uni<Response> _pexpire(K key, Duration duration) {
        return this._pexpire(key, duration.toMillis(), new ExpireArgs());
    }

    Uni<Response> _pexpireat(K key, long timestamp) {
        return this._pexpireat(key, timestamp, new ExpireArgs());
    }

    Uni<Response> _pexpireat(K key, Instant timestamp) {
        return this._pexpireat(key, timestamp.toEpochMilli(), new ExpireArgs());
    }

    Uni<Response> _pexpireat(K key, long timestamp, ExpireArgs expireArgs) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.positive((long)timestamp, (String)"timestamp");
        ParameterValidation.nonNull((Object)expireArgs, (String)"expireArgs");
        RedisCommand cmd = RedisCommand.of(Command.PEXPIREAT);
        cmd.put(this.marshaller.encode(key));
        cmd.put(Long.toString(timestamp));
        cmd.put(expireArgs.toArgs());
        return this.execute(cmd);
    }

    Uni<Response> _pexpireat(K key, Instant timestamp, ExpireArgs expireArgs) {
        return this._pexpireat(key, timestamp.toEpochMilli(), expireArgs);
    }

    Uni<Response> _pexpiretime(K key) {
        ParameterValidation.nonNull(key, (String)"key");
        return this.execute(RedisCommand.of(Command.PEXPIRETIME).put(this.marshaller.encode(key)));
    }

    Uni<Response> _pttl(K key) {
        ParameterValidation.nonNull(key, (String)"key");
        return this.execute(RedisCommand.of(Command.PTTL).put(this.marshaller.encode(key)));
    }

    Uni<Response> _randomkey() {
        return this.execute(RedisCommand.of(Command.RANDOMKEY));
    }

    K decodeK(Response r) {
        return this.marshaller.decode(this.typeOfKey, r);
    }

    Uni<Response> _rename(K key, K newKey) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.nonNull(newKey, (String)"newKey");
        return this.execute(RedisCommand.of(Command.RENAME).put(this.marshaller.encode(key)).put(this.marshaller.encode(newKey))).onFailure().transform(t -> {
            if (t.getMessage().equalsIgnoreCase("ERR no such key")) {
                return new NoSuchElementException(new String(this.marshaller.encode(key), StandardCharsets.UTF_8));
            }
            return t;
        });
    }

    Uni<Response> _renamenx(K key, K newKey) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.nonNull(newKey, (String)"newKey");
        return this.execute(RedisCommand.of(Command.RENAMENX).put(this.marshaller.encode(key)).put(this.marshaller.encode(newKey))).onFailure().transform(t -> {
            if (t.getMessage().equalsIgnoreCase("ERR no such key")) {
                return new NoSuchElementException(new String(this.marshaller.encode(key), StandardCharsets.UTF_8));
            }
            return t;
        });
    }

    Uni<Response> _touch(K ... keys) {
        Validation.notNullOrEmpty(keys, "keys");
        RedisCommand cmd = RedisCommand.of(Command.TOUCH);
        for (K key : keys) {
            cmd.put(this.marshaller.encode(key));
        }
        return this.execute(cmd);
    }

    Uni<Response> _ttl(K key) {
        ParameterValidation.nonNull(key, (String)"key");
        return this.execute(RedisCommand.of(Command.TTL).put(this.marshaller.encode(key)));
    }

    Uni<Response> _type(K key) {
        ParameterValidation.nonNull(key, (String)"key");
        return this.execute(RedisCommand.of(Command.TYPE).put(this.marshaller.encode(key)));
    }

    RedisValueType decodeRedisType(Response r) {
        return RedisValueType.valueOf(r.toString().toUpperCase());
    }

    Uni<Response> _unlink(K ... keys) {
        Validation.notNullOrEmpty(keys, "keys");
        RedisCommand cmd = RedisCommand.of(Command.UNLINK);
        for (K key : keys) {
            cmd.put(this.marshaller.encode(key));
        }
        return this.execute(cmd);
    }
}

