/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.datasource.search;

import java.util.ArrayList;
import java.util.List;

public class FieldOptions {
    private boolean sortable;
    private boolean unf;
    private boolean noStem;
    private boolean noIndex;
    private String phonetic;
    private double weight = -1.0;
    private char separator;
    private boolean caseSensitive;
    private boolean withSuffixTrie;

    public FieldOptions sortable() {
        this.sortable = true;
        return this;
    }

    public FieldOptions unf() {
        this.unf = true;
        return this;
    }

    public FieldOptions noStem() {
        this.noStem = true;
        return this;
    }

    public FieldOptions noIndex() {
        this.noIndex = true;
        return this;
    }

    public FieldOptions phonetic(String phonetic) {
        this.phonetic = phonetic;
        return this;
    }

    public FieldOptions weight(double weight) {
        this.weight = weight;
        return this;
    }

    public FieldOptions separator(char separator) {
        this.separator = separator;
        return this;
    }

    public FieldOptions caseSensitive() {
        this.caseSensitive = true;
        return this;
    }

    public FieldOptions withSuffixTrie() {
        this.withSuffixTrie = true;
        return this;
    }

    public List<String> toArgs() {
        ArrayList<String> list = new ArrayList<String>();
        if (this.sortable) {
            list.add("SORTABLE");
        }
        if (this.unf) {
            if (!this.sortable) {
                throw new IllegalArgumentException("Using `UNF` requires `SORTABLE`");
            }
            list.add("UNF");
        }
        if (this.noStem) {
            list.add("NOSTEM");
        }
        if (this.noIndex) {
            list.add("NOINDEX");
        }
        if (this.phonetic != null) {
            list.add("PHONETIC");
            list.add(this.phonetic);
        }
        if (this.weight != -1.0) {
            list.add("WEIGHT");
            list.add(Double.toString(this.weight));
        }
        if (this.separator != '\u0000') {
            list.add("SEPARATOR");
            list.add(Character.toString(this.separator));
        }
        if (this.caseSensitive) {
            list.add("CASESENSITIVE");
        }
        if (this.withSuffixTrie) {
            list.add("WITHSUFFIXTRIE");
        }
        return list;
    }
}

