/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.runtime.client.health;

import io.quarkus.arc.Arc;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.redis.client.RedisClientName;
import io.quarkus.redis.datasource.ReactiveRedisDataSource;
import io.quarkus.redis.datasource.RedisDataSource;
import io.quarkus.redis.runtime.client.config.RedisConfig;
import io.smallrye.mutiny.TimeoutException;
import io.vertx.mutiny.redis.client.Command;
import io.vertx.mutiny.redis.client.Redis;
import io.vertx.mutiny.redis.client.Request;
import io.vertx.mutiny.redis.client.Response;
import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.spi.Bean;
import java.lang.annotation.Annotation;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.eclipse.microprofile.health.HealthCheckResponseBuilder;
import org.eclipse.microprofile.health.Readiness;

@Readiness
@ApplicationScoped
class RedisHealthCheck
implements HealthCheck {
    private final Map<String, Redis> clients = new HashMap<String, Redis>();
    private final RedisConfig config;

    public RedisHealthCheck(RedisConfig config) {
        this.config = config;
    }

    @PostConstruct
    protected void init() {
        Redis redis;
        String clientName;
        for (InstanceHandle handle : Arc.container().select(Redis.class, new Annotation[]{Any.Literal.INSTANCE}).handles()) {
            clientName = this.getClientName((Bean<?>)handle.getBean());
            this.clients.putIfAbsent(clientName == null ? "<default>" : clientName, (Redis)handle.get());
        }
        for (InstanceHandle handle : Arc.container().select(ReactiveRedisDataSource.class, new Annotation[]{Any.Literal.INSTANCE}).handles()) {
            clientName = this.getClientName((Bean<?>)handle.getBean());
            redis = ((ReactiveRedisDataSource)handle.get()).getRedis();
            this.clients.putIfAbsent(clientName == null ? "<default>" : clientName, redis);
        }
        for (InstanceHandle handle : Arc.container().select(RedisDataSource.class, new Annotation[]{Any.Literal.INSTANCE}).handles()) {
            clientName = this.getClientName((Bean<?>)handle.getBean());
            redis = ((RedisDataSource)handle.get()).getReactive().getRedis();
            this.clients.putIfAbsent(clientName == null ? "<default>" : clientName, redis);
        }
    }

    private String getClientName(Bean<?> bean) {
        for (Object qualifier : bean.getQualifiers()) {
            if (!(qualifier instanceof RedisClientName)) continue;
            return ((RedisClientName)qualifier).value();
        }
        return null;
    }

    private Duration getTimeout(String name) {
        if (RedisConfig.isDefaultClient(name)) {
            return this.config.defaultRedisClient.timeout;
        }
        return this.config.namedRedisClients.get((Object)name).timeout;
    }

    public HealthCheckResponse call() {
        HealthCheckResponseBuilder builder = HealthCheckResponse.named((String)"Redis connection health check").up();
        for (Map.Entry<String, Redis> client : this.clients.entrySet()) {
            try {
                boolean isDefault = "<default>".equals(client.getKey());
                Redis redisClient = client.getValue();
                String redisClientName = isDefault ? "default" : client.getKey();
                Duration timeout = this.getTimeout(client.getKey());
                Response response = (Response)redisClient.send(Request.cmd((Command)Command.PING)).await().atMost(timeout);
                builder.up().withData(redisClientName, response.toString());
            }
            catch (TimeoutException e) {
                return builder.down().withData("reason", "client [" + client.getKey() + "]: timeout").build();
            }
            catch (Exception e) {
                if (e.getMessage() == null) {
                    return builder.down().withData("reason", "client [" + client.getKey() + "]: " + e).build();
                }
                return builder.down().withData("reason", "client [" + client.getKey() + "]: " + e.getMessage()).build();
            }
        }
        return builder.build();
    }
}

