/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.runtime.datasource;

import io.quarkus.redis.datasource.hash.HashScanCursor;
import io.quarkus.redis.datasource.hash.ReactiveHashScanCursor;
import java.time.Duration;
import java.util.Map;

public class HashScanBlockingCursorImpl<K, V>
implements HashScanCursor<K, V> {
    private final ReactiveHashScanCursor<K, V> reactive;
    private final Duration timeout;

    public HashScanBlockingCursorImpl(ReactiveHashScanCursor<K, V> reactive, Duration timeout) {
        this.timeout = timeout;
        this.reactive = reactive;
    }

    @Override
    public boolean hasNext() {
        return this.reactive.hasNext();
    }

    @Override
    public Map<K, V> next() {
        return (Map)this.reactive.next().await().atMost(this.timeout);
    }

    @Override
    public Iterable<Map.Entry<K, V>> toIterable() {
        return this.reactive.toMulti().subscribe().asIterable();
    }

    @Override
    public long cursorId() {
        return this.reactive.cursorId();
    }
}

