/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.runtime.datasource;

import io.quarkus.redis.datasource.geo.GeoAddArgs;
import io.quarkus.redis.datasource.geo.GeoItem;
import io.quarkus.redis.datasource.geo.GeoPosition;
import io.quarkus.redis.datasource.geo.GeoRadiusArgs;
import io.quarkus.redis.datasource.geo.GeoRadiusStoreArgs;
import io.quarkus.redis.datasource.geo.GeoSearchArgs;
import io.quarkus.redis.datasource.geo.GeoSearchStoreArgs;
import io.quarkus.redis.datasource.geo.GeoUnit;
import io.quarkus.redis.datasource.geo.ReactiveTransactionalGeoCommands;
import io.quarkus.redis.datasource.transactions.ReactiveTransactionalRedisDataSource;
import io.quarkus.redis.runtime.datasource.AbstractTransactionalCommands;
import io.quarkus.redis.runtime.datasource.ReactiveGeoCommandsImpl;
import io.quarkus.redis.runtime.datasource.TransactionHolder;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.vertx.mutiny.redis.client.Response;

public class ReactiveTransactionalGeoCommandsImpl<K, V>
extends AbstractTransactionalCommands
implements ReactiveTransactionalGeoCommands<K, V> {
    private final ReactiveGeoCommandsImpl<K, V> reactive;

    public ReactiveTransactionalGeoCommandsImpl(ReactiveTransactionalRedisDataSource ds, ReactiveGeoCommandsImpl<K, V> reactive, TransactionHolder tx) {
        super(ds, tx);
        this.reactive = reactive;
    }

    @Override
    public Uni<Void> geoadd(K key, double longitude, double latitude, V member) {
        return this.geoadd(key, longitude, latitude, member, ReactiveGeoCommandsImpl.DEFAULT_INSTANCE);
    }

    @Override
    public Uni<Void> geoadd(K key, GeoPosition position, V member) {
        ParameterValidation.nonNull((Object)position, (String)"position");
        return this.geoadd(key, position.longitude, position.latitude, member);
    }

    @Override
    public Uni<Void> geoadd(K key, GeoItem<V> item) {
        ParameterValidation.nonNull(item, (String)"item");
        return this.geoadd(key, item.longitude(), item.latitude(), item.member());
    }

    @Override
    public Uni<Void> geoadd(K key, GeoItem<V> ... items) {
        this.tx.enqueue(Response::toInteger);
        return this.reactive._geoadd(key, items).invoke(this::queuedOrDiscard).replaceWithVoid();
    }

    @Override
    public Uni<Void> geoadd(K key, double longitude, double latitude, V member, GeoAddArgs args) {
        this.tx.enqueue(r -> r.toLong() == 1L);
        return this.reactive._geoadd(key, longitude, latitude, member, args).invoke(this::queuedOrDiscard).replaceWithVoid();
    }

    @Override
    public Uni<Void> geoadd(K key, GeoItem<V> item, GeoAddArgs args) {
        ParameterValidation.nonNull(item, (String)"item");
        return this.geoadd(key, item.longitude(), item.latitude(), item.member(), args);
    }

    @Override
    public Uni<Void> geoadd(K key, GeoAddArgs args, GeoItem<V> ... items) {
        this.tx.enqueue(Response::toInteger);
        return this.reactive._geoadd(key, args, items).invoke(this::queuedOrDiscard).replaceWithVoid();
    }

    @Override
    public Uni<Void> geodist(K key, V from, V to, GeoUnit unit) {
        this.tx.enqueue(this.reactive::decodeDistance);
        return this.reactive._geodist(key, from, to, unit).invoke(this::queuedOrDiscard).replaceWithVoid();
    }

    @Override
    public Uni<Void> geohash(K key, V ... members) {
        this.tx.enqueue(this.reactive::decodeHashList);
        return this.reactive._geohash(key, members).invoke(this::queuedOrDiscard).replaceWithVoid();
    }

    @Override
    public Uni<Void> geopos(K key, V ... members) {
        this.tx.enqueue(this.reactive::decodeGeoPositions);
        return this.reactive._geopos(key, members).invoke(this::queuedOrDiscard).replaceWithVoid();
    }

    @Override
    @Deprecated
    public Uni<Void> georadius(K key, double longitude, double latitude, double radius, GeoUnit unit) {
        this.tx.enqueue(this.reactive::decodeRadiusSet);
        return this.reactive._georadius(key, longitude, latitude, radius, unit).invoke(this::queuedOrDiscard).replaceWithVoid();
    }

    @Override
    @Deprecated
    public Uni<Void> georadius(K key, GeoPosition position, double radius, GeoUnit unit) {
        ParameterValidation.nonNull((Object)position, (String)"position");
        return this.georadius(key, position.longitude, position.latitude, radius, unit);
    }

    @Override
    @Deprecated
    public Uni<Void> georadius(K key, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusArgs geoArgs) {
        this.tx.enqueue(r -> this.reactive.decodeAsListOfGeoValues((Response)r, geoArgs.hasDistance(), geoArgs.hasCoordinates(), geoArgs.hasHash()));
        return this.reactive._georadius(key, longitude, latitude, radius, unit, geoArgs).invoke(this::queuedOrDiscard).replaceWithVoid();
    }

    @Override
    @Deprecated
    public Uni<Void> georadius(K key, GeoPosition position, double radius, GeoUnit unit, GeoRadiusArgs geoArgs) {
        ParameterValidation.nonNull((Object)position, (String)"position");
        return this.georadius(key, position.longitude, position.latitude, radius, unit, geoArgs);
    }

    @Override
    @Deprecated
    public Uni<Void> georadius(K key, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusStoreArgs<K> geoArgs) {
        this.tx.enqueue(Response::toLong);
        return this.reactive._georadius(key, longitude, latitude, radius, unit, geoArgs).invoke(this::queuedOrDiscard).replaceWithVoid();
    }

    @Override
    @Deprecated
    public Uni<Void> georadius(K key, GeoPosition position, double radius, GeoUnit unit, GeoRadiusStoreArgs<K> geoArgs) {
        ParameterValidation.nonNull((Object)position, (String)"position");
        return this.georadius(key, position.longitude, position.latitude, radius, unit, geoArgs);
    }

    @Override
    @Deprecated
    public Uni<Void> georadiusbymember(K key, V member, double distance, GeoUnit unit) {
        this.tx.enqueue(this.reactive::decodeRadiusSet);
        return this.reactive._georadiusbymember(key, member, distance, unit).invoke(this::queuedOrDiscard).replaceWithVoid();
    }

    @Override
    @Deprecated
    public Uni<Void> georadiusbymember(K key, V member, double distance, GeoUnit unit, GeoRadiusArgs geoArgs) {
        this.tx.enqueue(r -> this.reactive.decodeAsListOfGeoValues((Response)r, geoArgs.hasDistance(), geoArgs.hasCoordinates(), geoArgs.hasHash()));
        return this.reactive._georadiusbymember(key, member, distance, unit, geoArgs).invoke(this::queuedOrDiscard).replaceWithVoid();
    }

    @Override
    @Deprecated
    public Uni<Void> georadiusbymember(K key, V member, double distance, GeoUnit unit, GeoRadiusStoreArgs<K> geoArgs) {
        this.tx.enqueue(Response::toLong);
        return this.reactive._georadiusbymember(key, member, distance, unit, geoArgs).invoke(this::queuedOrDiscard).replaceWithVoid();
    }

    @Override
    public Uni<Void> geosearch(K key, GeoSearchArgs<V> args) {
        this.tx.enqueue(r -> this.reactive.decodeAsListOfGeoValues((Response)r, args.hasDistance(), args.hasCoordinates(), args.hasHash()));
        return this.reactive._geosearch(key, args).invoke(this::queuedOrDiscard).replaceWithVoid();
    }

    @Override
    public Uni<Void> geosearchstore(K destination, K key, GeoSearchStoreArgs<V> args, boolean storeDist) {
        this.tx.enqueue(Response::toLong);
        return this.reactive._geosearchstore(destination, key, args, storeDist).invoke(this::queuedOrDiscard).replaceWithVoid();
    }
}

