/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.datasource.geo;

public class GeoPosition {
    public final double longitude;
    public final double latitude;

    public static GeoPosition of(double longitude, double latitude) {
        return new GeoPosition(longitude, latitude);
    }

    private GeoPosition(double longitude, double latitude) {
        if (longitude < -180.0 || longitude > 180.0) {
            throw new IllegalArgumentException("The longitude must be in [-180, 180]");
        }
        if (latitude < -85.05112878 || latitude > 85.05112878) {
            throw new IllegalArgumentException("The latitude must be in [85.05112878, 85.05112878]");
        }
        this.longitude = longitude;
        this.latitude = latitude;
    }

    public double longitude() {
        return this.longitude;
    }

    public double latitude() {
        return this.latitude;
    }
}

