/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.datasource.stream;

import io.quarkus.redis.datasource.RedisCommandExtraArguments;
import java.util.ArrayList;
import java.util.List;

public class XTrimArgs
implements RedisCommandExtraArguments {
    private long maxlen = -1L;
    private boolean approximateTrimming;
    private String minid;
    private long limit = -1L;

    public XTrimArgs maxlen(long maxlen) {
        this.maxlen = maxlen;
        return this;
    }

    public XTrimArgs nearlyExactTrimming() {
        this.approximateTrimming = true;
        return this;
    }

    public XTrimArgs minid(String minid) {
        this.minid = minid;
        return this;
    }

    public XTrimArgs limit(long limit) {
        this.limit = limit;
        return this;
    }

    @Override
    public List<String> toArgs() {
        ArrayList<String> args = new ArrayList<String>();
        if (this.maxlen > 0L) {
            if (this.minid != null) {
                throw new IllegalArgumentException("Cannot use `MAXLEN` and `MINID` together");
            }
            args.add("MAXLEN");
            if (this.approximateTrimming) {
                args.add("~");
            } else {
                args.add("=");
            }
            args.add(Long.toString(this.maxlen));
        }
        if (this.minid != null) {
            args.add("MINID");
            if (this.approximateTrimming) {
                args.add("~");
            } else {
                args.add("=");
            }
            args.add(this.minid);
        }
        if (this.limit > 0L) {
            if (!this.approximateTrimming) {
                throw new IllegalArgumentException("Cannot set the eviction limit when using exact trimming");
            }
            args.add("LIMIT");
            args.add(Long.toString(this.limit));
        }
        return args;
    }
}

