/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.runtime.datasource;

import io.quarkus.redis.datasource.stream.ReactiveTransactionalStreamCommands;
import io.quarkus.redis.datasource.stream.StreamRange;
import io.quarkus.redis.datasource.stream.TransactionalStreamCommands;
import io.quarkus.redis.datasource.stream.XAddArgs;
import io.quarkus.redis.datasource.stream.XClaimArgs;
import io.quarkus.redis.datasource.stream.XGroupCreateArgs;
import io.quarkus.redis.datasource.stream.XGroupSetIdArgs;
import io.quarkus.redis.datasource.stream.XReadArgs;
import io.quarkus.redis.datasource.stream.XReadGroupArgs;
import io.quarkus.redis.datasource.stream.XTrimArgs;
import io.quarkus.redis.datasource.transactions.TransactionalRedisDataSource;
import io.quarkus.redis.runtime.datasource.AbstractTransactionalRedisCommandGroup;
import java.time.Duration;
import java.util.Map;

public class BlockingTransactionalStreamCommandsImpl<K, F, V>
extends AbstractTransactionalRedisCommandGroup
implements TransactionalStreamCommands<K, F, V> {
    private final ReactiveTransactionalStreamCommands<K, F, V> reactive;

    public BlockingTransactionalStreamCommandsImpl(TransactionalRedisDataSource ds, ReactiveTransactionalStreamCommands<K, F, V> reactive, Duration timeout) {
        super(ds, timeout);
        this.reactive = reactive;
    }

    @Override
    public void xack(K key, String group, String ... ids) {
        this.reactive.xack(key, group, ids).await().atMost(this.timeout);
    }

    @Override
    public void xadd(K key, Map<F, V> payload) {
        this.reactive.xadd(key, payload).await().atMost(this.timeout);
    }

    @Override
    public void xadd(K key, XAddArgs args, Map<F, V> payload) {
        this.reactive.xadd(key, args, payload).await().atMost(this.timeout);
    }

    @Override
    public void xautoclaim(K key, String group, String consumer, Duration minIdleTime, String start) {
        this.reactive.xautoclaim(key, group, consumer, minIdleTime, start).await().atMost(this.timeout);
    }

    @Override
    public void xautoclaim(K key, String group, String consumer, Duration minIdleTime, String start, int count) {
        this.reactive.xautoclaim(key, group, consumer, minIdleTime, start, count).await().atMost(this.timeout);
    }

    @Override
    public void xautoclaim(K key, String group, String consumer, Duration minIdleTime, String start, int count, boolean justId) {
        this.reactive.xautoclaim(key, group, consumer, minIdleTime, start, count, justId).await().atMost(this.timeout);
    }

    @Override
    public void xclaim(K key, String group, String consumer, Duration minIdleTime, String ... id) {
        this.reactive.xclaim(key, group, consumer, minIdleTime, id).await().atMost(this.timeout);
    }

    @Override
    public void xclaim(K key, String group, String consumer, Duration minIdleTime, XClaimArgs args, String ... id) {
        this.reactive.xclaim(key, group, consumer, minIdleTime, args, id).await().atMost(this.timeout);
    }

    @Override
    public void xdel(K key, String ... id) {
        this.reactive.xdel(key, id).await().atMost(this.timeout);
    }

    @Override
    public void xgroupCreate(K key, String groupname, String from) {
        this.reactive.xgroupCreate(key, groupname, from).await().atMost(this.timeout);
    }

    @Override
    public void xgroupCreate(K key, String groupname, String from, XGroupCreateArgs args) {
        this.reactive.xgroupCreate(key, groupname, from, args).await().atMost(this.timeout);
    }

    @Override
    public void xgroupCreateConsumer(K key, String groupname, String consumername) {
        this.reactive.xgroupCreateConsumer(key, groupname, consumername).await().atMost(this.timeout);
    }

    @Override
    public void xgroupDelConsumer(K key, String groupname, String consumername) {
        this.reactive.xgroupDelConsumer(key, groupname, consumername).await().atMost(this.timeout);
    }

    @Override
    public void xgroupDestroy(K key, String groupname) {
        this.reactive.xgroupDestroy(key, groupname).await().atMost(this.timeout);
    }

    @Override
    public void xgroupSetId(K key, String groupname, String from) {
        this.reactive.xgroupSetId(key, groupname, from).await().atMost(this.timeout);
    }

    @Override
    public void xgroupSetId(K key, String groupname, String from, XGroupSetIdArgs args) {
        this.reactive.xgroupSetId(key, groupname, from, args).await().atMost(this.timeout);
    }

    @Override
    public void xlen(K key) {
        this.reactive.xlen(key).await().atMost(this.timeout);
    }

    @Override
    public void xrange(K key, StreamRange range, int count) {
        this.reactive.xrange(key, range, count).await().atMost(this.timeout);
    }

    @Override
    public void xrange(K key, StreamRange range) {
        this.reactive.xrange(key, range).await().atMost(this.timeout);
    }

    @Override
    public void xread(K key, String id) {
        this.reactive.xread(key, id).await().atMost(this.timeout);
    }

    @Override
    public void xread(Map<K, String> lastIdsPerStream) {
        this.reactive.xread(lastIdsPerStream).await().atMost(this.timeout);
    }

    @Override
    public void xread(K key, String id, XReadArgs args) {
        this.reactive.xread(key, id, args).await().atMost(this.timeout);
    }

    @Override
    public void xread(Map<K, String> lastIdsPerStream, XReadArgs args) {
        this.reactive.xread(lastIdsPerStream, args).await().atMost(this.timeout);
    }

    @Override
    public void xreadgroup(String group, String consumer, K key, String id) {
        this.reactive.xreadgroup(group, consumer, key, id).await().atMost(this.timeout);
    }

    @Override
    public void xreadgroup(String group, String consumer, Map<K, String> lastIdsPerStream) {
        this.reactive.xreadgroup(group, consumer, lastIdsPerStream).await().atMost(this.timeout);
    }

    @Override
    public void xreadgroup(String group, String consumer, K key, String id, XReadGroupArgs args) {
        this.reactive.xreadgroup(group, consumer, key, id, args).await().atMost(this.timeout);
    }

    @Override
    public void xreadgroup(String group, String consumer, Map<K, String> lastIdsPerStream, XReadGroupArgs args) {
        this.reactive.xreadgroup(group, consumer, lastIdsPerStream, args).await().atMost(this.timeout);
    }

    @Override
    public void xrevrange(K key, StreamRange range, int count) {
        this.reactive.xrevrange(key, range, count).await().atMost(this.timeout);
    }

    @Override
    public void xrevrange(K key, StreamRange range) {
        this.reactive.xrevrange(key, range).await().atMost(this.timeout);
    }

    @Override
    public void xtrim(K key, String threshold) {
        this.reactive.xtrim(key, threshold).await().atMost(this.timeout);
    }

    @Override
    public void xtrim(K key, XTrimArgs args) {
        this.reactive.xtrim(key, args).await().atMost(this.timeout);
    }
}

