/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.runtime.datasource;

import io.quarkus.redis.datasource.codecs.Codec;
import io.quarkus.redis.datasource.codecs.Codecs;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.vertx.mutiny.redis.client.Response;
import io.vertx.redis.client.ResponseType;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public class Marshaller {
    private static final Map<Class<?>, Codec<?>> DEFAULT_CODECS = Map.of(String.class, Codecs.StringCodec.INSTANCE, Integer.class, Codecs.IntegerCodec.INSTANCE, Double.class, Codecs.DoubleCodec.INSTANCE);
    Map<Class<?>, Codec<?>> codecs = new ConcurrentHashMap();

    public Marshaller(Class<?> ... hints) {
        this.addAll(hints);
    }

    public void addAll(Class<?> ... hints) {
        ParameterValidation.doesNotContainNull((Object[])hints, (String)"hints");
        for (Class<?> hint : hints) {
            this.codecs.computeIfAbsent(hint, h -> Codecs.getDefaultCodecFor(hint));
        }
    }

    public void add(Class<?> hint) {
        this.codecs.computeIfAbsent(hint, h -> Codecs.getDefaultCodecFor(hint));
    }

    public byte[] encode(Object o) {
        if (o instanceof String) {
            return ((String)o).getBytes(StandardCharsets.UTF_8);
        }
        if (o == null) {
            return null;
        }
        Class<?> clazz = o.getClass();
        Codec<?> codec = this.codec(clazz);
        if (codec == null) {
            codec = new Codecs.JsonCodec(clazz);
            this.codecs.put(clazz, codec);
        }
        return codec.encode(o);
    }

    @SafeVarargs
    public final <T> List<byte[]> encode(T ... objects) {
        ParameterValidation.nonNull(objects, (String)"objects");
        ArrayList<byte[]> result = new ArrayList<byte[]>();
        for (T o : objects) {
            byte[] r = this.encode((Object)o);
            result.add(r);
        }
        return result;
    }

    Codec<?> codec(Class<?> clazz) {
        Codec<?> codec = this.codecs.get(clazz);
        if (codec == null) {
            codec = DEFAULT_CODECS.get(clazz);
        }
        return codec;
    }

    public final <T> T decode(Class<T> clazz, Response r) {
        if (r == null) {
            return null;
        }
        if (r.type() == ResponseType.SIMPLE) {
            return this.decode(clazz, r.toString().getBytes());
        }
        return this.decode(clazz, r.toBytes());
    }

    public final <T> T decode(Class<T> clazz, byte[] r) {
        if (r == null) {
            return null;
        }
        Codec<?> codec = this.codec(clazz);
        return (T)codec.decode(r);
    }

    public <F, V> Map<F, V> decodeAsMap(Response response, Class<F> typeOfField, Class<V> typeOfValue) {
        if (response == null || response.size() == 0) {
            return Collections.emptyMap();
        }
        LinkedHashMap<F, V> map = new LinkedHashMap<F, V>();
        if (((Response)response.iterator().next()).type() == ResponseType.BULK) {
            Object current = null;
            for (Response member : response) {
                if (current == null) {
                    current = this.decode(typeOfField, member.toString().getBytes(StandardCharsets.UTF_8));
                    continue;
                }
                V val = this.decode(typeOfValue, member);
                map.put(current, val);
                current = null;
            }
        } else {
            for (Response member : response) {
                for (String key : member.getKeys()) {
                    F field = this.decode(typeOfField, key.getBytes(StandardCharsets.UTF_8));
                    V val = this.decode(typeOfValue, response.get(key));
                    map.put(field, val);
                }
            }
        }
        return map;
    }

    public <F> List<F> decodeAsList(Response response, Class<F> typeOfItem) {
        if (response == null) {
            return Collections.emptyList();
        }
        ArrayList<F> list = new ArrayList<F>();
        for (Response item : response) {
            list.add(this.decode(typeOfItem, item));
        }
        return list;
    }

    public <T> List<T> decodeAsList(Response response, Function<Response, T> mapper) {
        if (response == null) {
            return Collections.emptyList();
        }
        ArrayList<T> list = new ArrayList<T>();
        for (Response item : response) {
            if (item == null) {
                list.add(null);
                continue;
            }
            list.add(mapper.apply(item));
        }
        return list;
    }

    public <F> Set<F> decodeAsSet(Response response, Class<F> typeOfItem) {
        if (response == null) {
            return Collections.emptySet();
        }
        HashSet<F> set = new HashSet<F>();
        for (Response item : response) {
            set.add(this.decode(typeOfItem, item));
        }
        return set;
    }

    final <F, V> Map<F, V> decodeAsOrderedMap(Response response, Class<V> typeOfValue, F[] fields) {
        Iterator iterator = response.iterator();
        LinkedHashMap<F, V> map = new LinkedHashMap<F, V>();
        for (F field : fields) {
            Response v = (Response)iterator.next();
            map.put(field, this.decode(typeOfValue, v));
        }
        return map;
    }
}

