/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.runtime.datasource;

import io.quarkus.redis.datasource.RedisDataSource;
import io.quarkus.redis.datasource.countmin.CountMinCommands;
import io.quarkus.redis.datasource.countmin.ReactiveCountMinCommands;
import io.quarkus.redis.runtime.datasource.AbstractRedisCommandGroup;
import java.time.Duration;
import java.util.List;
import java.util.Map;

public class BlockingCountMinCommandsImpl<K, V>
extends AbstractRedisCommandGroup
implements CountMinCommands<K, V> {
    private final ReactiveCountMinCommands<K, V> reactive;

    public BlockingCountMinCommandsImpl(RedisDataSource ds, ReactiveCountMinCommands<K, V> reactive, Duration timeout) {
        super(ds, timeout);
        this.reactive = reactive;
    }

    @Override
    public long cmsIncrBy(K key, V value, long increment) {
        return (Long)this.reactive.cmsIncrBy(key, value, increment).await().atMost(this.timeout);
    }

    @Override
    public Map<V, Long> cmsIncrBy(K key, Map<V, Long> couples) {
        return (Map)this.reactive.cmsIncrBy(key, couples).await().atMost(this.timeout);
    }

    @Override
    public void cmsInitByDim(K key, long width, long depth) {
        this.reactive.cmsInitByDim(key, width, depth).await().atMost(this.timeout);
    }

    @Override
    public void cmsInitByProb(K key, double error, double probability) {
        this.reactive.cmsInitByProb(key, error, probability).await().atMost(this.timeout);
    }

    @Override
    public long cmsQuery(K key, V item) {
        return (Long)this.reactive.cmsQuery(key, item).await().atMost(this.timeout);
    }

    @Override
    public List<Long> cmsQuery(K key, V ... items) {
        return (List)this.reactive.cmsQuery(key, items).await().atMost(this.timeout);
    }

    @Override
    public void cmsMerge(K dest, List<K> src, List<Integer> weight) {
        this.reactive.cmsMerge(dest, src, weight).await().atMost(this.timeout);
    }
}

