/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.datasource.stream;

import io.quarkus.redis.datasource.RedisCommandExtraArguments;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;

public class XClaimArgs
implements RedisCommandExtraArguments {
    private Duration idle;
    private long time = -1L;
    private int retryCount = -1;
    private boolean force;
    private boolean justId;
    private String lastId;

    public XClaimArgs idle(Duration idle) {
        this.idle = idle;
        return this;
    }

    public XClaimArgs time(long time) {
        this.time = time;
        return this;
    }

    public XClaimArgs retryCount(int retryCount) {
        this.retryCount = retryCount;
        return this;
    }

    public XClaimArgs force() {
        this.force = true;
        return this;
    }

    public XClaimArgs justId() {
        this.justId = true;
        return this;
    }

    public XClaimArgs lastId(String lastId) {
        this.lastId = lastId;
        return this;
    }

    @Override
    public List<String> toArgs() {
        ArrayList<String> args = new ArrayList<String>();
        if (this.idle != null) {
            args.add("IDLE");
            args.add(Long.toString(this.idle.toMillis()));
            if (this.time > 0L) {
                throw new IllegalStateException("Cannot combine `IDLE` and `TIME`");
            }
        }
        if (this.time > 0L) {
            args.add("TIME");
            args.add(Long.toString(this.time));
        }
        if (this.retryCount > 0) {
            args.add("RETRYCOUNT");
            args.add(Integer.toString(this.retryCount));
        }
        if (this.force) {
            args.add("FORCE");
        }
        if (this.justId) {
            args.add("JUSTID");
        }
        if (this.lastId != null) {
            args.add("LASTID");
            args.add(this.lastId);
        }
        return args;
    }
}

