/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.runtime.datasource;

import io.quarkus.redis.datasource.cuckoo.CfInsertArgs;
import io.quarkus.redis.datasource.cuckoo.CfReserveArgs;
import io.quarkus.redis.runtime.datasource.AbstractRedisCommands;
import io.quarkus.redis.runtime.datasource.Marshaller;
import io.quarkus.redis.runtime.datasource.RedisCommand;
import io.quarkus.redis.runtime.datasource.RedisCommandExecutor;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.vertx.mutiny.redis.client.Command;
import io.vertx.mutiny.redis.client.Response;

public class AbstractCuckooCommands<K, V>
extends AbstractRedisCommands {
    AbstractCuckooCommands(RedisCommandExecutor redis, Class<K> k, Class<V> v) {
        super(redis, new Marshaller(k, v));
    }

    Uni<Response> _cfadd(K key, V value) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.nonNull(value, (String)"value");
        RedisCommand cmd = RedisCommand.of(Command.CF_ADD).put(this.marshaller.encode(key)).put(this.marshaller.encode(value));
        return this.execute(cmd);
    }

    Uni<Response> _cfaddnx(K key, V value) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.nonNull(value, (String)"value");
        RedisCommand cmd = RedisCommand.of(Command.CF_ADDNX).put(this.marshaller.encode(key)).put(this.marshaller.encode(value));
        return this.execute(cmd);
    }

    Uni<Response> _cfcount(K key, V value) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.nonNull(value, (String)"value");
        RedisCommand cmd = RedisCommand.of(Command.CF_COUNT).put(this.marshaller.encode(key)).put(this.marshaller.encode(value));
        return this.execute(cmd);
    }

    Uni<Response> _cfdel(K key, V value) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.nonNull(value, (String)"value");
        RedisCommand cmd = RedisCommand.of(Command.CF_DEL).put(this.marshaller.encode(key)).put(this.marshaller.encode(value));
        return this.execute(cmd);
    }

    Uni<Response> _cfexists(K key, V value) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.nonNull(value, (String)"value");
        RedisCommand cmd = RedisCommand.of(Command.CF_EXISTS).put(this.marshaller.encode(key)).put(this.marshaller.encode(value));
        return this.execute(cmd);
    }

    Uni<Response> _cfinsert(K key, V ... values) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.doesNotContainNull((Object[])values, (String)"values");
        if (values.length == 0) {
            throw new IllegalArgumentException("`values` must contain at least one item");
        }
        RedisCommand cmd = RedisCommand.of(Command.CF_INSERT).put(this.marshaller.encode(key));
        for (V value : values) {
            cmd.put(this.marshaller.encode(value));
        }
        return this.execute(cmd);
    }

    Uni<Response> _cfinsert(K key, CfInsertArgs args, V ... values) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.nonNull((Object)args, (String)"args");
        ParameterValidation.doesNotContainNull((Object[])values, (String)"values");
        if (values.length == 0) {
            throw new IllegalArgumentException("`values` must contain at least one item");
        }
        RedisCommand cmd = RedisCommand.of(Command.CF_INSERT).put(this.marshaller.encode(key)).putArgs(args).put("ITEMS");
        for (V value : values) {
            cmd.put(this.marshaller.encode(value));
        }
        return this.execute(cmd);
    }

    Uni<Response> _cfinsertnx(K key, V ... values) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.doesNotContainNull((Object[])values, (String)"values");
        if (values.length == 0) {
            throw new IllegalArgumentException("`values` must contain at least one item");
        }
        RedisCommand cmd = RedisCommand.of(Command.CF_INSERTNX).put(this.marshaller.encode(key)).put("ITEMS");
        for (V value : values) {
            cmd.put(this.marshaller.encode(value));
        }
        return this.execute(cmd);
    }

    Uni<Response> _cfinsertnx(K key, CfInsertArgs args, V ... values) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.doesNotContainNull((Object[])values, (String)"values");
        ParameterValidation.nonNull((Object)args, (String)"args");
        if (values.length == 0) {
            throw new IllegalArgumentException("`values` must contain at least one item");
        }
        RedisCommand cmd = RedisCommand.of(Command.CF_INSERTNX).put(this.marshaller.encode(key)).putArgs(args).put("ITEMS");
        for (V value : values) {
            cmd.put(this.marshaller.encode(value));
        }
        return this.execute(cmd);
    }

    Uni<Response> _cfmexists(K key, V ... values) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.doesNotContainNull((Object[])values, (String)"values");
        if (values.length == 0) {
            throw new IllegalArgumentException("`values` must contain at least one item");
        }
        RedisCommand cmd = RedisCommand.of(Command.CF_MEXISTS).put(this.marshaller.encode(key));
        for (V value : values) {
            cmd.put(this.marshaller.encode(value));
        }
        return this.execute(cmd);
    }

    Uni<Response> _cfreserve(K key, long capacity) {
        ParameterValidation.nonNull(key, (String)"key");
        RedisCommand cmd = RedisCommand.of(Command.CF_RESERVE).put(this.marshaller.encode(key)).put(capacity);
        return this.execute(cmd);
    }

    Uni<Response> _cfreserve(K key, long capacity, CfReserveArgs args) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.nonNull((Object)args, (String)"args");
        RedisCommand cmd = RedisCommand.of(Command.CF_RESERVE).put(this.marshaller.encode(key)).put(capacity).putArgs(args);
        return this.execute(cmd);
    }
}

