/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.datasource.bloom;

import io.quarkus.redis.datasource.RedisCommandExtraArguments;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public class BfInsertArgs
implements RedisCommandExtraArguments {
    private long capacity;
    private double errorRate = -1.0;
    private boolean nocreate;
    private boolean nonScaling;
    private int expansion;

    public BfInsertArgs capacity(long capacity) {
        this.capacity = capacity;
        return this;
    }

    public BfInsertArgs errorRate(double errorRate) {
        this.errorRate = errorRate;
        return this;
    }

    public BfInsertArgs nocreate() {
        this.nocreate = true;
        return this;
    }

    public BfInsertArgs nonScaling() {
        this.nonScaling = true;
        return this;
    }

    public BfInsertArgs expansion(int expansion) {
        if (expansion <= 0) {
            throw new IllegalArgumentException("the expansion factory must be positive");
        }
        this.expansion = expansion;
        return this;
    }

    @Override
    public List<Object> toArgs() {
        ArrayList<Object> list = new ArrayList<Object>();
        if (this.capacity > 0L) {
            list.add("CAPACITY");
            list.add(Long.toString(this.capacity));
        }
        if (this.errorRate != -1.0) {
            list.add("ERROR");
            list.add(new BigDecimal(this.errorRate).toPlainString());
        }
        if (this.expansion > 0) {
            list.add("EXPANSION");
            list.add(Integer.toString(this.expansion));
        }
        if (this.nocreate) {
            list.add("NOCREATE");
        }
        if (this.nonScaling) {
            list.add("NONSCALING");
        }
        return list;
    }
}

