/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.datasource.codecs;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.quarkus.redis.datasource.codecs.Codec;
import io.quarkus.vertx.runtime.jackson.QuarkusJacksonJsonCodec;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.Json;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Stream;

public class Codecs {
    private static final List<Codec> CODECS = new CopyOnWriteArrayList<ByteArrayCodec>(List.of(StringCodec.INSTANCE, DoubleCodec.INSTANCE, IntegerCodec.INSTANCE, ByteArrayCodec.INSTANCE));

    private Codecs() {
    }

    public static void register(Codec codec) {
        CODECS.add(Objects.requireNonNull(codec));
    }

    public static void register(Stream<Codec> codecs) {
        codecs.forEach(Codecs::register);
    }

    public static Codec getDefaultCodecFor(Type type) {
        for (Codec codec : CODECS) {
            if (!codec.canHandle(type)) continue;
            return codec;
        }
        return new JsonCodec(type);
    }

    public static class JsonCodec
    implements Codec {
        private final TypeReference<?> type;
        private final Class<?> clazz;
        private final ObjectMapper mapper;

        public JsonCodec(final Type clazz) {
            if (clazz instanceof Class) {
                this.clazz = (Class)clazz;
                this.type = null;
            } else {
                this.type = new TypeReference<Object>(){

                    public Type getType() {
                        return clazz;
                    }
                };
                this.clazz = null;
            }
            this.mapper = QuarkusJacksonJsonCodec.mapper();
        }

        @Override
        public boolean canHandle(Type clazz) {
            throw new UnsupportedOperationException("Should not be called, the JSON codec is the fallback");
        }

        @Override
        public byte[] encode(Object item) {
            return Json.encodeToBuffer((Object)item).getBytes();
        }

        @Override
        public Object decode(byte[] payload) {
            try {
                if (this.clazz != null) {
                    return Json.decodeValue((Buffer)Buffer.buffer((byte[])payload), this.clazz);
                }
                return this.mapper.readValue(payload, this.type);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class StringCodec
    implements Codec {
        public static StringCodec INSTANCE = new StringCodec();

        private StringCodec() {
        }

        @Override
        public boolean canHandle(Type clazz) {
            return clazz.equals(String.class);
        }

        @Override
        public byte[] encode(Object item) {
            return ((String)item).getBytes(StandardCharsets.UTF_8);
        }

        @Override
        public String decode(byte[] item) {
            return new String(item, StandardCharsets.UTF_8);
        }
    }

    public static class DoubleCodec
    implements Codec {
        public static DoubleCodec INSTANCE = new DoubleCodec();

        private DoubleCodec() {
        }

        @Override
        public boolean canHandle(Type clazz) {
            return clazz.equals(Double.class) || clazz.equals(Double.TYPE);
        }

        @Override
        public byte[] encode(Object item) {
            if (item == null) {
                return null;
            }
            return Double.toString((Double)item).getBytes(StandardCharsets.UTF_8);
        }

        @Override
        public Double decode(byte[] item) {
            if (item == null) {
                return 0.0;
            }
            return Double.parseDouble(new String(item, StandardCharsets.UTF_8));
        }
    }

    public static class IntegerCodec
    implements Codec {
        public static IntegerCodec INSTANCE = new IntegerCodec();

        private IntegerCodec() {
        }

        @Override
        public boolean canHandle(Type clazz) {
            return clazz.equals(Integer.class) || clazz.equals(Integer.TYPE);
        }

        @Override
        public byte[] encode(Object item) {
            if (item == null) {
                return null;
            }
            return Integer.toString((Integer)item).getBytes(StandardCharsets.UTF_8);
        }

        @Override
        public Integer decode(byte[] item) {
            if (item == null) {
                return 0;
            }
            return Integer.parseInt(new String(item, StandardCharsets.UTF_8));
        }
    }

    public static class ByteArrayCodec
    implements Codec {
        public static ByteArrayCodec INSTANCE = new ByteArrayCodec();

        private ByteArrayCodec() {
        }

        @Override
        public boolean canHandle(Type clazz) {
            return clazz.equals(byte[].class);
        }

        @Override
        public byte[] encode(Object item) {
            return (byte[])item;
        }

        public byte[] decode(byte[] item) {
            return item;
        }
    }
}

