/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.datasource.timeseries;

import io.quarkus.redis.datasource.RedisCommandExtraArguments;
import io.quarkus.redis.datasource.timeseries.Aggregation;
import io.quarkus.redis.datasource.timeseries.BucketTimestamp;
import io.quarkus.redis.datasource.timeseries.Reducer;
import io.smallrye.mutiny.helpers.ParameterValidation;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class MRangeArgs
implements RedisCommandExtraArguments {
    private boolean latest;
    private List<Long> filterByTimestamps;
    private boolean filterByValue;
    private double min;
    private double max;
    private boolean withLabels;
    private String[] selectedLabels;
    private int count = -1;
    private String align;
    private Aggregation aggregation;
    private long bucketDuration;
    private BucketTimestamp bucketTimestamp;
    private boolean empty;
    private String groupByLabel;
    private Reducer reducer;

    public MRangeArgs latest() {
        this.latest = true;
        return this;
    }

    public MRangeArgs filterByTimestamp(long ... timestamps) {
        if (this.filterByTimestamps == null) {
            this.filterByTimestamps = new ArrayList<Long>(timestamps.length);
        }
        for (long timestamp : timestamps) {
            if (timestamp < 0L) {
                throw new IllegalArgumentException("The timestamp must be positive");
            }
            this.filterByTimestamps.add(timestamp);
        }
        return this;
    }

    public MRangeArgs filterByValue(double min, double max) {
        this.filterByValue = true;
        this.min = min;
        this.max = max;
        return this;
    }

    public MRangeArgs withLabels() {
        this.withLabels = true;
        return this;
    }

    public MRangeArgs selectedLabels(String ... labels) {
        ParameterValidation.doesNotContainNull((Object[])labels, (String)"labels");
        this.selectedLabels = labels;
        return this;
    }

    public MRangeArgs count(int count) {
        this.count = count;
        return this;
    }

    public MRangeArgs align(long timestamp) {
        this.align = Long.toString(timestamp);
        return this;
    }

    public MRangeArgs alignUsingRangeStart() {
        this.align = "-";
        return this;
    }

    public MRangeArgs alignUsingRangeEnd() {
        this.align = "+";
        return this;
    }

    public MRangeArgs aggregation(Aggregation aggregation, Duration bucketDuration) {
        this.aggregation = (Aggregation)((Object)ParameterValidation.nonNull((Object)((Object)aggregation), (String)"aggregation"));
        this.bucketDuration = ParameterValidation.positive((long)((Duration)ParameterValidation.nonNull((Object)bucketDuration, (String)"bucketDuration")).toMillis(), (String)"bucketDuration");
        return this;
    }

    public MRangeArgs bucketTimestamp(BucketTimestamp ts) {
        this.bucketTimestamp = ts;
        return this;
    }

    public MRangeArgs empty() {
        this.empty = true;
        return this;
    }

    public MRangeArgs groupBy(String label, Reducer reducer) {
        this.groupByLabel = (String)ParameterValidation.nonNull((Object)label, (String)"label");
        this.reducer = (Reducer)((Object)ParameterValidation.nonNull((Object)((Object)reducer), (String)"reducer"));
        return this;
    }

    @Override
    public List<Object> toArgs() {
        ArrayList<Object> list = new ArrayList<Object>();
        if (this.latest) {
            list.add("LATEST");
        }
        if (this.filterByTimestamps != null && !this.filterByTimestamps.isEmpty()) {
            list.add("FILTER_BY_TS");
            for (Long ts : this.filterByTimestamps) {
                list.add(Long.toString(ts));
            }
        }
        if (this.filterByValue) {
            list.add("FILTER_BY_VALUE");
            list.add(Double.toString(this.min));
            list.add(Double.toString(this.max));
        }
        if (this.withLabels) {
            list.add("WITHLABELS");
        }
        if (this.selectedLabels != null && this.selectedLabels.length != 0) {
            if (this.withLabels) {
                throw new IllegalArgumentException("Cannot combine `WITHLABELS` and `SELECTED_LABELS`");
            }
            list.add("SELECTED_LABELS");
            list.addAll(Arrays.asList(this.selectedLabels));
        }
        if (this.count != -1) {
            list.add("COUNT");
            list.add(Integer.toString(this.count));
        }
        if (this.aggregation != null) {
            if (this.align != null) {
                list.add("ALIGN");
                list.add(this.align);
            }
            list.add("AGGREGATION");
            list.add(this.aggregation.toString());
            list.add(Long.toString(this.bucketDuration));
            if (this.bucketTimestamp != null) {
                list.add("BUCKETTIMESTAMP");
                list.add(this.bucketTimestamp.toString().toLowerCase());
            }
            if (this.empty) {
                list.add("EMPTY");
            }
        }
        return list;
    }

    public List<String> getGroupByClauseArgs() {
        if (this.groupByLabel == null) {
            return List.of();
        }
        return List.of("GROUPBY", this.groupByLabel, "REDUCE", this.reducer.toString());
    }
}

