/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.datasource.string;

import io.quarkus.redis.datasource.RedisCommandExtraArguments;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;

@Deprecated
public class SetArgs
extends io.quarkus.redis.datasource.value.SetArgs
implements RedisCommandExtraArguments {
    private long ex = -1L;
    private long exAt = -1L;
    private long px = -1L;
    private long pxAt = -1L;
    private boolean nx;
    private boolean keepttl;
    private boolean xx;
    private boolean get;

    @Override
    public SetArgs ex(long timeout) {
        if (timeout <= 0L) {
            throw new IllegalArgumentException("`timeout` must be positive");
        }
        this.ex = timeout;
        return this;
    }

    @Override
    public SetArgs ex(Duration timeout) {
        if (timeout == null) {
            throw new IllegalArgumentException("`timeout` must not be `null`");
        }
        return this.ex(timeout.toMillis() / 1000L);
    }

    @Override
    public SetArgs exAt(long timestamp) {
        this.exAt = timestamp;
        return this;
    }

    @Override
    public SetArgs exAt(Instant timestamp) {
        if (timestamp == null) {
            throw new IllegalArgumentException("`timestamp` must not be `null`");
        }
        this.exAt(timestamp.toEpochMilli() / 1000L);
        return this;
    }

    @Override
    public SetArgs px(long timeout) {
        if (timeout < 0L) {
            throw new IllegalArgumentException("`timeout` must be positive");
        }
        this.px = timeout;
        return this;
    }

    @Override
    public SetArgs px(Duration timeout) {
        if (timeout == null) {
            throw new IllegalArgumentException("`timeout` must not be `null`");
        }
        return this.px(timeout.toMillis());
    }

    @Override
    public SetArgs pxAt(long timestamp) {
        this.pxAt = timestamp;
        return this;
    }

    @Override
    public SetArgs pxAt(Instant timestamp) {
        if (timestamp == null) {
            throw new IllegalArgumentException("`timestamp` must not be `null`");
        }
        return this.pxAt(timestamp.toEpochMilli());
    }

    @Override
    public SetArgs nx() {
        this.nx = true;
        return this;
    }

    @Override
    public SetArgs keepttl() {
        this.keepttl = true;
        return this;
    }

    @Override
    public SetArgs xx() {
        this.xx = true;
        return this;
    }

    @Override
    public SetArgs get() {
        this.get = true;
        return this;
    }

    @Override
    public List<Object> toArgs() {
        ArrayList<Object> args = new ArrayList<Object>();
        if (this.ex >= 0L) {
            args.add("EX");
            args.add(Long.toString(this.ex));
        }
        if (this.exAt >= 0L) {
            args.add("EXAT");
            args.add(Long.toString(this.exAt));
        }
        if (this.px >= 0L) {
            args.add("PX");
            args.add(Long.toString(this.px));
        }
        if (this.pxAt >= 0L) {
            args.add("PXAT");
            args.add(Long.toString(this.pxAt));
        }
        if (this.nx) {
            args.add("NX");
        }
        if (this.xx) {
            args.add("XX");
        }
        if (this.keepttl) {
            args.add("KEEPTTL");
        }
        if (this.get) {
            args.add("GET");
        }
        return args;
    }
}

