/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.runtime.client.config;

import io.quarkus.redis.runtime.client.config.NetConfig;
import io.quarkus.redis.runtime.client.config.TlsConfig;
import io.quarkus.runtime.annotations.ConfigDocDefault;
import io.quarkus.runtime.annotations.ConfigDocSection;
import io.quarkus.runtime.annotations.ConfigGroup;
import io.smallrye.config.WithDefault;
import io.vertx.redis.client.ProtocolVersion;
import io.vertx.redis.client.RedisClientType;
import io.vertx.redis.client.RedisClusterTransactions;
import io.vertx.redis.client.RedisReplicas;
import io.vertx.redis.client.RedisRole;
import io.vertx.redis.client.RedisTopology;
import java.net.URI;
import java.time.Duration;
import java.util.Optional;
import java.util.Set;

@ConfigGroup
public interface RedisClientConfig {
    public Optional<Set<URI>> hosts();

    public Optional<String> hostsProviderName();

    @WithDefault(value="10s")
    public Duration timeout();

    @WithDefault(value="standalone")
    public RedisClientType clientType();

    @ConfigDocDefault(value="mymaster")
    public Optional<String> masterName();

    @ConfigDocDefault(value="master")
    public Optional<RedisRole> role();

    @ConfigDocDefault(value="never")
    public Optional<RedisReplicas> replicas();

    public Optional<String> password();

    @WithDefault(value="6")
    public int maxPoolSize();

    @WithDefault(value="24")
    public int maxPoolWaiting();

    @ConfigDocDefault(value="30s")
    public Optional<Duration> poolCleanerInterval();

    @WithDefault(value="3m")
    public Optional<Duration> poolRecycleTimeout();

    @WithDefault(value="2048")
    public int maxWaitingHandlers();

    @WithDefault(value="32")
    public int maxNestedArrays();

    @WithDefault(value="0")
    public int reconnectAttempts();

    @WithDefault(value="1")
    public Duration reconnectInterval();

    @WithDefault(value="true")
    public boolean protocolNegotiation();

    @ConfigDocDefault(value="resp3")
    public Optional<ProtocolVersion> preferredProtocolVersion();

    @WithDefault(value="1s")
    public Duration hashSlotCacheTtl();

    @WithDefault(value="false")
    public boolean autoFailover();

    @ConfigDocDefault(value="discover")
    public Optional<RedisTopology> topology();

    @ConfigDocDefault(value="disabled")
    public Optional<RedisClusterTransactions> clusterTransactions();

    @ConfigDocSection
    public NetConfig tcp();

    @ConfigDocSection
    public TlsConfig tls();

    public Optional<String> clientName();

    @WithDefault(value="false")
    public Boolean configureClientName();

    public Optional<String> tlsConfigurationName();

    default public String toDebugString() {
        return "RedisClientConfig{hosts=" + String.valueOf(this.hosts()) + ", hostsProviderName=" + String.valueOf(this.hostsProviderName()) + ", timeout=" + String.valueOf(this.timeout()) + ", clientType=" + String.valueOf(this.clientType()) + ", masterName=" + String.valueOf(this.masterName()) + ", role=" + String.valueOf(this.role()) + ", replicas=" + String.valueOf(this.replicas()) + ", password=" + String.valueOf(this.password()) + ", maxPoolSize=" + this.maxPoolSize() + ", maxPoolWaiting=" + this.maxPoolWaiting() + ", poolCleanerInterval=" + String.valueOf(this.poolCleanerInterval()) + ", poolRecycleTimeout=" + String.valueOf(this.poolRecycleTimeout()) + ", maxWaitingHandlers=" + this.maxWaitingHandlers() + ", maxNestedArrays=" + this.maxNestedArrays() + ", reconnectAttempts=" + this.reconnectAttempts() + ", reconnectInterval=" + String.valueOf(this.reconnectInterval()) + ", protocolNegotiation=" + this.protocolNegotiation() + ", preferredProtocolVersion=" + String.valueOf(this.preferredProtocolVersion()) + ", hashSlotCacheTtl=" + String.valueOf(this.hashSlotCacheTtl()) + ", tcp=" + String.valueOf(this.tcp()) + ", tls=" + String.valueOf(this.tls()) + ", clientName=" + String.valueOf(this.clientName()) + ", configureClientName=" + this.configureClientName() + "}";
    }
}

