/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.datasource.timeseries;

import io.quarkus.redis.datasource.RedisCommandExtraArguments;
import io.quarkus.redis.datasource.timeseries.Aggregation;
import io.quarkus.redis.datasource.timeseries.BucketTimestamp;
import io.smallrye.mutiny.helpers.ParameterValidation;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;

public class RangeArgs
implements RedisCommandExtraArguments {
    private boolean latest;
    private List<Long> filterByTimestamps;
    private boolean filterByValue;
    private double min;
    private double max;
    private int count = -1;
    private String align;
    private Aggregation aggregation;
    private long bucketDuration;
    private BucketTimestamp bucketTimestamp;
    private boolean empty;

    public RangeArgs latest() {
        this.latest = true;
        return this;
    }

    public RangeArgs filterByTimestamp(long ... timestamps) {
        if (this.filterByTimestamps == null) {
            this.filterByTimestamps = new ArrayList<Long>(timestamps.length);
        }
        for (long timestamp : timestamps) {
            if (timestamp < 0L) {
                throw new IllegalArgumentException("The timestamp must be positive");
            }
            this.filterByTimestamps.add(timestamp);
        }
        return this;
    }

    public RangeArgs filterByValue(double min, double max) {
        this.filterByValue = true;
        this.min = min;
        this.max = max;
        return this;
    }

    public RangeArgs count(int count) {
        this.count = count;
        return this;
    }

    public RangeArgs align(long timestamp) {
        this.align = Long.toString(timestamp);
        return this;
    }

    public RangeArgs alignUsingRangeStart() {
        this.align = "-";
        return this;
    }

    public RangeArgs alignUsingRangeEnd() {
        this.align = "+";
        return this;
    }

    public RangeArgs aggregation(Aggregation aggregation, Duration bucketDuration) {
        this.aggregation = (Aggregation)((Object)ParameterValidation.nonNull((Object)((Object)aggregation), (String)"aggregation"));
        this.bucketDuration = ParameterValidation.positive((long)((Duration)ParameterValidation.nonNull((Object)bucketDuration, (String)"bucketDuration")).toMillis(), (String)"bucketDuration");
        return this;
    }

    public RangeArgs bucketTimestamp(BucketTimestamp ts) {
        this.bucketTimestamp = ts;
        return this;
    }

    public RangeArgs empty() {
        this.empty = true;
        return this;
    }

    @Override
    public List<Object> toArgs() {
        ArrayList<Object> list = new ArrayList<Object>();
        if (this.latest) {
            list.add("LATEST");
        }
        if (this.filterByTimestamps != null && !this.filterByTimestamps.isEmpty()) {
            list.add("FILTER_BY_TS");
            for (Long ts : this.filterByTimestamps) {
                list.add(Long.toString(ts));
            }
        }
        if (this.filterByValue) {
            list.add("FILTER_BY_VALUE");
            list.add(Double.toString(this.min));
            list.add(Double.toString(this.max));
        }
        if (this.count != -1) {
            list.add("COUNT");
            list.add(Integer.toString(this.count));
        }
        if (this.aggregation != null) {
            if (this.align != null) {
                list.add("ALIGN");
                list.add(this.align);
            }
            list.add("AGGREGATION");
            list.add(this.aggregation.toString());
            list.add(Long.toString(this.bucketDuration));
            if (this.bucketTimestamp != null) {
                list.add("BUCKETTIMESTAMP");
                list.add(this.bucketTimestamp.toString());
            }
            if (this.empty) {
                list.add("EMPTY");
            }
        }
        return list;
    }
}

