/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.runtime.datasource;

import com.fasterxml.jackson.core.type.TypeReference;
import io.quarkus.redis.datasource.ReactiveRedisDataSource;
import io.quarkus.redis.datasource.RedisDataSource;
import io.quarkus.redis.datasource.autosuggest.AutoSuggestCommands;
import io.quarkus.redis.datasource.bitmap.BitMapCommands;
import io.quarkus.redis.datasource.bloom.BloomCommands;
import io.quarkus.redis.datasource.countmin.CountMinCommands;
import io.quarkus.redis.datasource.cuckoo.CuckooCommands;
import io.quarkus.redis.datasource.geo.GeoCommands;
import io.quarkus.redis.datasource.graph.GraphCommands;
import io.quarkus.redis.datasource.hash.HashCommands;
import io.quarkus.redis.datasource.hyperloglog.HyperLogLogCommands;
import io.quarkus.redis.datasource.json.JsonCommands;
import io.quarkus.redis.datasource.keys.KeyCommands;
import io.quarkus.redis.datasource.list.ListCommands;
import io.quarkus.redis.datasource.pubsub.PubSubCommands;
import io.quarkus.redis.datasource.search.SearchCommands;
import io.quarkus.redis.datasource.set.SetCommands;
import io.quarkus.redis.datasource.sortedset.SortedSetCommands;
import io.quarkus.redis.datasource.stream.StreamCommands;
import io.quarkus.redis.datasource.string.StringCommands;
import io.quarkus.redis.datasource.timeseries.TimeSeriesCommands;
import io.quarkus.redis.datasource.topk.TopKCommands;
import io.quarkus.redis.datasource.transactions.OptimisticLockingTransactionResult;
import io.quarkus.redis.datasource.transactions.TransactionResult;
import io.quarkus.redis.datasource.transactions.TransactionalRedisDataSource;
import io.quarkus.redis.datasource.value.ValueCommands;
import io.quarkus.redis.runtime.datasource.BlockingAutoSuggestCommandsImpl;
import io.quarkus.redis.runtime.datasource.BlockingBitmapCommandsImpl;
import io.quarkus.redis.runtime.datasource.BlockingBloomCommandsImpl;
import io.quarkus.redis.runtime.datasource.BlockingCountMinCommandsImpl;
import io.quarkus.redis.runtime.datasource.BlockingCuckooCommandsImpl;
import io.quarkus.redis.runtime.datasource.BlockingGeoCommandsImpl;
import io.quarkus.redis.runtime.datasource.BlockingGraphCommandsImpl;
import io.quarkus.redis.runtime.datasource.BlockingHashCommandsImpl;
import io.quarkus.redis.runtime.datasource.BlockingHyperLogLogCommandsImpl;
import io.quarkus.redis.runtime.datasource.BlockingJsonCommandsImpl;
import io.quarkus.redis.runtime.datasource.BlockingKeyCommandsImpl;
import io.quarkus.redis.runtime.datasource.BlockingListCommandsImpl;
import io.quarkus.redis.runtime.datasource.BlockingPubSubCommandsImpl;
import io.quarkus.redis.runtime.datasource.BlockingSearchCommandsImpl;
import io.quarkus.redis.runtime.datasource.BlockingSetCommandsImpl;
import io.quarkus.redis.runtime.datasource.BlockingSortedSetCommandsImpl;
import io.quarkus.redis.runtime.datasource.BlockingStreamCommandsImpl;
import io.quarkus.redis.runtime.datasource.BlockingStringCommandsImpl;
import io.quarkus.redis.runtime.datasource.BlockingTimeSeriesCommandsImpl;
import io.quarkus.redis.runtime.datasource.BlockingTopKCommandsImpl;
import io.quarkus.redis.runtime.datasource.BlockingTransactionalRedisDataSourceImpl;
import io.quarkus.redis.runtime.datasource.ReactiveRedisDataSourceImpl;
import io.quarkus.redis.runtime.datasource.ReactiveTransactionalRedisDataSourceImpl;
import io.quarkus.redis.runtime.datasource.TransactionHolder;
import io.vertx.mutiny.core.Vertx;
import io.vertx.mutiny.redis.client.Redis;
import io.vertx.mutiny.redis.client.RedisAPI;
import io.vertx.mutiny.redis.client.RedisConnection;
import io.vertx.mutiny.redis.client.Request;
import io.vertx.mutiny.redis.client.Response;
import io.vertx.redis.client.Command;
import java.time.Duration;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;

public class BlockingRedisDataSourceImpl
implements RedisDataSource {
    private final Duration timeout;
    final ReactiveRedisDataSourceImpl reactive;
    final RedisConnection connection;

    public BlockingRedisDataSourceImpl(Vertx vertx, Redis redis, RedisAPI api, Duration timeout) {
        this(new ReactiveRedisDataSourceImpl(vertx, redis, api), timeout);
    }

    public BlockingRedisDataSourceImpl(ReactiveRedisDataSourceImpl reactive, Duration timeout) {
        this.reactive = reactive;
        this.timeout = timeout;
        this.connection = reactive.connection;
    }

    public BlockingRedisDataSourceImpl(Vertx vertx, Redis redis, RedisConnection connection, Duration timeout) {
        this(new ReactiveRedisDataSourceImpl(vertx, redis, connection), timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TransactionResult withTransaction(Consumer<TransactionalRedisDataSource> ds) {
        RedisConnection connection = (RedisConnection)this.reactive.redis.connect().await().atMost(this.timeout);
        ReactiveRedisDataSourceImpl dataSource = new ReactiveRedisDataSourceImpl(this.reactive.getVertx(), this.reactive.redis, connection);
        TransactionHolder th = new TransactionHolder();
        BlockingTransactionalRedisDataSourceImpl source = new BlockingTransactionalRedisDataSourceImpl(new ReactiveTransactionalRedisDataSourceImpl(dataSource, th), this.timeout);
        try {
            connection.send(Request.cmd((io.vertx.mutiny.redis.client.Command)io.vertx.mutiny.redis.client.Command.MULTI)).await().atMost(this.timeout);
            try {
                ds.accept(source);
            }
            catch (Exception e) {
                if (!source.discarded()) {
                    try {
                        connection.send(Request.cmd((io.vertx.mutiny.redis.client.Command)io.vertx.mutiny.redis.client.Command.DISCARD)).await().atMost(this.timeout);
                    }
                    catch (Exception e2) {
                        e.addSuppressed(e2);
                    }
                }
                throw e;
            }
            if (!source.discarded()) {
                Response response = (Response)connection.send(Request.cmd((io.vertx.mutiny.redis.client.Command)io.vertx.mutiny.redis.client.Command.EXEC)).await().atMost(this.timeout);
                TransactionResult transactionResult = ReactiveRedisDataSourceImpl.toTransactionResult(response, th);
                return transactionResult;
            }
            TransactionResult transactionResult = ReactiveRedisDataSourceImpl.toTransactionResult(null, th);
            return transactionResult;
        }
        finally {
            connection.closeAndAwait();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TransactionResult withTransaction(Consumer<TransactionalRedisDataSource> ds, String ... watchedKeys) {
        RedisConnection connection = (RedisConnection)this.reactive.redis.connect().await().atMost(this.timeout);
        ReactiveRedisDataSourceImpl dataSource = new ReactiveRedisDataSourceImpl(this.reactive.getVertx(), this.reactive.redis, connection);
        TransactionHolder th = new TransactionHolder();
        BlockingTransactionalRedisDataSourceImpl source = new BlockingTransactionalRedisDataSourceImpl(new ReactiveTransactionalRedisDataSourceImpl(dataSource, th), this.timeout);
        try {
            Request cmd = Request.cmd((io.vertx.mutiny.redis.client.Command)io.vertx.mutiny.redis.client.Command.WATCH);
            for (String watchedKey : watchedKeys) {
                cmd.arg(watchedKey);
            }
            connection.send(cmd).await().atMost(this.timeout);
            connection.send(Request.cmd((io.vertx.mutiny.redis.client.Command)io.vertx.mutiny.redis.client.Command.MULTI)).await().atMost(this.timeout);
            try {
                ds.accept(source);
            }
            catch (Exception exception) {
                if (!source.discarded()) {
                    try {
                        connection.send(Request.cmd((io.vertx.mutiny.redis.client.Command)io.vertx.mutiny.redis.client.Command.DISCARD)).await().atMost(this.timeout);
                    }
                    catch (Exception e2) {
                        exception.addSuppressed(e2);
                    }
                }
                throw exception;
            }
            if (!source.discarded()) {
                Response response = (Response)connection.send(Request.cmd((io.vertx.mutiny.redis.client.Command)io.vertx.mutiny.redis.client.Command.EXEC)).await().atMost(this.timeout);
                TransactionResult transactionResult = ReactiveRedisDataSourceImpl.toTransactionResult(response, th);
                return transactionResult;
            }
            TransactionResult transactionResult = ReactiveRedisDataSourceImpl.toTransactionResult(null, th);
            return transactionResult;
        }
        finally {
            connection.closeAndAwait();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <I> OptimisticLockingTransactionResult<I> withTransaction(Function<RedisDataSource, I> preTx, BiConsumer<I, TransactionalRedisDataSource> tx, String ... watchedKeys) {
        RedisConnection connection = (RedisConnection)this.reactive.redis.connect().await().atMost(this.timeout);
        ReactiveRedisDataSourceImpl dataSource = new ReactiveRedisDataSourceImpl(this.reactive.getVertx(), this.reactive.redis, connection);
        TransactionHolder th = new TransactionHolder();
        BlockingTransactionalRedisDataSourceImpl source = new BlockingTransactionalRedisDataSourceImpl(new ReactiveTransactionalRedisDataSourceImpl(dataSource, th), this.timeout);
        try {
            Request cmd = Request.cmd((io.vertx.mutiny.redis.client.Command)io.vertx.mutiny.redis.client.Command.WATCH);
            for (String watchedKey : watchedKeys) {
                cmd.arg(watchedKey);
            }
            connection.send(cmd).await().atMost(this.timeout);
            Object input = null;
            try {
                input = preTx.apply(new BlockingRedisDataSourceImpl(this.reactive.getVertx(), this.reactive.redis, connection, this.timeout));
            }
            catch (Exception e) {
                try {
                    connection.send(Request.cmd((io.vertx.mutiny.redis.client.Command)io.vertx.mutiny.redis.client.Command.UNWATCH)).await().atMost(this.timeout);
                }
                catch (Exception e2) {
                    e.addSuppressed(e2);
                }
                throw e;
            }
            connection.send(Request.cmd((io.vertx.mutiny.redis.client.Command)io.vertx.mutiny.redis.client.Command.MULTI)).await().atMost(this.timeout);
            try {
                tx.accept(input, source);
            }
            catch (Exception e) {
                if (!source.discarded()) {
                    try {
                        connection.send(Request.cmd((io.vertx.mutiny.redis.client.Command)io.vertx.mutiny.redis.client.Command.DISCARD)).await().atMost(this.timeout);
                    }
                    catch (Exception e2) {
                        e.addSuppressed(e2);
                    }
                }
                throw e;
            }
            if (!source.discarded()) {
                Response response = (Response)connection.send(Request.cmd((io.vertx.mutiny.redis.client.Command)io.vertx.mutiny.redis.client.Command.EXEC)).await().atMost(this.timeout);
                OptimisticLockingTransactionResult<Object> optimisticLockingTransactionResult = ReactiveRedisDataSourceImpl.toTransactionResult(response, input, th);
                return optimisticLockingTransactionResult;
            }
            OptimisticLockingTransactionResult<Object> optimisticLockingTransactionResult = ReactiveRedisDataSourceImpl.toTransactionResult(null, input, th);
            return optimisticLockingTransactionResult;
        }
        finally {
            connection.closeAndAwait();
        }
    }

    @Override
    public void withConnection(Consumer<RedisDataSource> consumer) {
        if (this.connection != null) {
            consumer.accept(this);
            return;
        }
        BlockingRedisDataSourceImpl source = (BlockingRedisDataSourceImpl)this.reactive.redis.connect().map(rc -> new BlockingRedisDataSourceImpl(this.reactive.getVertx(), this.reactive.redis, (RedisConnection)rc, this.timeout)).await().atMost(this.timeout);
        try {
            consumer.accept(source);
        }
        finally {
            source.connection.closeAndAwait();
        }
    }

    @Override
    public void select(long index) {
        this.reactive.select(index).await().atMost(this.timeout);
    }

    @Override
    public void flushall() {
        this.reactive.flushall().await().atMost(this.timeout);
    }

    public <K1, F, V1> HashCommands<K1, F, V1> hash(Class<K1> redisKeyType, Class<F> typeOfField, Class<V1> typeOfValue) {
        return new BlockingHashCommandsImpl<K1, F, V1>(this, this.reactive.hash(redisKeyType, typeOfField, typeOfValue), this.timeout);
    }

    @Override
    public <K, F, V> HashCommands<K, F, V> hash(TypeReference<K> redisKeyType, TypeReference<F> typeOfField, TypeReference<V> typeOfValue) {
        return new BlockingHashCommandsImpl<K, F, V>(this, this.reactive.hash(redisKeyType, typeOfField, typeOfValue), this.timeout);
    }

    public <K1, V1> GeoCommands<K1, V1> geo(Class<K1> redisKeyType, Class<V1> memberType) {
        return new BlockingGeoCommandsImpl<K1, V1>(this, this.reactive.geo(redisKeyType, memberType), this.timeout);
    }

    public <K1, V1> GeoCommands<K1, V1> geo(TypeReference<K1> redisKeyType, TypeReference<V1> memberType) {
        return new BlockingGeoCommandsImpl<K1, V1>(this, this.reactive.geo(redisKeyType, memberType), this.timeout);
    }

    public <K1> KeyCommands<K1> key(Class<K1> redisKeyType) {
        return new BlockingKeyCommandsImpl<K1>(this, this.reactive.key(redisKeyType), this.timeout);
    }

    public <K1> KeyCommands<K1> key(TypeReference<K1> redisKeyType) {
        return new BlockingKeyCommandsImpl<K1>(this, this.reactive.key(redisKeyType), this.timeout);
    }

    public <K1, V1> SortedSetCommands<K1, V1> sortedSet(Class<K1> redisKeyType, Class<V1> valueType) {
        return new BlockingSortedSetCommandsImpl<K1, V1>(this, this.reactive.sortedSet(redisKeyType, valueType), this.timeout);
    }

    public <K1, V1> SortedSetCommands<K1, V1> sortedSet(TypeReference<K1> redisKeyType, TypeReference<V1> valueType) {
        return new BlockingSortedSetCommandsImpl<K1, V1>(this, this.reactive.sortedSet(redisKeyType, valueType), this.timeout);
    }

    public <K1, V1> StringCommands<K1, V1> string(Class<K1> redisKeyType, Class<V1> valueType) {
        return new BlockingStringCommandsImpl<K1, V1>(this, this.reactive.value(redisKeyType, valueType), this.timeout);
    }

    @Override
    public <K, V> ValueCommands<K, V> value(Class<K> redisKeyType, Class<V> valueType) {
        return new BlockingStringCommandsImpl<K, V>(this, this.reactive.value(redisKeyType, valueType), this.timeout);
    }

    @Override
    public <K, V> ValueCommands<K, V> value(TypeReference<K> redisKeyType, TypeReference<V> valueType) {
        return new BlockingStringCommandsImpl<K, V>(this, this.reactive.value(redisKeyType, valueType), this.timeout);
    }

    public <K1, V1> SetCommands<K1, V1> set(Class<K1> redisKeyType, Class<V1> memberType) {
        return new BlockingSetCommandsImpl<K1, V1>(this, this.reactive.set(redisKeyType, memberType), this.timeout);
    }

    public <K1, V1> SetCommands<K1, V1> set(TypeReference<K1> redisKeyType, TypeReference<V1> memberType) {
        return new BlockingSetCommandsImpl<K1, V1>(this, this.reactive.set(redisKeyType, memberType), this.timeout);
    }

    public <K1, V1> ListCommands<K1, V1> list(Class<K1> redisKeyType, Class<V1> memberType) {
        return new BlockingListCommandsImpl<K1, V1>(this, this.reactive.list(redisKeyType, memberType), this.timeout);
    }

    public <K1, V1> ListCommands<K1, V1> list(TypeReference<K1> redisKeyType, TypeReference<V1> memberType) {
        return new BlockingListCommandsImpl<K1, V1>(this, this.reactive.list(redisKeyType, memberType), this.timeout);
    }

    public <K1, V1> HyperLogLogCommands<K1, V1> hyperloglog(Class<K1> redisKeyType, Class<V1> memberType) {
        return new BlockingHyperLogLogCommandsImpl<K1, V1>(this, this.reactive.hyperloglog(redisKeyType, memberType), this.timeout);
    }

    public <K1, V1> HyperLogLogCommands<K1, V1> hyperloglog(TypeReference<K1> redisKeyType, TypeReference<V1> memberType) {
        return new BlockingHyperLogLogCommandsImpl<K1, V1>(this, this.reactive.hyperloglog(redisKeyType, memberType), this.timeout);
    }

    @Override
    public <K> BitMapCommands<K> bitmap(Class<K> redisKeyType) {
        return new BlockingBitmapCommandsImpl<K>(this, this.reactive.bitmap(redisKeyType), this.timeout);
    }

    @Override
    public <K> BitMapCommands<K> bitmap(TypeReference<K> redisKeyType) {
        return new BlockingBitmapCommandsImpl<K>(this, this.reactive.bitmap(redisKeyType), this.timeout);
    }

    @Override
    public <K, F, V> StreamCommands<K, F, V> stream(Class<K> redisKeyType, Class<F> fieldType, Class<V> valueType) {
        return new BlockingStreamCommandsImpl<K, F, V>(this, this.reactive.stream(redisKeyType, fieldType, valueType), this.timeout);
    }

    @Override
    public <K, F, V> StreamCommands<K, F, V> stream(TypeReference<K> redisKeyType, TypeReference<F> fieldType, TypeReference<V> valueType) {
        return new BlockingStreamCommandsImpl<K, F, V>(this, this.reactive.stream(redisKeyType, fieldType, valueType), this.timeout);
    }

    @Override
    public <K> JsonCommands<K> json(Class<K> redisKeyType) {
        return new BlockingJsonCommandsImpl<K>(this, this.reactive.json(redisKeyType), this.timeout);
    }

    @Override
    public <K> JsonCommands<K> json(TypeReference<K> redisKeyType) {
        return new BlockingJsonCommandsImpl<K>(this, this.reactive.json(redisKeyType), this.timeout);
    }

    @Override
    public <K, V> BloomCommands<K, V> bloom(Class<K> redisKeyType, Class<V> valueType) {
        return new BlockingBloomCommandsImpl<K, V>(this, this.reactive.bloom(redisKeyType, valueType), this.timeout);
    }

    @Override
    public <K, V> BloomCommands<K, V> bloom(TypeReference<K> redisKeyType, TypeReference<V> valueType) {
        return new BlockingBloomCommandsImpl<K, V>(this, this.reactive.bloom(redisKeyType, valueType), this.timeout);
    }

    @Override
    public <K, V> CuckooCommands<K, V> cuckoo(Class<K> redisKeyType, Class<V> valueType) {
        return new BlockingCuckooCommandsImpl<K, V>(this, this.reactive.cuckoo(redisKeyType, valueType), this.timeout);
    }

    @Override
    public <K, V> CuckooCommands<K, V> cuckoo(TypeReference<K> redisKeyType, TypeReference<V> valueType) {
        return new BlockingCuckooCommandsImpl<K, V>(this, this.reactive.cuckoo(redisKeyType, valueType), this.timeout);
    }

    @Override
    public <K, V> CountMinCommands<K, V> countmin(Class<K> redisKeyType, Class<V> valueType) {
        return new BlockingCountMinCommandsImpl<K, V>(this, this.reactive.countmin(redisKeyType, valueType), this.timeout);
    }

    @Override
    public <K, V> CountMinCommands<K, V> countmin(TypeReference<K> redisKeyType, TypeReference<V> valueType) {
        return new BlockingCountMinCommandsImpl<K, V>(this, this.reactive.countmin(redisKeyType, valueType), this.timeout);
    }

    @Override
    public <K, V> TopKCommands<K, V> topk(Class<K> redisKeyType, Class<V> valueType) {
        return new BlockingTopKCommandsImpl<K, V>(this, this.reactive.topk(redisKeyType, valueType), this.timeout);
    }

    @Override
    public <K, V> TopKCommands<K, V> topk(TypeReference<K> redisKeyType, TypeReference<V> valueType) {
        return new BlockingTopKCommandsImpl<K, V>(this, this.reactive.topk(redisKeyType, valueType), this.timeout);
    }

    @Override
    public <K> GraphCommands<K> graph(Class<K> redisKeyType) {
        return new BlockingGraphCommandsImpl<K>(this, this.reactive.graph(redisKeyType), this.timeout);
    }

    @Override
    public <K> SearchCommands<K> search(Class<K> redisKeyType) {
        return new BlockingSearchCommandsImpl<K>(this, this.reactive.search(redisKeyType), this.timeout);
    }

    @Override
    public <K> AutoSuggestCommands<K> autosuggest(Class<K> redisKeyType) {
        return new BlockingAutoSuggestCommandsImpl<K>(this, this.reactive.autosuggest(redisKeyType), this.timeout);
    }

    @Override
    public <K> AutoSuggestCommands<K> autosuggest(TypeReference<K> redisKeyType) {
        return new BlockingAutoSuggestCommandsImpl<K>(this, this.reactive.autosuggest(redisKeyType), this.timeout);
    }

    @Override
    public <K> TimeSeriesCommands<K> timeseries(Class<K> redisKeyType) {
        return new BlockingTimeSeriesCommandsImpl<K>(this, this.reactive.timeseries(redisKeyType), this.timeout);
    }

    @Override
    public <K> TimeSeriesCommands<K> timeseries(TypeReference<K> redisKeyType) {
        return new BlockingTimeSeriesCommandsImpl<K>(this, this.reactive.timeseries(redisKeyType), this.timeout);
    }

    @Override
    public <V> PubSubCommands<V> pubsub(Class<V> messageType) {
        return new BlockingPubSubCommandsImpl<V>(this, this.reactive.pubsub(messageType), this.timeout);
    }

    @Override
    public <V> PubSubCommands<V> pubsub(TypeReference<V> messageType) {
        return new BlockingPubSubCommandsImpl<V>(this, this.reactive.pubsub(messageType), this.timeout);
    }

    @Override
    public Response execute(String command, String ... args) {
        return (Response)this.reactive.execute(command, args).await().atMost(this.timeout);
    }

    @Override
    public Response execute(io.vertx.mutiny.redis.client.Command command, String ... args) {
        return (Response)this.reactive.execute(command, args).await().atMost(this.timeout);
    }

    @Override
    public Response execute(Command command, String ... args) {
        return (Response)this.reactive.execute(command, args).await().atMost(this.timeout);
    }

    @Override
    public ReactiveRedisDataSource getReactive() {
        return this.reactive;
    }
}

