/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.datasource.autosuggest;

import io.quarkus.redis.datasource.RedisCommandExtraArguments;
import io.quarkus.redis.runtime.datasource.Validation;
import java.util.ArrayList;
import java.util.List;

public class GetArgs
implements RedisCommandExtraArguments {
    private boolean fuzzy;
    private int max;
    private boolean withScores;

    public GetArgs fuzzy() {
        this.fuzzy = true;
        return this;
    }

    public GetArgs max(int max) {
        Validation.positive(max, "max");
        this.max = max;
        return this;
    }

    public GetArgs withScores() {
        this.withScores = true;
        return this;
    }

    @Override
    public List<String> toArgs() {
        ArrayList<String> list = new ArrayList<String>();
        if (this.fuzzy) {
            list.add("FUZZY");
        }
        if (this.max > 0) {
            list.add("MAX");
            list.add(Integer.toString(this.max));
        }
        if (this.withScores) {
            list.add("WITHSCORES");
        }
        return list;
    }

    public boolean hasScores() {
        return this.withScores;
    }
}

