/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.datasource.geo;

import io.quarkus.redis.datasource.RedisCommandExtraArguments;
import io.quarkus.redis.datasource.codecs.Codec;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public class GeoRadiusStoreArgs<K>
implements RedisCommandExtraArguments {
    private boolean withDistance;
    private boolean withCoordinates;
    private boolean withHash;
    private long count = -1L;
    private boolean any;
    private String direction;
    private K storeKey;
    private K storeDistKey;

    public GeoRadiusStoreArgs<K> ascending() {
        this.direction = "ASC";
        return this;
    }

    public GeoRadiusStoreArgs<K> descending() {
        this.direction = "DESC";
        return this;
    }

    public GeoRadiusStoreArgs<K> withDistance() {
        this.withDistance = true;
        return this;
    }

    public GeoRadiusStoreArgs<K> withCoordinates() {
        this.withCoordinates = true;
        return this;
    }

    public GeoRadiusStoreArgs<K> withHash() {
        this.withHash = true;
        return this;
    }

    public GeoRadiusStoreArgs<K> count(long count) {
        this.count = count;
        return this;
    }

    public GeoRadiusStoreArgs<K> any() {
        this.any = true;
        return this;
    }

    public GeoRadiusStoreArgs<K> storeKey(K storeKey) {
        this.storeKey = storeKey;
        return this;
    }

    public GeoRadiusStoreArgs<K> storeDistKey(K storeDistKey) {
        this.storeDistKey = storeDistKey;
        return this;
    }

    @Override
    public List<String> toArgs(Codec codec) {
        if (this.any && this.count == -1L) {
            throw new IllegalArgumentException("ANY can only be used if COUNT is also set");
        }
        if (this.storeDistKey == null && this.storeKey == null) {
            throw new IllegalArgumentException("At least `STORE` or `STOREDIST` must be set");
        }
        ArrayList<String> list = new ArrayList<String>();
        if (this.withDistance) {
            list.add("WITHDIST");
        }
        if (this.withCoordinates) {
            list.add("WITHCOORD");
        }
        if (this.withHash) {
            list.add("WITHHASH");
        }
        if (this.count > 0L) {
            list.add("COUNT");
            list.add(Long.toString(this.count));
        }
        if (this.any) {
            list.add("ANY");
        }
        list.add(this.direction);
        if (this.storeKey != null) {
            list.add("STORE");
            list.add(new String(codec.encode(this.storeKey), StandardCharsets.UTF_8));
        }
        if (this.storeDistKey != null) {
            list.add("STOREDIST");
            list.add(new String(codec.encode(this.storeDistKey), StandardCharsets.UTF_8));
        }
        return list;
    }

    public boolean hasDistance() {
        return this.withDistance;
    }

    public boolean hasHash() {
        return this.withHash;
    }

    public boolean hasCoordinates() {
        return this.withCoordinates;
    }
}

