/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.runtime.client.config;

import io.quarkus.redis.runtime.client.config.NetConfig;
import io.quarkus.redis.runtime.client.config.TlsConfig;
import io.quarkus.runtime.annotations.ConfigGroup;
import io.smallrye.config.WithDefault;
import io.vertx.redis.client.RedisClientType;
import io.vertx.redis.client.RedisReplicas;
import io.vertx.redis.client.RedisRole;
import java.net.URI;
import java.time.Duration;
import java.util.Optional;
import java.util.Set;

@ConfigGroup
public interface RedisClientConfig {
    public Optional<Set<URI>> hosts();

    public Optional<String> hostsProviderName();

    @WithDefault(value="10s")
    public Duration timeout();

    @WithDefault(value="standalone")
    public RedisClientType clientType();

    public Optional<String> masterName();

    public Optional<RedisRole> role();

    public Optional<RedisReplicas> replicas();

    public Optional<String> password();

    @WithDefault(value="6")
    public int maxPoolSize();

    @WithDefault(value="24")
    public int maxPoolWaiting();

    public Optional<Duration> poolCleanerInterval();

    @WithDefault(value="15")
    public Duration poolRecycleTimeout();

    @WithDefault(value="2048")
    public int maxWaitingHandlers();

    @WithDefault(value="32")
    public int maxNestedArrays();

    @WithDefault(value="0")
    public int reconnectAttempts();

    @WithDefault(value="1")
    public Duration reconnectInterval();

    @WithDefault(value="true")
    public boolean protocolNegotiation();

    public NetConfig tcp();

    public TlsConfig tls();

    default public String toDebugString() {
        return "RedisClientConfig{hosts=" + this.hosts() + ", hostsProviderName=" + this.hostsProviderName() + ", timeout=" + this.timeout() + ", clientType=" + this.clientType() + ", masterName=" + this.masterName() + ", role=" + this.role() + ", replicas=" + this.replicas() + ", password=" + this.password() + ", maxPoolSize=" + this.maxPoolSize() + ", maxPoolWaiting=" + this.maxPoolWaiting() + ", poolCleanerInterval=" + this.poolCleanerInterval() + ", poolRecycleTimeout=" + this.poolRecycleTimeout() + ", maxWaitingHandlers=" + this.maxWaitingHandlers() + ", maxNestedArrays=" + this.maxNestedArrays() + ", reconnectAttempts=" + this.reconnectAttempts() + ", reconnectInterval=" + this.reconnectInterval() + ", protocolNegotiation=" + this.protocolNegotiation() + ", tcp=" + this.tcp() + ", tls=" + this.tls() + "}";
    }
}

