/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.runtime.datasource;

import io.quarkus.redis.datasource.RedisCommandExtraArguments;
import io.quarkus.redis.datasource.codecs.Codec;
import io.vertx.mutiny.core.buffer.Buffer;
import io.vertx.mutiny.redis.client.Command;
import io.vertx.mutiny.redis.client.Request;
import java.util.List;

public class RedisCommand {
    private final Request request;

    private RedisCommand(Command command) {
        this.request = Request.cmd((Command)command);
    }

    public static RedisCommand of(Command command) {
        return new RedisCommand(command);
    }

    public RedisCommand put(Object x) {
        if (x == null) {
            return this;
        }
        if (x instanceof String) {
            this.request.arg(x.toString());
        } else if (x instanceof Double) {
            this.request.arg(((Double)x).doubleValue());
        } else if (x instanceof Long) {
            this.request.arg(((Long)x).longValue());
        } else if (x instanceof Integer) {
            this.request.arg(((Integer)x).intValue());
        } else if (x instanceof Boolean) {
            this.request.arg(((Boolean)x).booleanValue());
        } else if (x instanceof byte[]) {
            this.request.arg(Buffer.buffer((byte[])((byte[])x)));
        } else if (x instanceof RedisCommandExtraArguments) {
            this.putArgs((RedisCommandExtraArguments)x);
        } else if (x instanceof List) {
            this.putAll((List)x);
        } else {
            throw new UnsupportedOperationException("Unsupported type: " + x);
        }
        return this;
    }

    public RedisCommand putAll(List<?> args) {
        for (Object arg : args) {
            this.put(arg);
        }
        return this;
    }

    public RedisCommand putAll(String[] args) {
        for (String arg : args) {
            this.put(arg);
        }
        return this;
    }

    public RedisCommand putArgs(RedisCommandExtraArguments arguments) {
        this.putAll(arguments.toArgs());
        return this;
    }

    public RedisCommand putArgs(RedisCommandExtraArguments arguments, Codec codec) {
        this.putAll(arguments.toArgs(codec));
        return this;
    }

    public RedisCommand putFlag(boolean value, String flag) {
        if (value) {
            this.request.arg(flag);
        }
        return this;
    }

    public Request toRequest() {
        return this.request;
    }

    public void putNullable(byte[] encoded) {
        if (encoded == null) {
            this.request.nullArg();
        } else {
            this.request.arg(encoded);
        }
    }
}

