/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.datasource.list;

import java.util.Objects;

public class KeyValue<K, V> {
    public final K key;
    public final V value;

    public KeyValue(K key, V value) {
        this.key = key;
        this.value = value;
    }

    public static <K, V> KeyValue<K, V> of(K key, V value) {
        return new KeyValue<K, V>(key, value);
    }

    public K key() {
        return this.key;
    }

    public V value() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KeyValue keyValue = (KeyValue)o;
        return this.key.equals(keyValue.key) && Objects.equals(this.value, keyValue.value);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.value);
    }

    public String toString() {
        return "KeyValue{key=" + this.key + ", value=" + this.value + "}";
    }
}

