/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.datasource.search;

import io.quarkus.redis.datasource.RedisCommandExtraArguments;
import io.quarkus.redis.runtime.datasource.Validation;
import io.smallrye.mutiny.helpers.ParameterValidation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class HighlightArgs
implements RedisCommandExtraArguments {
    private String[] fields;
    private String openTag;
    private String closeTag;

    public HighlightArgs fields(String ... fields) {
        ParameterValidation.doesNotContainNull((Object[])Validation.notNullOrEmpty(fields, "fields"), (String)"fields");
        this.fields = fields;
        return this;
    }

    public HighlightArgs tags(String open, String close) {
        this.openTag = Validation.notNullOrBlank(open, "open");
        this.closeTag = Validation.notNullOrBlank(close, "close");
        return this;
    }

    @Override
    public List<String> toArgs() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("HIGHLIGHT");
        if (this.fields != null && this.fields.length > 0) {
            list.add("FIELDS");
            list.add(Integer.toString(this.fields.length));
            list.addAll(Arrays.asList(this.fields));
        }
        if (this.openTag != null && this.closeTag != null) {
            list.add("TAGS");
            list.add(this.openTag);
            list.add(this.closeTag);
        }
        return list;
    }
}

