/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.runtime.datasource;

import io.quarkus.redis.runtime.datasource.AbstractRedisCommands;
import io.quarkus.redis.runtime.datasource.Marshaller;
import io.quarkus.redis.runtime.datasource.RedisCommand;
import io.quarkus.redis.runtime.datasource.RedisCommandExecutor;
import io.quarkus.redis.runtime.datasource.Validation;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.vertx.mutiny.redis.client.Command;
import io.vertx.mutiny.redis.client.Response;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class AbstractHashCommands<K, F, V>
extends AbstractRedisCommands {
    protected final Type typeOfValue;
    protected final Type typeOfField;

    AbstractHashCommands(RedisCommandExecutor redis, Type k, Type f, Type v) {
        super(redis, new Marshaller(k, f, v));
        this.typeOfField = f;
        this.typeOfValue = v;
    }

    Uni<Response> _hdel(K key, F[] fields) {
        ParameterValidation.nonNull(key, (String)"key");
        Validation.notNullOrEmpty(fields, "fields");
        ParameterValidation.doesNotContainNull((Object[])fields, (String)"fields");
        RedisCommand cmd = RedisCommand.of(Command.HDEL).put(this.marshaller.encode(key));
        for (F field : fields) {
            cmd.put(this.marshaller.encode(field));
        }
        return this.execute(cmd);
    }

    Uni<Response> _hexists(K key, F field) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.nonNull(field, (String)"field");
        return this.execute(RedisCommand.of(Command.HEXISTS).put(this.marshaller.encode(key)).put(this.marshaller.encode(field)));
    }

    Uni<Response> _hget(K key, F field) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.nonNull(field, (String)"field");
        return this.execute(RedisCommand.of(Command.HGET).put(this.marshaller.encode(key)).put(this.marshaller.encode(field)));
    }

    Uni<Response> _hincrby(K key, F field, long amount) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.nonNull(field, (String)"field");
        return this.execute(RedisCommand.of(Command.HINCRBY).put(this.marshaller.encode(key)).put(this.marshaller.encode(field)).put(amount));
    }

    Uni<Response> _hincrbyfloat(K key, F field, double amount) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.nonNull(field, (String)"field");
        return this.execute(RedisCommand.of(Command.HINCRBYFLOAT).put(this.marshaller.encode(key)).put(this.marshaller.encode(field)).put(amount));
    }

    Uni<Response> _hgetall(K key) {
        ParameterValidation.nonNull(key, (String)"key");
        return this.execute(RedisCommand.of(Command.HGETALL).put(this.marshaller.encode(key)));
    }

    Uni<Response> _hkeys(K key) {
        ParameterValidation.nonNull(key, (String)"key");
        return this.execute(RedisCommand.of(Command.HKEYS).put(this.marshaller.encode(key)));
    }

    Uni<Response> _hlen(K key) {
        ParameterValidation.nonNull(key, (String)"key");
        return this.execute(RedisCommand.of(Command.HLEN).put(this.marshaller.encode(key)));
    }

    @SafeVarargs
    final Uni<Response> _hmget(K key, F ... fields) {
        RedisCommand cmd = RedisCommand.of(Command.HMGET);
        cmd.put(this.marshaller.encode(key));
        for (F field : fields) {
            cmd.put(this.marshaller.encode(field));
        }
        return this.execute(cmd);
    }

    Uni<Response> _hmset(K key, Map<F, V> map) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.nonNull(map, (String)"map");
        if (map.isEmpty()) {
            throw new IllegalArgumentException("`map` must not be empty");
        }
        RedisCommand cmd = RedisCommand.of(Command.HMSET);
        cmd.put(this.marshaller.encode(key));
        for (Map.Entry<F, V> entry : map.entrySet()) {
            cmd.put(this.marshaller.encode(entry.getKey()));
            cmd.putNullable(this.marshaller.encode(entry.getValue()));
        }
        return this.execute(cmd);
    }

    Uni<Response> _hrandfield(K key) {
        ParameterValidation.nonNull(key, (String)"key");
        return this.execute(RedisCommand.of(Command.HRANDFIELD).put(this.marshaller.encode(key)));
    }

    Uni<Response> _hrandfield(K key, long count) {
        ParameterValidation.nonNull(key, (String)"key");
        Validation.positive(count, "count");
        return this.execute(RedisCommand.of(Command.HRANDFIELD).put(this.marshaller.encode(key)).put(count));
    }

    Uni<Response> _hrandfieldWithValues(K key, long count) {
        ParameterValidation.nonNull(key, (String)"key");
        return this.execute(RedisCommand.of(Command.HRANDFIELD).put(this.marshaller.encode(key)).put(count).put("WITHVALUES"));
    }

    Uni<Response> _hset(K key, F field, V value) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.nonNull(field, (String)"field");
        ParameterValidation.nonNull(value, (String)"value");
        return this.execute(RedisCommand.of(Command.HSET).put(this.marshaller.encode(key)).put(this.marshaller.encode(field)).put(this.marshaller.encode(value)));
    }

    Uni<Response> _hset(K key, Map<F, V> map) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.nonNull(map, (String)"map");
        if (map.isEmpty()) {
            throw new IllegalArgumentException("`map` must not be empty");
        }
        RedisCommand cmd = RedisCommand.of(Command.HSET);
        cmd.put(this.marshaller.encode(key));
        for (Map.Entry<F, V> entry : map.entrySet()) {
            cmd.put(this.marshaller.encode(entry.getKey())).put(this.marshaller.encode(entry.getValue()));
        }
        return this.execute(cmd);
    }

    Uni<Response> _hsetnx(K key, F field, V value) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.nonNull(field, (String)"field");
        return this.execute(RedisCommand.of(Command.HSETNX).put(this.marshaller.encode(key)).put(this.marshaller.encode(field)).put(this.marshaller.encode(value)));
    }

    Uni<Response> _hstrlen(K key, F field) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.nonNull(field, (String)"field");
        return this.execute(RedisCommand.of(Command.HSTRLEN).put(this.marshaller.encode(key)).put(this.marshaller.encode(field)));
    }

    Uni<Response> _hvals(K key) {
        ParameterValidation.nonNull(key, (String)"key");
        return this.execute(RedisCommand.of(Command.HVALS).put(this.marshaller.encode(key)));
    }

    V decodeV(Response resp) {
        return (V)this.marshaller.decode(this.typeOfValue, resp);
    }

    Map<F, V> decodeMap(Response r) {
        return this.marshaller.decodeAsMap(r, this.typeOfField, this.typeOfValue);
    }

    List<F> decodeListOfField(Response r) {
        return this.marshaller.decodeAsList(r, this.typeOfField);
    }

    List<V> decodeListOfValue(Response r) {
        return this.marshaller.decodeAsList(r, this.typeOfValue);
    }

    F decodeF(Response resp) {
        return (F)this.marshaller.decode(this.typeOfField, resp);
    }

    Map<F, V> decodeOrderedMap(Response r, F[] fields) {
        return this.marshaller.decodeAsOrderedMap(r, this.typeOfValue, fields);
    }

    Map<F, V> decodeFieldWithValueMap(Response r) {
        if (r == null) {
            return Collections.emptyMap();
        }
        HashMap map = new HashMap();
        for (Response nested : r) {
            map.put(this.marshaller.decode(this.typeOfField, nested.get(0)), this.marshaller.decode(this.typeOfValue, nested.get(1)));
        }
        return map;
    }
}

