/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.datasource.search;

import io.quarkus.redis.datasource.RedisCommandExtraArguments;
import io.quarkus.redis.datasource.codecs.Codec;
import io.quarkus.redis.datasource.search.GeoFilter;
import io.quarkus.redis.datasource.search.HighlightArgs;
import io.quarkus.redis.datasource.search.NumericFilter;
import io.quarkus.redis.datasource.search.SummarizeArgs;
import io.quarkus.redis.runtime.datasource.Validation;
import io.smallrye.mutiny.helpers.ParameterValidation;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class QueryArgs
implements RedisCommandExtraArguments {
    public boolean nocontent;
    private boolean verbatim;
    private boolean withScores;
    private boolean withPayloads;
    private boolean withSortKeys;
    private final List<NumericFilter> filters = new ArrayList<NumericFilter>();
    private final List<GeoFilter> geoFilters = new ArrayList<GeoFilter>();
    private String[] inKeys;
    private String[] inFields;
    private final List<ReturnClause> returns = new ArrayList<ReturnClause>();
    private SummarizeArgs summarize;
    private HighlightArgs highlight;
    private int slop = -1;
    private boolean inOrder;
    private String lang;
    private String expander;
    private String scorer;
    private boolean explainScore;
    private String asc;
    private String desc;
    private int offset = -1;
    private int count = -1;
    private Duration timeout;
    private final Map<String, String> params = new HashMap<String, String>();
    private final Map<String, byte[]> byteArrayParams = new HashMap<String, byte[]>();
    private int dialect = -1;

    public QueryArgs nocontent() {
        this.nocontent = true;
        return this;
    }

    public QueryArgs verbatim() {
        this.verbatim = true;
        return this;
    }

    public QueryArgs withScores() {
        this.withScores = true;
        return this;
    }

    public QueryArgs withPayloads() {
        this.withPayloads = true;
        return this;
    }

    public QueryArgs withSortKeys() {
        this.withSortKeys = true;
        return this;
    }

    public QueryArgs filter(NumericFilter filter) {
        ParameterValidation.nonNull((Object)filter, (String)"filter");
        this.filters.add(filter);
        return this;
    }

    public QueryArgs geoFilter(GeoFilter filter) {
        ParameterValidation.nonNull((Object)filter, (String)"filter");
        this.geoFilters.add(filter);
        return this;
    }

    public final QueryArgs inKeys(String ... keys) {
        ParameterValidation.doesNotContainNull((Object[])Validation.notNullOrEmpty(keys, "keys"), (String)"keys");
        this.inKeys = keys;
        return this;
    }

    public QueryArgs inFields(String ... fields) {
        ParameterValidation.doesNotContainNull((Object[])Validation.notNullOrEmpty(fields, "fields"), (String)"fields");
        this.inFields = fields;
        return this;
    }

    public QueryArgs returnAttribute(String field, String alias) {
        Validation.notNullOrBlank(field, "field");
        this.returns.add(new ReturnClause(field, alias));
        return this;
    }

    public QueryArgs returnAttribute(String field) {
        this.returns.add(new ReturnClause(Validation.notNullOrBlank(field, "field"), null));
        return this;
    }

    public QueryArgs summarize(SummarizeArgs args) {
        this.summarize = (SummarizeArgs)ParameterValidation.nonNull((Object)args, (String)"args");
        return this;
    }

    public QueryArgs highlight(HighlightArgs args) {
        this.highlight = (HighlightArgs)ParameterValidation.nonNull((Object)args, (String)"args");
        return this;
    }

    public QueryArgs slop(int slop) {
        this.slop = ParameterValidation.positive((int)slop, (String)"slop");
        return this;
    }

    public QueryArgs inOrder() {
        this.inOrder = true;
        return this;
    }

    public QueryArgs language(String lang) {
        this.lang = Validation.notNullOrBlank(lang, "lang");
        return this;
    }

    public QueryArgs expander(String expander) {
        this.expander = Validation.notNullOrBlank(expander, "expander");
        return this;
    }

    public QueryArgs scorer(String scorer) {
        this.scorer = Validation.notNullOrBlank(scorer, "scorer");
        return this;
    }

    public QueryArgs explainScore() {
        this.explainScore = true;
        return this;
    }

    public QueryArgs sortByAscending(String field) {
        this.asc = Validation.notNullOrBlank(field, "field");
        return this;
    }

    public QueryArgs sortByDescending(String field) {
        this.desc = Validation.notNullOrBlank(field, "field");
        return this;
    }

    public QueryArgs limit(int offset, int count) {
        this.offset = ParameterValidation.positiveOrZero((int)offset, (String)"offset");
        this.count = ParameterValidation.positiveOrZero((int)count, (String)"count");
        return this;
    }

    public QueryArgs timeout(Duration timeout) {
        this.timeout = ParameterValidation.validate((Duration)timeout, (String)"timeout");
        return this;
    }

    public QueryArgs param(String name, String value) {
        this.params.put(Validation.notNullOrBlank(name, "name"), Validation.notNullOrBlank(value, "value"));
        return this;
    }

    public QueryArgs param(String name, byte[] value) {
        this.byteArrayParams.put(Validation.notNullOrBlank(name, "name"), Validation.notNullOrEmpty(value, "value"));
        return this;
    }

    public QueryArgs param(String name, float[] value) {
        this.byteArrayParams.put(Validation.notNullOrBlank(name, "name"), this.toByteArray(Validation.notNullOrEmpty(value, "value")));
        return this;
    }

    public QueryArgs param(String name, double[] value) {
        this.byteArrayParams.put(Validation.notNullOrBlank(name, "name"), this.toByteArray(Validation.notNullOrEmpty(value, "value")));
        return this;
    }

    public QueryArgs param(String name, int[] value) {
        this.byteArrayParams.put(Validation.notNullOrBlank(name, "name"), this.toByteArray(Validation.notNullOrEmpty(value, "value")));
        return this;
    }

    public QueryArgs param(String name, long[] value) {
        this.byteArrayParams.put(Validation.notNullOrBlank(name, "name"), this.toByteArray(Validation.notNullOrEmpty(value, "value")));
        return this;
    }

    public QueryArgs dialect(int version) {
        this.dialect = version;
        return this;
    }

    @Override
    public List<Object> toArgs(Codec encoder) {
        ArrayList<Object> list = new ArrayList<Object>();
        if (this.nocontent) {
            list.add("NOCONTENT");
        }
        if (this.verbatim) {
            list.add("VERBATIM");
        }
        if (this.withScores) {
            list.add("WITHSCORES");
        }
        if (this.withPayloads) {
            list.add("WITHPAYLOADS");
        }
        if (this.withSortKeys) {
            list.add("WITHSORTKEYS");
        }
        for (NumericFilter numericFilter : this.filters) {
            list.add("FILTER");
            list.add(numericFilter.getField());
            list.add(numericFilter.getLowerBound());
            list.add(numericFilter.getUpperBound());
        }
        for (GeoFilter geoFilter : this.geoFilters) {
            list.add(geoFilter.toString());
        }
        if (this.inKeys != null && this.inKeys.length > 0) {
            list.add(Integer.toString(this.inKeys.length));
            list.addAll(Arrays.asList(this.inKeys));
        }
        if (!this.returns.isEmpty()) {
            list.add("RETURN");
            ArrayList<String> clauses = new ArrayList<String>();
            for (ReturnClause clause : this.returns) {
                clauses.addAll(clause.toArgs());
            }
            list.add(Integer.toString(clauses.size()));
            list.addAll(clauses);
        }
        if (this.inFields != null && this.inFields.length > 0) {
            list.add(Integer.toString(this.inFields.length));
            Collections.addAll(list, this.inFields);
        }
        if (this.summarize != null) {
            list.addAll(this.summarize.toArgs());
        }
        if (this.highlight != null) {
            list.addAll(this.highlight.toArgs());
        }
        if (this.slop > -1) {
            list.add("SLOP");
            list.add(Integer.toString(this.slop));
        }
        if (this.inOrder) {
            list.add("INORDER");
        }
        if (this.lang != null) {
            list.add("LANGUAGE");
            list.add(this.lang);
        }
        if (this.expander != null) {
            list.add("EXPANDER");
            list.add(this.expander);
        }
        if (this.scorer != null) {
            list.add("SCORER");
            list.add(this.scorer);
        }
        if (this.explainScore) {
            list.add("EXPLAINSCORE");
        }
        if (this.asc != null || this.desc != null) {
            if (this.asc != null && this.desc != null) {
                throw new IllegalArgumentException("Cannot use descending and ascending order at the same time");
            }
            list.add("SORTBY");
            if (this.asc != null) {
                list.add(this.asc);
                list.add("ASC");
            }
            if (this.desc != null) {
                list.add(this.desc);
                list.add("DESC");
            }
        }
        if (this.offset != -1) {
            list.add("LIMIT");
            list.add(Integer.toString(this.offset));
            list.add(Integer.toString(this.count));
        }
        if (this.timeout != null) {
            list.add("TIMEOUT");
            list.add(Long.toString(this.timeout.toMillis()));
        }
        if (!this.params.isEmpty() || !this.byteArrayParams.isEmpty()) {
            list.add("PARAMS");
            list.add(Integer.toString(this.params.size() + this.byteArrayParams.size()));
            for (Map.Entry entry : this.byteArrayParams.entrySet()) {
                list.add(entry.getKey());
                list.add(entry.getValue());
            }
            for (Map.Entry entry : this.params.entrySet()) {
                list.add(entry.getKey());
                list.add(entry.getValue());
            }
        }
        if (this.dialect != -1) {
            list.add("DIALECT");
            list.add(Integer.toString(this.dialect));
        }
        return list;
    }

    public boolean containsScore() {
        return this.withScores;
    }

    public boolean containsPayload() {
        return this.withPayloads;
    }

    public boolean containsSortKeys() {
        return this.withSortKeys;
    }

    private byte[] toByteArray(float[] input) {
        byte[] bytes = new byte[4 * input.length];
        ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN).asFloatBuffer().put(input);
        return bytes;
    }

    private byte[] toByteArray(double[] input) {
        byte[] bytes = new byte[8 * input.length];
        ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN).asDoubleBuffer().put(input);
        return bytes;
    }

    private byte[] toByteArray(int[] input) {
        byte[] bytes = new byte[4 * input.length];
        ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN).asIntBuffer().put(input);
        return bytes;
    }

    private byte[] toByteArray(long[] input) {
        byte[] bytes = new byte[8 * input.length];
        ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN).asLongBuffer().put(input);
        return bytes;
    }

    private static final class ReturnClause {
        private final String field;
        private final String alias;

        public ReturnClause(String field, String alias) {
            this.field = field;
            this.alias = alias;
        }

        public List<String> toArgs() {
            ArrayList<String> list = new ArrayList<String>();
            list.add(this.field);
            if (this.alias != null) {
                list.add("AS");
                list.add(this.alias);
            }
            return list;
        }
    }
}

