/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.restclient.config.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.GeneratedClassGizmoAdaptor;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.RunTimeConfigBuilderBuildItem;
import io.quarkus.deployment.builditem.StaticInitConfigBuilderBuildItem;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.restclient.config.AbstractRestClientConfigBuilder;
import io.quarkus.restclient.config.RegisteredRestClient;
import io.quarkus.runtime.configuration.ConfigBuilder;
import java.util.ArrayList;
import java.util.List;

public final class RestClientConfigUtils {
    private RestClientConfigUtils() {
        throw new UnsupportedOperationException();
    }

    public static void generateRestClientConfigBuilder(List<RegisteredRestClient> restClients, BuildProducer<GeneratedClassBuildItem> generatedClass, BuildProducer<StaticInitConfigBuilderBuildItem> staticInitConfigBuilder, BuildProducer<RunTimeConfigBuilderBuildItem> runTimeConfigBuilder) {
        String className = "io.quarkus.runtime.generated.RestClientConfigBuilder";
        try (ClassCreator classCreator = ClassCreator.builder().classOutput((ClassOutput)new GeneratedClassGizmoAdaptor(generatedClass, true)).className(className).superClass(AbstractRestClientConfigBuilder.class).interfaces(new Class[]{ConfigBuilder.class}).setFinal(true).build();){
            MethodCreator method = classCreator.getMethodCreator(MethodDescriptor.ofMethod(AbstractRestClientConfigBuilder.class, (String)"getRestClients", List.class, (Class[])new Class[0]));
            ResultHandle list = method.newInstance(MethodDescriptor.ofConstructor(ArrayList.class, (Class[])new Class[0]), new ResultHandle[0]);
            for (RegisteredRestClient restClient : restClients) {
                ResultHandle restClientElement = method.newInstance(MethodDescriptor.ofConstructor(RegisteredRestClient.class, (Class[])new Class[]{String.class, String.class, String.class}), new ResultHandle[]{method.load(restClient.getFullName()), method.load(restClient.getSimpleName()), restClient.getConfigKey() != null ? method.load(restClient.getConfigKey()) : method.loadNull()});
                method.invokeVirtualMethod(MethodDescriptor.ofMethod(ArrayList.class, (String)"add", Boolean.TYPE, (Class[])new Class[]{Object.class}), list, new ResultHandle[]{restClientElement});
            }
            method.returnValue(list);
        }
        staticInitConfigBuilder.produce((BuildItem)new StaticInitConfigBuilderBuildItem(className));
        runTimeConfigBuilder.produce((BuildItem)new RunTimeConfigBuilderBuildItem(className));
    }
}

