/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.restclient.config;

import io.smallrye.config.NameIterator;

public class RegisteredRestClient {
    private final String fullName;
    private final String simpleName;
    private final String configKey;
    private final boolean configKeySegments;

    public RegisteredRestClient(String fullName, String simpleName) {
        this(fullName, simpleName, null);
    }

    public RegisteredRestClient(String fullName, String simpleName, String configKey) {
        this.fullName = fullName;
        this.simpleName = simpleName;
        this.configKey = configKey;
        this.configKeySegments = configKey != null && new NameIterator(configKey).nextSegmentEquals(configKey);
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    public String getConfigKey() {
        return this.configKey;
    }

    public boolean isConfigKeySegments() {
        if (this.configKey == null) {
            throw new IllegalStateException("configKey is null");
        }
        return !this.configKeySegments;
    }
}

