/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.restclient.config;

import io.quarkus.restclient.config.AbstractRestClientConfigBuilder;
import io.quarkus.restclient.config.RegisteredRestClient;
import io.smallrye.config.ConfigValue;
import io.smallrye.config.FallbackConfigSourceInterceptor;
import io.smallrye.config.NameIterator;
import io.smallrye.config.ProfileConfigSourceInterceptor;
import jakarta.annotation.Priority;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.function.Function;

@Priority(value=3605)
public class RestClientNameUnquotedFallbackInterceptor
extends FallbackConfigSourceInterceptor {
    private static final Comparator<ConfigValue> CONFIG_SOURCE_COMPARATOR = new Comparator<ConfigValue>(){

        @Override
        public int compare(ConfigValue original, ConfigValue candidate) {
            int result = Integer.compare(original.getConfigSourceOrdinal(), candidate.getConfigSourceOrdinal());
            if (result != 0) {
                return result;
            }
            result = Integer.compare(original.getConfigSourcePosition(), candidate.getConfigSourcePosition()) * -1;
            if (result != 0) {
                return result;
            }
            if (original.getName().charAt(0) == '%' && candidate.getName().charAt(0) == '%') {
                List originalProfiles = ProfileConfigSourceInterceptor.convertProfile((String)new NameIterator(original.getName()).getNextSegment().substring(1));
                List candidateProfiles = ProfileConfigSourceInterceptor.convertProfile((String)new NameIterator(candidate.getName()).getNextSegment().substring(1));
                return Integer.compare(originalProfiles.size(), candidateProfiles.size()) * -1;
            }
            return result;
        }
    };

    public RestClientNameUnquotedFallbackInterceptor(List<RegisteredRestClient> restClients, Set<String> ignoreNames) {
        super(RestClientNameUnquotedFallbackInterceptor.relocate(restClients, ignoreNames));
    }

    private static Function<String, String> relocate(final List<RegisteredRestClient> restClients, final Set<String> ignoreNames) {
        return new Function<String, String>(){

            @Override
            public String apply(String name) {
                int indexOfRestClient = AbstractRestClientConfigBuilder.indexOfRestClient(name);
                if (indexOfRestClient != -1) {
                    if (ignoreNames.contains(name)) {
                        return name;
                    }
                    for (RegisteredRestClient restClient : restClients) {
                        String configKey = restClient.getConfigKey();
                        if (configKey == null || configKey.isEmpty() || restClient.isConfigKeySegments()) continue;
                        int endOfConfigKey = indexOfRestClient + configKey.length();
                        if (!name.regionMatches(indexOfRestClient, configKey, 0, configKey.length()) || name.length() <= endOfConfigKey || name.charAt(endOfConfigKey) != '.') continue;
                        return "quarkus.rest-client.\"" + configKey + "\"" + name.substring(endOfConfigKey);
                    }
                }
                return name;
            }
        };
    }
}

