/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.restclient.config;

import io.quarkus.restclient.config.RegisteredRestClient;
import io.quarkus.restclient.config.RestClientsConfig;
import io.quarkus.runtime.configuration.ConfigBuilder;
import io.smallrye.config.ConfigSourceInterceptor;
import io.smallrye.config.ConfigSourceInterceptorContext;
import io.smallrye.config.ConfigSourceInterceptorFactory;
import io.smallrye.config.ConfigValue;
import io.smallrye.config.FallbackConfigSourceInterceptor;
import io.smallrye.config.RelocateConfigSourceInterceptor;
import io.smallrye.config.SmallRyeConfigBuilder;
import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.function.Function;

public abstract class AbstractRestClientConfigBuilder
implements ConfigBuilder {
    private static final String REST_CLIENT_PREFIX = "quarkus.rest-client.";
    private final boolean runtime;
    private static final Map<String, String> MICROPROFILE_NAMES = new HashMap<String, String>();

    public AbstractRestClientConfigBuilder() {
        this.runtime = true;
        RestClientsConfig.RestClientKeysProvider.KEYS.clear();
    }

    public AbstractRestClientConfigBuilder(boolean runtime) {
        this.runtime = runtime;
    }

    public SmallRyeConfigBuilder configBuilder(SmallRyeConfigBuilder builder) {
        List<RegisteredRestClient> restClients = this.getRestClients();
        final HashMap<Object, Object> quarkusFallbacks = new HashMap<Object, Object>();
        final HashMap<CallSite, CallSite> microProfileFallbacks = new HashMap<CallSite, CallSite>();
        final HashMap<Object, CallSite> relocates = new HashMap<Object, CallSite>();
        for (RegisteredRestClient restClient : restClients) {
            String quotedConfigKey;
            if (this.runtime) {
                RestClientsConfig.RestClientKeysProvider.KEYS.add(restClient.getFullName());
            }
            String quotedFullName = "\"" + restClient.getFullName() + "\"";
            quarkusFallbacks.put(quotedFullName, restClient.getSimpleName());
            relocates.put(restClient.getSimpleName(), (CallSite)((Object)quotedFullName));
            String quotedSimpleName = "\"" + restClient.getSimpleName() + "\"";
            quarkusFallbacks.put(restClient.getSimpleName(), quotedSimpleName);
            relocates.put(quotedSimpleName, (CallSite)((Object)quotedFullName));
            String configKey = restClient.getConfigKey();
            if (!(configKey == null || restClient.isConfigKeyEqualsNames() || (quotedConfigKey = "\"" + configKey + "\"").equals(quotedFullName) || quotedConfigKey.equals(quotedSimpleName))) {
                if (restClient.isConfigKeyComposed()) {
                    quarkusFallbacks.put(quotedSimpleName, quotedConfigKey);
                    relocates.put(quotedConfigKey, (CallSite)((Object)quotedFullName));
                } else {
                    quarkusFallbacks.put(quotedSimpleName, configKey);
                    relocates.put(configKey, (CallSite)((Object)quotedFullName));
                    quarkusFallbacks.put(configKey, quotedConfigKey);
                    relocates.put(quotedConfigKey, (CallSite)((Object)quotedFullName));
                }
            }
            String mpRestFullName = restClient.getFullName() + "/mp-rest/";
            microProfileFallbacks.put((CallSite)((Object)quotedFullName), (CallSite)((Object)mpRestFullName));
            relocates.put(mpRestFullName, (CallSite)((Object)quotedFullName));
            if (configKey == null || configKey.equals(restClient.getFullName())) continue;
            String mpConfigKey = configKey + "/mp-rest/";
            microProfileFallbacks.put((CallSite)((Object)mpRestFullName), (CallSite)((Object)mpConfigKey));
            relocates.put(mpConfigKey, (CallSite)((Object)quotedFullName));
        }
        builder.withInterceptorFactories(new ConfigSourceInterceptorFactory[]{new ConfigSourceInterceptorFactory(){

            public ConfigSourceInterceptor getInterceptor(ConfigSourceInterceptorContext context) {
                return new Fallbacks(new QuarkusFallbacks(quarkusFallbacks));
            }

            public OptionalInt getPriority() {
                return OptionalInt.of(3590);
            }
        }});
        builder.withInterceptorFactories(new ConfigSourceInterceptorFactory[]{new ConfigSourceInterceptorFactory(){

            public ConfigSourceInterceptor getInterceptor(ConfigSourceInterceptorContext context) {
                return new Fallbacks(new MicroProfileFallbacks(microProfileFallbacks));
            }

            public OptionalInt getPriority() {
                return OptionalInt.of(3595);
            }
        }});
        builder.withInterceptorFactories(new ConfigSourceInterceptorFactory[]{new ConfigSourceInterceptorFactory(){

            public ConfigSourceInterceptor getInterceptor(ConfigSourceInterceptorContext context) {
                return new RelocateConfigSourceInterceptor(new Relocates(relocates)){

                    public ConfigValue getValue(ConfigSourceInterceptorContext context, String name) {
                        return context.proceed(name);
                    }
                };
            }
        }});
        return builder;
    }

    public abstract List<RegisteredRestClient> getRestClients();

    private static int indexOfRestClient(String name) {
        if (name.startsWith(REST_CLIENT_PREFIX)) {
            return 20;
        }
        return -1;
    }

    static {
        MICROPROFILE_NAMES.put("url", "url");
        MICROPROFILE_NAMES.put("uri", "uri");
        MICROPROFILE_NAMES.put("scope", "scope");
        MICROPROFILE_NAMES.put("providers", "providers");
        MICROPROFILE_NAMES.put("connect-timeout", "connectTimeout");
        MICROPROFILE_NAMES.put("read-timeout", "readTimeout");
        MICROPROFILE_NAMES.put("follow-redirects", "followRedirects");
        MICROPROFILE_NAMES.put("proxy-address", "proxyAddress");
        MICROPROFILE_NAMES.put("query-param-style", "queryParamStyle");
        MICROPROFILE_NAMES.put("hostname-verifier", "hostnameVerifier");
        MICROPROFILE_NAMES.put("verify-host", "verifyHost");
        MICROPROFILE_NAMES.put("trust-store", "trustStore");
        MICROPROFILE_NAMES.put("trust-store-password", "trustStorePassword");
        MICROPROFILE_NAMES.put("trust-store-type", "trustStoreType");
        MICROPROFILE_NAMES.put("key-store", "keyStore");
        MICROPROFILE_NAMES.put("key-store-password", "keyStorePassword");
        MICROPROFILE_NAMES.put("key-store-type", "keyStoreType");
        MICROPROFILE_NAMES.put("connectTimeout", "connect-timeout");
        MICROPROFILE_NAMES.put("readTimeout", "read-timeout");
        MICROPROFILE_NAMES.put("followRedirects", "follow-redirects");
        MICROPROFILE_NAMES.put("proxyAddress", "proxy-address");
        MICROPROFILE_NAMES.put("queryParamStyle", "query-param-style");
        MICROPROFILE_NAMES.put("hostnameVerifier", "hostname-verifier");
        MICROPROFILE_NAMES.put("verifyHost", "verify-host");
        MICROPROFILE_NAMES.put("trustStore", "trust-store");
        MICROPROFILE_NAMES.put("trustStorePassword", "trust-store-password");
        MICROPROFILE_NAMES.put("trustStoreType", "trust-store-type");
        MICROPROFILE_NAMES.put("keyStore", "key-store");
        MICROPROFILE_NAMES.put("keyStorePassword", "key-store-password");
        MICROPROFILE_NAMES.put("keyStoreType", "key-store-type");
    }

    private record Relocates(Map<String, String> names) implements Function<String, String>
    {
        @Override
        public String apply(String name) {
            String property;
            int slash;
            int indexOfRestClient = AbstractRestClientConfigBuilder.indexOfRestClient(name);
            if (indexOfRestClient != -1) {
                for (Map.Entry<String, String> entry : this.names.entrySet()) {
                    String original = entry.getKey();
                    String target = entry.getValue();
                    int endOfConfigKey = indexOfRestClient + original.length();
                    if (!name.regionMatches(indexOfRestClient, original, 0, original.length()) || name.length() <= endOfConfigKey || name.charAt(endOfConfigKey) != '.') continue;
                    return AbstractRestClientConfigBuilder.REST_CLIENT_PREFIX + target + name.substring(endOfConfigKey);
                }
            }
            if ((slash = name.indexOf("/")) != -1 && name.regionMatches(slash + 1, "mp-rest/", 0, 8) && MICROPROFILE_NAMES.containsKey(property = name.substring(slash + 9))) {
                return "quarkus.rest-client.\"" + name.substring(0, slash) + "\"." + MICROPROFILE_NAMES.getOrDefault(property, property);
            }
            return name;
        }
    }

    private record MicroProfileFallbacks(Map<String, String> names) implements Function<String, String>
    {
        @Override
        public String apply(String name) {
            int slash;
            int indexOfRestClient = AbstractRestClientConfigBuilder.indexOfRestClient(name);
            if (indexOfRestClient != -1) {
                for (Map.Entry<String, String> entry : this.names.entrySet()) {
                    String original = entry.getKey();
                    String target = entry.getValue();
                    int endOfConfigKey = indexOfRestClient + original.length();
                    if (!name.regionMatches(indexOfRestClient, original, 0, original.length()) || name.length() <= endOfConfigKey || name.charAt(endOfConfigKey) != '.') continue;
                    String property = name.substring(endOfConfigKey + 1);
                    return target + MICROPROFILE_NAMES.getOrDefault(property, property);
                }
            }
            if ((slash = name.indexOf("/")) != -1 && name.regionMatches(slash + 1, "mp-rest/", 0, 8)) {
                for (Map.Entry<String, String> entry : this.names.entrySet()) {
                    String property;
                    String original = entry.getKey();
                    String target = entry.getValue();
                    if (!name.regionMatches(0, original, 0, original.length()) || !MICROPROFILE_NAMES.containsKey(property = name.substring(slash + 9))) continue;
                    return target + property;
                }
            }
            return name;
        }
    }

    private record QuarkusFallbacks(Map<String, String> names) implements Function<String, String>
    {
        @Override
        public String apply(String name) {
            int indexOfRestClient = AbstractRestClientConfigBuilder.indexOfRestClient(name);
            if (indexOfRestClient != -1) {
                for (Map.Entry<String, String> entry : this.names.entrySet()) {
                    String original = entry.getKey();
                    String target = entry.getValue();
                    int endOfConfigKey = indexOfRestClient + original.length();
                    if (!name.regionMatches(indexOfRestClient, original, 0, original.length()) || name.length() <= endOfConfigKey || name.charAt(endOfConfigKey) != '.') continue;
                    return AbstractRestClientConfigBuilder.REST_CLIENT_PREFIX + target + name.substring(endOfConfigKey);
                }
            }
            return name;
        }
    }

    private static class Fallbacks
    extends FallbackConfigSourceInterceptor {
        public Fallbacks(Function<String, String> mapping) {
            super(mapping);
        }

        public ConfigValue getValue(ConfigSourceInterceptorContext context, String name) {
            ConfigValue configValue = context.proceed(name);
            String map = (String)this.getMapping().apply(name);
            if (name.equals(map)) {
                return configValue;
            }
            ConfigValue fallbackValue = context.restart(map);
            if (configValue != null && fallbackValue != null) {
                return ConfigValue.CONFIG_SOURCE_COMPARATOR.compare(configValue, fallbackValue) >= 0 ? configValue : fallbackValue.withName(name);
            }
            if (configValue != null) {
                return configValue;
            }
            if (fallbackValue != null) {
                return fallbackValue.withName(name);
            }
            return null;
        }
    }
}

