/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.restclient.config;

import io.quarkus.restclient.config.RegisteredRestClient;
import io.quarkus.restclient.config.RestClientKeysProvider;
import io.quarkus.runtime.configuration.ConfigBuilder;
import io.smallrye.config.ConfigSourceInterceptor;
import io.smallrye.config.ConfigSourceInterceptorContext;
import io.smallrye.config.ConfigSourceInterceptorFactory;
import io.smallrye.config.ConfigValue;
import io.smallrye.config.FallbackConfigSourceInterceptor;
import io.smallrye.config.RelocateConfigSourceInterceptor;
import io.smallrye.config.SmallRyeConfigBuilder;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.function.Function;
import java.util.function.Supplier;

public abstract class AbstractRestClientConfigBuilder
implements ConfigBuilder {
    private static final String REST_CLIENT_PREFIX = "quarkus.rest-client.";
    private static final Map<String, String> MICROPROFILE_NAMES = new HashMap<String, String>();

    public SmallRyeConfigBuilder configBuilder(SmallRyeConfigBuilder builder) {
        RestClientKeysProvider.KEYS.clear();
        List<RegisteredRestClient> restClients = this.getRestClients();
        final HashMap<Object, Object> quarkusFallbacks = new HashMap<Object, Object>();
        final HashMap<CallSite, CallSite> microProfileFallbacks = new HashMap<CallSite, CallSite>();
        final HashMap relocates = new HashMap();
        for (RegisteredRestClient restClient : restClients) {
            RestClientKeysProvider.KEYS.add(restClient.getFullName());
            String quotedFullName = "\"" + restClient.getFullName() + "\"";
            String quotedSimpleName = "\"" + restClient.getSimpleName() + "\"";
            String configKey = restClient.getConfigKey();
            ArrayList<Object> fullNameRelocates = new ArrayList<Object>();
            relocates.put((CallSite)((Object)quotedFullName), fullNameRelocates);
            if (configKey != null && !restClient.isConfigKeyEqualsNames()) {
                String quotedConfigKey = "\"" + configKey + "\"";
                if (!quotedConfigKey.equals(quotedFullName) && !quotedConfigKey.equals(quotedSimpleName)) {
                    if (restClient.isConfigKeyComposed()) {
                        quarkusFallbacks.put(quotedFullName, quotedConfigKey);
                        quarkusFallbacks.put(quotedConfigKey, restClient.getSimpleName());
                        if (!quotedSimpleName.equals(quotedFullName)) {
                            quarkusFallbacks.put(restClient.getSimpleName(), quotedSimpleName);
                        }
                        fullNameRelocates.add(quotedConfigKey);
                        fullNameRelocates.add(restClient.getSimpleName());
                        fullNameRelocates.add(quotedSimpleName);
                    } else {
                        quarkusFallbacks.put(quotedFullName, configKey);
                        quarkusFallbacks.put(configKey, quotedConfigKey);
                        quarkusFallbacks.put(quotedConfigKey, restClient.getSimpleName());
                        if (!quotedSimpleName.equals(quotedFullName)) {
                            quarkusFallbacks.put(restClient.getSimpleName(), quotedSimpleName);
                        }
                        fullNameRelocates.add(configKey);
                        fullNameRelocates.add(quotedConfigKey);
                        fullNameRelocates.add(restClient.getSimpleName());
                        fullNameRelocates.add(quotedSimpleName);
                    }
                } else {
                    quarkusFallbacks.put(quotedFullName, restClient.getSimpleName());
                    if (!quotedSimpleName.equals(quotedFullName)) {
                        quarkusFallbacks.put(restClient.getSimpleName(), quotedSimpleName);
                    }
                    fullNameRelocates.add(restClient.getSimpleName());
                    fullNameRelocates.add(quotedSimpleName);
                }
            } else {
                quarkusFallbacks.put(quotedFullName, restClient.getSimpleName());
                if (!quotedSimpleName.equals(quotedFullName)) {
                    quarkusFallbacks.put(restClient.getSimpleName(), quotedSimpleName);
                }
                fullNameRelocates.add(restClient.getSimpleName());
                fullNameRelocates.add(quotedSimpleName);
            }
            String mpRestFullName = restClient.getFullName() + "/mp-rest/";
            microProfileFallbacks.put((CallSite)((Object)quotedFullName), (CallSite)((Object)mpRestFullName));
            fullNameRelocates.add(mpRestFullName);
            if (configKey == null || configKey.equals(restClient.getFullName())) continue;
            String mpConfigKey = configKey + "/mp-rest/";
            microProfileFallbacks.put((CallSite)((Object)mpRestFullName), (CallSite)((Object)mpConfigKey));
            fullNameRelocates.add(mpConfigKey);
        }
        builder.withInterceptorFactories(new ConfigSourceInterceptorFactory[]{new ConfigSourceInterceptorFactory(){

            public ConfigSourceInterceptor getInterceptor(ConfigSourceInterceptorContext context) {
                return new Fallbacks(new QuarkusFallbacks(quarkusFallbacks));
            }

            public OptionalInt getPriority() {
                return OptionalInt.of(3590);
            }
        }});
        builder.withInterceptorFactories(new ConfigSourceInterceptorFactory[]{new ConfigSourceInterceptorFactory(){

            public ConfigSourceInterceptor getInterceptor(ConfigSourceInterceptorContext context) {
                return new Fallbacks(new MicroProfileFallbacks(microProfileFallbacks));
            }

            public OptionalInt getPriority() {
                return OptionalInt.of(3595);
            }
        }});
        builder.withInterceptorFactories(new ConfigSourceInterceptorFactory[]{new ConfigSourceInterceptorFactory(){

            public ConfigSourceInterceptor getInterceptor(ConfigSourceInterceptorContext context) {
                return new Relocates(relocates);
            }
        }});
        builder.withInterceptors(new ConfigSourceInterceptor[]{new RenameConfigFallbackInterceptor(), new RenameConfigRelocateInterceptor()});
        return builder;
    }

    public abstract List<RegisteredRestClient> getRestClients();

    private static int indexOfRestClient(String name) {
        if (name.startsWith(REST_CLIENT_PREFIX)) {
            return 20;
        }
        return -1;
    }

    static {
        MICROPROFILE_NAMES.put("url", "url");
        MICROPROFILE_NAMES.put("uri", "uri");
        MICROPROFILE_NAMES.put("scope", "scope");
        MICROPROFILE_NAMES.put("providers", "providers");
        MICROPROFILE_NAMES.put("connect-timeout", "connectTimeout");
        MICROPROFILE_NAMES.put("read-timeout", "readTimeout");
        MICROPROFILE_NAMES.put("follow-redirects", "followRedirects");
        MICROPROFILE_NAMES.put("proxy-address", "proxyAddress");
        MICROPROFILE_NAMES.put("query-param-style", "queryParamStyle");
        MICROPROFILE_NAMES.put("hostname-verifier", "hostnameVerifier");
        MICROPROFILE_NAMES.put("verify-host", "verifyHost");
        MICROPROFILE_NAMES.put("trust-store", "trustStore");
        MICROPROFILE_NAMES.put("trust-store-password", "trustStorePassword");
        MICROPROFILE_NAMES.put("trust-store-type", "trustStoreType");
        MICROPROFILE_NAMES.put("key-store", "keyStore");
        MICROPROFILE_NAMES.put("key-store-password", "keyStorePassword");
        MICROPROFILE_NAMES.put("key-store-type", "keyStoreType");
        MICROPROFILE_NAMES.put("connectTimeout", "connect-timeout");
        MICROPROFILE_NAMES.put("readTimeout", "read-timeout");
        MICROPROFILE_NAMES.put("followRedirects", "follow-redirects");
        MICROPROFILE_NAMES.put("proxyAddress", "proxy-address");
        MICROPROFILE_NAMES.put("queryParamStyle", "query-param-style");
        MICROPROFILE_NAMES.put("hostnameVerifier", "hostname-verifier");
        MICROPROFILE_NAMES.put("verifyHost", "verify-host");
        MICROPROFILE_NAMES.put("trustStore", "trust-store");
        MICROPROFILE_NAMES.put("trustStorePassword", "trust-store-password");
        MICROPROFILE_NAMES.put("trustStoreType", "trust-store-type");
        MICROPROFILE_NAMES.put("keyStore", "key-store");
        MICROPROFILE_NAMES.put("keyStorePassword", "key-store-password");
        MICROPROFILE_NAMES.put("keyStoreType", "key-store-type");
    }

    private static class RenameConfigFallbackInterceptor
    extends FallbackConfigSourceInterceptor {
        private static final Function<String, String> COMPRESSION_FALLBACK = name -> {
            if (name.startsWith("quarkus.rest-client")) {
                int index = name.indexOf(".enable-response-decompression");
                if (index == -1) {
                    return name;
                }
                return name.substring(0, index) + ".enable-compression";
            }
            return name;
        };

        public RenameConfigFallbackInterceptor() {
            super(COMPRESSION_FALLBACK);
        }
    }

    private static class RenameConfigRelocateInterceptor
    extends RelocateConfigSourceInterceptor {
        private static final Function<String, String> COMPRESSION_RELOCATION = name -> {
            if (name.startsWith("quarkus.rest-client")) {
                int index = name.indexOf(".enable-compression");
                if (index == -1) {
                    return name;
                }
                return name.substring(0, index) + ".enable-response-decompression";
            }
            return name;
        };

        public RenameConfigRelocateInterceptor() {
            super(COMPRESSION_RELOCATION);
        }
    }

    private static class Relocates
    implements ConfigSourceInterceptor {
        private final Map<String, List<String>> relocates = new HashMap<String, List<String>>();

        Relocates(Map<String, List<String>> relocates) {
            for (Map.Entry<String, List<String>> entry : relocates.entrySet()) {
                for (String from : entry.getValue()) {
                    this.relocates.putIfAbsent(from, new ArrayList());
                    this.relocates.get(from).add(entry.getKey());
                }
            }
        }

        public ConfigValue getValue(ConfigSourceInterceptorContext context, String name) {
            return context.proceed(name);
        }

        public Iterator<String> iterateNames(final ConfigSourceInterceptorContext context) {
            final ArrayList relocatedNames = new ArrayList(this.relocates.size());
            ArrayList<Supplier<Iterator<String>>> iterators = new ArrayList<Supplier<Iterator<String>>>();
            iterators.add(new Supplier<Iterator<String>>(){

                @Override
                public Iterator<String> get() {
                    final Iterator names = context.iterateNames();
                    return new Iterator<String>(){

                        @Override
                        public boolean hasNext() {
                            return names.hasNext();
                        }

                        @Override
                        public String next() {
                            int slash;
                            String name = (String)names.next();
                            int indexOfRestClient = AbstractRestClientConfigBuilder.indexOfRestClient(name);
                            if (indexOfRestClient != -1) {
                                for (Map.Entry<String, List<String>> entry : relocates.entrySet()) {
                                    String original = entry.getKey();
                                    int endOfConfigKey = indexOfRestClient + original.length();
                                    if (!name.regionMatches(indexOfRestClient, original, 0, original.length()) || name.length() <= endOfConfigKey || name.charAt(endOfConfigKey) != '.') continue;
                                    for (String relocatedName : entry.getValue()) {
                                        relocatedNames.add(AbstractRestClientConfigBuilder.REST_CLIENT_PREFIX + relocatedName + name.substring(endOfConfigKey));
                                    }
                                    return name;
                                }
                            }
                            if ((slash = name.indexOf("/")) != -1 && name.regionMatches(slash + 1, "mp-rest/", 0, 8)) {
                                String property = name.substring(slash + 9);
                                if (MICROPROFILE_NAMES.containsKey(property)) {
                                    relocatedNames.add("quarkus.rest-client.\"" + name.substring(0, slash) + "\"." + MICROPROFILE_NAMES.getOrDefault(property, property));
                                }
                                return name;
                            }
                            return name;
                        }
                    };
                }
            });
            iterators.add(new Supplier<Iterator<String>>(){

                @Override
                public Iterator<String> get() {
                    return relocatedNames.iterator();
                }
            });
            final Iterator iterator = iterators.iterator();
            return new Iterator<String>(){
                Iterator<String> names;
                {
                    this.names = (Iterator)((Supplier)iterator.next()).get();
                }

                @Override
                public boolean hasNext() {
                    if (this.names.hasNext()) {
                        return true;
                    }
                    if (iterator.hasNext()) {
                        this.names = (Iterator)((Supplier)iterator.next()).get();
                    }
                    return this.names.hasNext();
                }

                @Override
                public String next() {
                    return this.names.next();
                }
            };
        }
    }

    private record MicroProfileFallbacks(Map<String, String> names) implements Function<String, String>
    {
        @Override
        public String apply(String name) {
            int slash;
            int indexOfRestClient = AbstractRestClientConfigBuilder.indexOfRestClient(name);
            if (indexOfRestClient != -1) {
                for (Map.Entry<String, String> entry : this.names.entrySet()) {
                    String original = entry.getKey();
                    String target = entry.getValue();
                    int endOfConfigKey = indexOfRestClient + original.length();
                    if (!name.regionMatches(indexOfRestClient, original, 0, original.length()) || name.length() <= endOfConfigKey || name.charAt(endOfConfigKey) != '.') continue;
                    String property = name.substring(endOfConfigKey + 1);
                    return target + MICROPROFILE_NAMES.getOrDefault(property, property);
                }
            }
            if ((slash = name.indexOf("/")) != -1 && name.regionMatches(slash + 1, "mp-rest/", 0, 8)) {
                for (Map.Entry<String, String> entry : this.names.entrySet()) {
                    String property;
                    String original = entry.getKey();
                    String target = entry.getValue();
                    if (!name.regionMatches(0, original, 0, original.length()) || !MICROPROFILE_NAMES.containsKey(property = name.substring(slash + 9))) continue;
                    return target + property;
                }
            }
            return name;
        }
    }

    private record QuarkusFallbacks(Map<String, String> names) implements Function<String, String>
    {
        @Override
        public String apply(String name) {
            int indexOfRestClient = AbstractRestClientConfigBuilder.indexOfRestClient(name);
            if (indexOfRestClient != -1) {
                for (Map.Entry<String, String> entry : this.names.entrySet()) {
                    String original = entry.getKey();
                    String target = entry.getValue();
                    int endOfConfigKey = indexOfRestClient + original.length();
                    if (!name.regionMatches(indexOfRestClient, original, 0, original.length()) || name.length() <= endOfConfigKey || name.charAt(endOfConfigKey) != '.') continue;
                    return AbstractRestClientConfigBuilder.REST_CLIENT_PREFIX + target + name.substring(endOfConfigKey);
                }
            }
            return name;
        }
    }

    private static class Fallbacks
    extends FallbackConfigSourceInterceptor {
        public Fallbacks(Function<String, String> mapping) {
            super(mapping);
        }

        public ConfigValue getValue(ConfigSourceInterceptorContext context, String name) {
            ConfigValue configValue = context.proceed(name);
            String map = (String)this.getMapping().apply(name);
            if (name.equals(map)) {
                return configValue;
            }
            ConfigValue fallbackValue = context.restart(map);
            if (configValue != null && fallbackValue != null) {
                return ConfigValue.CONFIG_SOURCE_COMPARATOR.compare(configValue, fallbackValue) >= 0 ? configValue : fallbackValue.withName(name);
            }
            if (configValue != null) {
                return configValue;
            }
            if (fallbackValue != null) {
                return fallbackValue.withName(name);
            }
            return null;
        }
    }
}

