/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.rest.client.reactive.deployment.devservices;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.IsNormal;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.BuildSteps;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.CuratedApplicationShutdownBuildItem;
import io.quarkus.deployment.builditem.DevServicesResultBuildItem;
import io.quarkus.rest.client.reactive.deployment.RegisteredRestClientBuildItem;
import io.quarkus.rest.client.reactive.deployment.devservices.VertxHttpProxyDevServicesRestClientProxyProvider;
import io.quarkus.rest.client.reactive.spi.DevServicesRestClientProxyProvider;
import io.quarkus.rest.client.reactive.spi.RestClientHttpProxyBuildItem;
import io.quarkus.restclient.config.RegisteredRestClient;
import io.quarkus.restclient.config.RestClientsBuildTimeConfig;
import io.smallrye.config.SmallRyeConfig;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.commons.lang3.exception.UncheckedException;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.IndexView;
import org.jboss.logging.Logger;

@BuildSteps(onlyIfNot={IsNormal.class})
public class DevServicesRestClientHttpProxyProcessor {
    private static final Logger log = Logger.getLogger(DevServicesRestClientHttpProxyProcessor.class);
    private static final AtomicReference<Set<RestClientHttpProxyBuildItem>> runningProxies = new AtomicReference(new HashSet());
    private static final AtomicReference<Set<DevServicesRestClientProxyProvider>> runningProviders = new AtomicReference(Collections.newSetFromMap(new IdentityHashMap()));
    private static final AtomicReference<Set<Closeable>> providerCloseables = new AtomicReference(Collections.newSetFromMap(new IdentityHashMap()));

    @BuildStep
    public DevServicesRestClientProxyProvider.BuildItem registerDefaultProvider() {
        return new DevServicesRestClientProxyProvider.BuildItem((DevServicesRestClientProxyProvider)VertxHttpProxyDevServicesRestClientProxyProvider.INSTANCE);
    }

    @BuildStep
    public void determineRequiredProxies(RestClientsBuildTimeConfig clientsConfig, CombinedIndexBuildItem combinedIndexBuildItem, List<RegisteredRestClientBuildItem> registeredRestClientBuildItems, BuildProducer<RestClientHttpProxyBuildItem> producer) {
        List<RegisteredRestClient> registeredRestClients = RegisteredRestClientBuildItem.toRegisteredRestClients(registeredRestClientBuildItems);
        Map configs = clientsConfig.get(registeredRestClients).clients();
        if (configs.isEmpty()) {
            return;
        }
        IndexView index = combinedIndexBuildItem.getIndex();
        SmallRyeConfig config = clientsConfig.getConfig(registeredRestClients);
        for (Map.Entry configEntry : configs.entrySet()) {
            if (!((RestClientsBuildTimeConfig.RestClientBuildConfig)configEntry.getValue()).enableLocalProxy()) {
                log.trace((Object)("Ignoring config key: '" + (String)configEntry.getKey() + "' because enableLocalProxy is false"));
                continue;
            }
            String configKey = (String)configEntry.getKey();
            Map restClientValues = config.getValues("quarkus.rest-client.\"" + configKey + "\"", String.class, String.class);
            RegisteredRestClientBuildItem matchingBI = null;
            for (RegisteredRestClientBuildItem bi : registeredRestClientBuildItems) {
                if (!bi.getConfigKey().isPresent() || !configKey.equals(bi.getConfigKey().get())) continue;
                matchingBI = bi;
                break;
            }
            if (matchingBI != null) {
                Optional baseUri = DevServicesRestClientHttpProxyProcessor.oneOf(Optional.ofNullable((String)restClientValues.get("uri")), Optional.ofNullable((String)restClientValues.get("url")), matchingBI.getDefaultBaseUri());
                if (baseUri.isEmpty()) {
                    log.debug((Object)("Unable to determine uri or url for config key '" + configKey + "'"));
                    continue;
                }
                producer.produce((BuildItem)new RestClientHttpProxyBuildItem(matchingBI.getClassInfo().name().toString(), (String)baseUri.get(), ((RestClientsBuildTimeConfig.RestClientBuildConfig)configEntry.getValue()).localProxyProvider()));
                continue;
            }
            ClassInfo classInfo = index.getClassByName(configKey);
            if (classInfo == null) {
                log.debug((Object)("Key '" + configKey + "' could not be matched to either a class name or a REST Client's configKey"));
                continue;
            }
            Optional baseUri = DevServicesRestClientHttpProxyProcessor.oneOf(Optional.ofNullable((String)restClientValues.get("uri")), Optional.ofNullable((String)restClientValues.get("url")));
            if (baseUri.isEmpty()) {
                log.debug((Object)("Unable to determine uri or url for config key '" + configKey + "'"));
                continue;
            }
            producer.produce((BuildItem)new RestClientHttpProxyBuildItem(classInfo.name().toString(), (String)baseUri.get(), ((RestClientsBuildTimeConfig.RestClientBuildConfig)configEntry.getValue()).localProxyProvider()));
        }
    }

    @BuildStep
    public void start(List<RestClientHttpProxyBuildItem> restClientHttpProxyBuildItems, List<DevServicesRestClientProxyProvider.BuildItem> restClientProxyProviderBuildItems, BuildProducer<DevServicesResultBuildItem> devServicePropertiesProducer, CuratedApplicationShutdownBuildItem closeBuildItem) {
        if (restClientHttpProxyBuildItems.isEmpty()) {
            return;
        }
        HashSet<RestClientHttpProxyBuildItem> requestedProxies = new HashSet<RestClientHttpProxyBuildItem>(restClientHttpProxyBuildItems);
        HashSet proxiesToClose = new HashSet(runningProxies.get());
        proxiesToClose.removeAll(requestedProxies);
        for (RestClientHttpProxyBuildItem running : proxiesToClose) {
            DevServicesRestClientHttpProxyProcessor.closeRunningProxy(running);
        }
        runningProxies.get().removeAll(proxiesToClose);
        HashSet<RestClientHttpProxyBuildItem> proxiesToRun = new HashSet<RestClientHttpProxyBuildItem>(requestedProxies);
        proxiesToRun.removeAll((Collection)runningProxies.get());
        HashMap<RestClientHttpProxyBuildItem, VertxHttpProxyDevServicesRestClientProxyProvider> biToProviderMap = new HashMap<RestClientHttpProxyBuildItem, VertxHttpProxyDevServicesRestClientProxyProvider>();
        for (RestClientHttpProxyBuildItem toStart : proxiesToRun) {
            VertxHttpProxyDevServicesRestClientProxyProvider provider;
            if (toStart.getProvider().isPresent()) {
                String requestedProviderName = (String)toStart.getProvider().get();
                Optional<DevServicesRestClientProxyProvider.BuildItem> maybeProviderBI = restClientProxyProviderBuildItems.stream().filter(pbi -> requestedProviderName.equals(pbi.getProvider().name())).findFirst();
                if (maybeProviderBI.isEmpty()) {
                    throw new RuntimeException("Unable to find provider for REST Client '" + toStart.getClassName() + "' with name '" + requestedProviderName + "'");
                }
                provider = maybeProviderBI.get().getProvider();
            } else {
                List<DevServicesRestClientProxyProvider.BuildItem> nonDefault = restClientProxyProviderBuildItems.stream().filter(pib -> !pib.getProvider().name().equals("default")).toList();
                if (nonDefault.isEmpty()) {
                    provider = VertxHttpProxyDevServicesRestClientProxyProvider.INSTANCE;
                } else if (nonDefault.size() == 1) {
                    provider = nonDefault.iterator().next().getProvider();
                } else {
                    String availableProviders = restClientProxyProviderBuildItems.stream().map(bi -> bi.getProvider().name()).collect(Collectors.joining(","));
                    throw new RuntimeException("Multiple providers found for REST Client '" + toStart.getClassName() + "'. Please specify one by setting 'quarkus.rest-client.\"" + toStart.getClassName() + "\".local-proxy-provider' to one the following providers: " + availableProviders);
                }
            }
            biToProviderMap.put(toStart, provider);
        }
        HashSet providersToRun = new HashSet(biToProviderMap.values());
        providersToRun.removeAll((Collection)runningProviders.get());
        for (VertxHttpProxyDevServicesRestClientProxyProvider provider : providersToRun) {
            Closeable closeable = provider.setup();
            if (closeable != null) {
                providerCloseables.get().add(closeable);
            }
            runningProviders.get().add(provider);
        }
        for (RestClientHttpProxyBuildItem bi2 : proxiesToRun) {
            URI baseUri = URI.create(bi2.getBaseUri());
            DevServicesRestClientProxyProvider provider = (DevServicesRestClientProxyProvider)biToProviderMap.get(bi2);
            DevServicesRestClientProxyProvider.CreateResult createResult = provider.create(bi2);
            Closeable proxyServerClosable = createResult.closeable();
            bi2.attachClosable(proxyServerClosable);
            runningProxies.get().add(bi2);
            String urlKeyName = String.format("quarkus.rest-client.\"%s\".override-uri", bi2.getClassName());
            Object urlKeyValue = String.format("http://%s:%d", createResult.host(), createResult.port());
            String basePath = baseUri.getPath();
            if (basePath != null && !basePath.isEmpty()) {
                if (basePath.startsWith("/")) {
                    basePath = basePath.substring(1);
                }
                urlKeyValue = (String)urlKeyValue + "/" + basePath;
            }
            devServicePropertiesProducer.produce((BuildItem)new DevServicesResultBuildItem("rest-client-" + bi2.getClassName() + "-proxy", null, Map.of(urlKeyName, urlKeyValue)));
        }
        closeBuildItem.addCloseTask((Runnable)new CloseTask(runningProxies, providerCloseables, runningProviders), true);
    }

    private static void closeRunningProxy(RestClientHttpProxyBuildItem running) {
        try {
            Closeable closeable = running.getCloseable();
            if (closeable != null) {
                log.debug((Object)("Attempting to close HTTP proxy server for REST Client '" + running.getClassName() + "'"));
                closeable.close();
                log.debug((Object)("Closed HTTP proxy server for REST Client '" + running.getClassName() + "'"));
            }
        }
        catch (IOException e) {
            throw new UncheckedException((Throwable)e);
        }
    }

    @SafeVarargs
    private static <T> Optional<T> oneOf(Optional<T> ... optionals) {
        for (Optional<T> o : optionals) {
            if (o == null || !o.isPresent()) continue;
            return o;
        }
        return Optional.empty();
    }

    private static class CloseTask
    implements Runnable {
        private final AtomicReference<Set<RestClientHttpProxyBuildItem>> runningProxiesRef;
        private final AtomicReference<Set<Closeable>> providerCloseablesRef;
        private final AtomicReference<Set<DevServicesRestClientProxyProvider>> runningProvidersRef;

        public CloseTask(AtomicReference<Set<RestClientHttpProxyBuildItem>> runningProxiesRef, AtomicReference<Set<Closeable>> providerCloseablesRef, AtomicReference<Set<DevServicesRestClientProxyProvider>> runningProvidersRef) {
            this.runningProxiesRef = runningProxiesRef;
            this.providerCloseablesRef = providerCloseablesRef;
            this.runningProvidersRef = runningProvidersRef;
        }

        @Override
        public void run() {
            Set<RestClientHttpProxyBuildItem> restClientHttpProxyBuildItems = this.runningProxiesRef.get();
            for (RestClientHttpProxyBuildItem bi : restClientHttpProxyBuildItems) {
                DevServicesRestClientHttpProxyProcessor.closeRunningProxy(bi);
            }
            this.runningProxiesRef.set(new HashSet());
            Set<Closeable> providerCloseables = this.providerCloseablesRef.get();
            for (Closeable closeable : providerCloseables) {
                try {
                    if (closeable == null) continue;
                    log.debug((Object)"Attempting to close provider");
                    closeable.close();
                    log.debug((Object)"Closed provider");
                }
                catch (IOException e) {
                    throw new UncheckedException((Throwable)e);
                }
            }
            this.providerCloseablesRef.set(Collections.newSetFromMap(new IdentityHashMap()));
            this.runningProvidersRef.set(Collections.newSetFromMap(new IdentityHashMap()));
        }
    }
}

