/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.jaxrs.client.reactive.deployment;

import io.quarkus.deployment.GeneratedClassGizmoAdaptor;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.jaxrs.client.reactive.runtime.ParameterAnnotationsSupplier;
import io.quarkus.jaxrs.client.reactive.runtime.ParameterDescriptorFromClassSupplier;
import io.quarkus.jaxrs.client.reactive.runtime.ParameterGenericTypesSupplier;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.MethodInfo;

class ClassRestClientContext
implements AutoCloseable {
    public final ClassCreator classCreator;
    public final MethodCreator constructor;
    public final MethodCreator clinit;
    public final Map<Integer, FieldDescriptor> methodStaticFields = new HashMap<Integer, FieldDescriptor>();
    public final Map<Integer, FieldDescriptor> methodParamAnnotationsStaticFields = new HashMap<Integer, FieldDescriptor>();
    public final Map<Integer, FieldDescriptor> methodGenericParametersStaticFields = new HashMap<Integer, FieldDescriptor>();
    public final Map<String, FieldDescriptor> beanTypesParameterDescriptorsStaticFields = new HashMap<String, FieldDescriptor>();
    public final Map<String, ResultHandle> classesMap = new HashMap<String, ResultHandle>();
    private int beanParamIndex = 0;

    public ClassRestClientContext(String name, BuildProducer<GeneratedClassBuildItem> generatedClasses, String ... interfaces) {
        this(name, MethodDescriptor.ofConstructor((String)name, (String[])new String[0]), generatedClasses, Object.class, interfaces);
    }

    public ClassRestClientContext(String name, MethodDescriptor constructorDesc, BuildProducer<GeneratedClassBuildItem> generatedClasses, Class<?> superClass, String ... interfaces) {
        this.classCreator = new ClassCreator((ClassOutput)new GeneratedClassGizmoAdaptor(generatedClasses, true), name, null, superClass.getName(), interfaces);
        this.constructor = this.classCreator.getMethodCreator(constructorDesc);
        this.clinit = this.classCreator.getMethodCreator(MethodDescriptor.ofMethod((Object)name, (String)"<clinit>", Void.TYPE, (Object[])new Object[0]));
        this.clinit.setModifiers(8);
    }

    @Override
    public void close() {
        this.classCreator.close();
    }

    protected FieldDescriptor createJavaMethodField(ClassInfo interfaceClass, MethodInfo method, int methodIndex) {
        ResultHandle interfaceClassHandle = this.loadClass(interfaceClass.toString());
        ResultHandle parameterArray = this.clinit.newArray(Class.class, method.parametersCount());
        for (int i = 0; i < method.parametersCount(); ++i) {
            String parameterClass = method.parameterType(i).name().toString();
            this.clinit.writeArrayValue(parameterArray, i, this.loadClass(parameterClass));
        }
        ResultHandle javaMethodHandle = this.clinit.invokeVirtualMethod(MethodDescriptor.ofMethod(Class.class, (String)"getMethod", Method.class, (Class[])new Class[]{String.class, Class[].class}), interfaceClassHandle, new ResultHandle[]{this.clinit.load(method.name()), parameterArray});
        FieldDescriptor javaMethodField = FieldDescriptor.of((String)this.classCreator.getClassName(), (String)("javaMethod" + methodIndex), Method.class);
        this.classCreator.getFieldCreator(javaMethodField).setModifiers(26);
        this.clinit.writeStaticField(javaMethodField, javaMethodHandle);
        this.methodStaticFields.put(methodIndex, javaMethodField);
        return javaMethodField;
    }

    protected Supplier<FieldDescriptor> getLazyJavaMethodParamAnnotationsField(int methodIndex) {
        return () -> {
            FieldDescriptor methodParamAnnotationsField = this.methodParamAnnotationsStaticFields.get(methodIndex);
            if (methodParamAnnotationsField != null) {
                return methodParamAnnotationsField;
            }
            ResultHandle javaMethodParamAnnotationsHandle = this.clinit.newInstance(MethodDescriptor.ofConstructor(ParameterAnnotationsSupplier.class, (Class[])new Class[]{Method.class}), new ResultHandle[]{this.clinit.readStaticField(this.methodStaticFields.get(methodIndex))});
            FieldDescriptor javaMethodParamAnnotationsField = FieldDescriptor.of((String)this.classCreator.getClassName(), (String)("javaMethodParameterAnnotations" + methodIndex), Supplier.class);
            this.classCreator.getFieldCreator(javaMethodParamAnnotationsField).setModifiers(24);
            this.clinit.writeStaticField(javaMethodParamAnnotationsField, javaMethodParamAnnotationsHandle);
            this.methodParamAnnotationsStaticFields.put(methodIndex, javaMethodParamAnnotationsField);
            return javaMethodParamAnnotationsField;
        };
    }

    protected Supplier<FieldDescriptor> getLazyJavaMethodGenericParametersField(int methodIndex) {
        return () -> {
            FieldDescriptor methodGenericTypeField = this.methodGenericParametersStaticFields.get(methodIndex);
            if (methodGenericTypeField != null) {
                return methodGenericTypeField;
            }
            ResultHandle javaMethodGenericParametersHandle = this.clinit.newInstance(MethodDescriptor.ofConstructor(ParameterGenericTypesSupplier.class, (Class[])new Class[]{Method.class}), new ResultHandle[]{this.clinit.readStaticField(this.methodStaticFields.get(methodIndex))});
            FieldDescriptor javaMethodGenericParametersField = FieldDescriptor.of((String)this.classCreator.getClassName(), (String)("javaMethodGenericParameters" + methodIndex), Supplier.class);
            this.classCreator.getFieldCreator(javaMethodGenericParametersField).setModifiers(24);
            this.clinit.writeStaticField(javaMethodGenericParametersField, javaMethodGenericParametersHandle);
            this.methodGenericParametersStaticFields.put(methodIndex, javaMethodGenericParametersField);
            return javaMethodGenericParametersField;
        };
    }

    protected Supplier<FieldDescriptor> getLazyBeanParameterDescriptors(String beanClass) {
        return () -> {
            FieldDescriptor field = this.beanTypesParameterDescriptorsStaticFields.get(beanClass);
            if (field != null) {
                return field;
            }
            ResultHandle clazz = this.loadClass(beanClass);
            ResultHandle mapWithAnnotationsHandle = this.clinit.newInstance(MethodDescriptor.ofConstructor(ParameterDescriptorFromClassSupplier.class, (Class[])new Class[]{Class.class}), new ResultHandle[]{clazz});
            field = FieldDescriptor.of((String)this.classCreator.getClassName(), (String)("beanParamDescriptors" + this.beanParamIndex), Supplier.class);
            this.classCreator.getFieldCreator(field).setModifiers(24);
            this.clinit.writeStaticField(field, mapWithAnnotationsHandle);
            this.beanTypesParameterDescriptorsStaticFields.put(beanClass, field);
            ++this.beanParamIndex;
            return field;
        };
    }

    private ResultHandle loadClass(String className) {
        ResultHandle classType = this.classesMap.get(className);
        if (classType != null) {
            return classType;
        }
        ResultHandle classFromTCCL = this.clinit.loadClassFromTCCL(className);
        this.classesMap.put(className, classFromTCCL);
        return classFromTCCL;
    }
}

