/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.token.propagation.reactive;

import io.quarkus.arc.Arc;
import io.quarkus.oidc.client.OidcClient;
import io.quarkus.oidc.client.OidcClientConfig;
import io.quarkus.oidc.client.OidcClients;
import io.quarkus.oidc.client.runtime.DisabledOidcClientException;
import io.quarkus.runtime.configuration.ConfigurationException;
import io.quarkus.security.credential.TokenCredential;
import io.quarkus.vertx.core.runtime.context.VertxContextSafetyToggle;
import io.smallrye.mutiny.Uni;
import io.vertx.core.Vertx;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.Priority;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.ws.rs.core.Response;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.function.Consumer;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.logging.Logger;
import org.jboss.resteasy.reactive.client.spi.ResteasyReactiveClientRequestContext;
import org.jboss.resteasy.reactive.client.spi.ResteasyReactiveClientRequestFilter;

@Priority(value=1000)
public class AccessTokenRequestReactiveFilter
implements ResteasyReactiveClientRequestFilter {
    private static final Logger LOG = Logger.getLogger(AccessTokenRequestReactiveFilter.class);
    private static final String BEARER_SCHEME_WITH_SPACE = "Bearer ";
    private static final String ERROR_MSG = "OIDC Token Propagation Reactive requires a safe (isolated) Vert.x sub-context because configuration property 'quarkus.rest-client-oidc-token-propagation.enabled-during-authentication' has been set to true, but the current context hasn't been flagged as such.";
    private final boolean enabledDuringAuthentication = Boolean.getBoolean("io.quarkus.oidc.runtime.AbstractOidcAuthenticationMechanism.PROPAGATE_TOKEN_CREDENTIAL_WITH_DUPLICATED_CTX") || Boolean.getBoolean("io.quarkus.smallrye.jwt.runtime.auth.JWTAuthMechanism.PROPAGATE_TOKEN_CREDENTIAL_WITH_DUPLICATED_CTX");
    private final Instance<TokenCredential> accessToken = CDI.current().select(TokenCredential.class, new Annotation[0]);
    OidcClient exchangeTokenClient;
    String exchangeTokenProperty;

    @PostConstruct
    public void initExchangeTokenClient() {
        if (this.isExchangeToken()) {
            OidcClients clients = (OidcClients)Arc.container().instance(OidcClients.class, new Annotation[0]).get();
            String clientName = this.getClientName();
            this.exchangeTokenClient = clientName != null ? clients.getClient(clientName) : clients.getClient();
            OidcClientConfig.Grant.Type exchangeTokenGrantType = (OidcClientConfig.Grant.Type)ConfigProvider.getConfig().getValue("quarkus.oidc-client." + (String)(clientName != null ? clientName + "." : "") + "grant.type", OidcClientConfig.Grant.Type.class);
            if (exchangeTokenGrantType == OidcClientConfig.Grant.Type.EXCHANGE) {
                this.exchangeTokenProperty = "subject_token";
            } else if (exchangeTokenGrantType == OidcClientConfig.Grant.Type.JWT) {
                this.exchangeTokenProperty = "assertion";
            } else {
                throw new ConfigurationException("Token exchange is required but OIDC client is configured to use the " + exchangeTokenGrantType.getGrantType() + " grantType");
            }
        }
    }

    protected boolean isExchangeToken() {
        return (Boolean)ConfigProvider.getConfig().getValue("quarkus.rest-client-oidc-token-propagation.exchange-token", Boolean.TYPE);
    }

    public void filter(final ResteasyReactiveClientRequestContext requestContext) {
        if (this.verifyTokenInstance(requestContext)) {
            if (this.exchangeTokenClient != null) {
                requestContext.suspend();
                this.exchangeToken(this.getAccessToken().getToken()).subscribe().with((Consumer)new Consumer<String>(){

                    @Override
                    public void accept(String token) {
                        AccessTokenRequestReactiveFilter.this.propagateToken(requestContext, token);
                        requestContext.resume();
                    }
                }, (Consumer)new Consumer<Throwable>(){

                    @Override
                    public void accept(Throwable t) {
                        if (t instanceof DisabledOidcClientException) {
                            LOG.debug((Object)"Client is disabled");
                            requestContext.abortWith(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build());
                        } else {
                            LOG.debugf("Access token is not available, aborting the request with HTTP 401 error: %s", (Object)t.getMessage());
                            requestContext.abortWith(Response.status((Response.Status)Response.Status.UNAUTHORIZED).build());
                        }
                        requestContext.resume();
                    }
                });
            } else {
                this.propagateToken(requestContext, this.getAccessToken().getToken());
            }
        } else {
            this.abortRequest(requestContext);
        }
    }

    protected String getClientName() {
        return ConfigProvider.getConfig().getOptionalValue("quarkus.rest-client-oidc-token-propagation.client-name", String.class).orElse(null);
    }

    public void propagateToken(ResteasyReactiveClientRequestContext requestContext, String accessToken) {
        if (accessToken != null) {
            requestContext.getHeaders().putSingle((Object)"Authorization", (Object)(BEARER_SCHEME_WITH_SPACE + accessToken));
        } else {
            LOG.debugf("Access token is null, aborting the request with HTTP 401 error", new Object[0]);
            this.abortRequest(requestContext);
        }
    }

    protected boolean verifyTokenInstance(ResteasyReactiveClientRequestContext requestContext) {
        TokenCredential tokenCredential;
        if (this.enabledDuringAuthentication && (tokenCredential = AccessTokenRequestReactiveFilter.getTokenCredentialFromContext()) != null) {
            if (tokenCredential.getToken() == null) {
                LOG.debugf("Propagated access token is null, aborting the request with HTTP 401 error", new Object[0]);
                return false;
            }
            return true;
        }
        if (!this.accessToken.isResolvable()) {
            LOG.debugf("Access token is not injected, aborting the request with HTTP 401 error", new Object[0]);
            return false;
        }
        if (this.accessToken.isAmbiguous()) {
            LOG.debugf("More than one access token instance is available, aborting the request with HTTP 401 error", new Object[0]);
            return false;
        }
        if (((TokenCredential)this.accessToken.get()).getToken() == null) {
            LOG.debugf("Injected access token is null, aborting the request with HTTP 401 error", new Object[0]);
            return false;
        }
        return true;
    }

    private TokenCredential getAccessToken() {
        TokenCredential tokenCredential;
        if (this.enabledDuringAuthentication && (tokenCredential = AccessTokenRequestReactiveFilter.getTokenCredentialFromContext()) != null) {
            return tokenCredential;
        }
        return (TokenCredential)this.accessToken.get();
    }

    private static TokenCredential getTokenCredentialFromContext() {
        VertxContextSafetyToggle.validateContextIfExists((String)ERROR_MSG, (String)ERROR_MSG);
        return (TokenCredential)Vertx.currentContext().getLocal((Object)TokenCredential.class.getName());
    }

    private Uni<String> exchangeToken(String token) {
        return this.exchangeTokenClient.getTokens(Collections.singletonMap(this.exchangeTokenProperty, token)).onItem().transform(t -> t.getAccessToken());
    }

    protected void abortRequest(ResteasyReactiveClientRequestContext requestContext) {
        requestContext.abortWith(Response.status((int)401).build());
    }
}

