/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.rest.client.reactive.deployment;

import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.deployment.GeneratedClassGizmoAdaptor;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.gizmo.AssignableResultHandle;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.CatchBlockCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FieldCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.gizmo.TryBlock;
import io.quarkus.jaxrs.client.reactive.deployment.JaxrsClientReactiveEnricher;
import io.quarkus.rest.client.reactive.HeaderFiller;
import io.quarkus.rest.client.reactive.deployment.DotNames;
import io.quarkus.rest.client.reactive.runtime.NoOpHeaderFiller;
import io.quarkus.rest.client.reactive.runtime.RestClientReactiveRequestFilter;
import io.quarkus.runtime.util.HashUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.Configurable;
import javax.ws.rs.core.MultivaluedMap;
import org.eclipse.microprofile.rest.client.RestClientDefinitionException;
import org.eclipse.microprofile.rest.client.ext.ClientHeadersFactory;
import org.eclipse.microprofile.rest.client.ext.DefaultClientHeadersFactoryImpl;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

class RestClientReactiveEnricher
implements JaxrsClientReactiveEnricher {
    private static final Logger log = Logger.getLogger(RestClientReactiveEnricher.class);
    public static final String DEFAULT_HEADERS_FACTORY = DefaultClientHeadersFactoryImpl.class.getName();
    private static final AnnotationInstance[] EMPTY_ANNOTATION_INSTANCES = new AnnotationInstance[0];
    private static final MethodDescriptor INVOCATION_BUILDER_PROPERTY_METHOD = MethodDescriptor.ofMethod(Invocation.Builder.class, (String)"property", Invocation.Builder.class, (Class[])new Class[]{String.class, Object.class});
    private static final MethodDescriptor LIST_ADD_METHOD = MethodDescriptor.ofMethod(List.class, (String)"add", Boolean.TYPE, (Class[])new Class[]{Object.class});
    private static final MethodDescriptor MAP_PUT_METHOD = MethodDescriptor.ofMethod(Map.class, (String)"put", Object.class, (Class[])new Class[]{Object.class, Object.class});
    private static final MethodDescriptor MAP_CONTAINS_KEY_METHOD = MethodDescriptor.ofMethod(Map.class, (String)"containsKey", Boolean.TYPE, (Class[])new Class[]{Object.class});
    public static final String INVOKED_METHOD = "org.eclipse.microprofile.rest.client.invokedMethod";
    private final Map<ClassInfo, String> interfaceMocks = new HashMap<ClassInfo, String>();

    RestClientReactiveEnricher() {
    }

    public void forClass(MethodCreator constructor, AssignableResultHandle webTargetBase, ClassInfo interfaceClass, IndexView index) {
        String headersFactoryClass;
        AnnotationInstance annotation = interfaceClass.classAnnotation(DotNames.REGISTER_PROVIDER);
        AnnotationInstance groupAnnotation = interfaceClass.classAnnotation(DotNames.REGISTER_PROVIDERS);
        if (annotation != null) {
            this.addProvider(constructor, webTargetBase, index, annotation);
        }
        for (AnnotationInstance annotationInstance : this.extractAnnotations(groupAnnotation)) {
            this.addProvider(constructor, webTargetBase, index, annotationInstance);
        }
        ResultHandle clientHeadersFactory = null;
        AnnotationInstance registerClientHeaders = interfaceClass.classAnnotation(DotNames.REGISTER_CLIENT_HEADERS);
        boolean useDefaultHeaders = true;
        if (registerClientHeaders != null && !(headersFactoryClass = registerClientHeaders.valueWithDefault(index).asClass().name().toString()).equals(DEFAULT_HEADERS_FACTORY)) {
            ResultHandle containerHandle = constructor.invokeStaticMethod(MethodDescriptor.ofMethod(Arc.class, (String)"container", ArcContainer.class, (Class[])new Class[0]), new ResultHandle[0]);
            ResultHandle instanceHandle = constructor.invokeInterfaceMethod(MethodDescriptor.ofMethod(ArcContainer.class, (String)"instance", InstanceHandle.class, (Class[])new Class[]{Class.class, Annotation[].class}), containerHandle, new ResultHandle[]{constructor.loadClass(headersFactoryClass), constructor.newArray(Annotation.class, 0)});
            clientHeadersFactory = constructor.invokeInterfaceMethod(MethodDescriptor.ofMethod(InstanceHandle.class, (String)"get", Object.class, (Class[])new Class[0]), instanceHandle, new ResultHandle[0]);
            useDefaultHeaders = false;
        }
        if (useDefaultHeaders) {
            clientHeadersFactory = constructor.newInstance(MethodDescriptor.ofConstructor((String)DEFAULT_HEADERS_FACTORY, (String[])new String[0]), new ResultHandle[0]);
        }
        ResultHandle restClientFilter = constructor.newInstance(MethodDescriptor.ofConstructor(RestClientReactiveRequestFilter.class, (Class[])new Class[]{ClientHeadersFactory.class}), new ResultHandle[]{clientHeadersFactory});
        constructor.assign(webTargetBase, constructor.invokeInterfaceMethod(MethodDescriptor.ofMethod(Configurable.class, (String)"register", Configurable.class, (Class[])new Class[]{Object.class}), (ResultHandle)webTargetBase, new ResultHandle[]{restClientFilter}));
    }

    public void forMethod(ClassCreator classCreator, MethodCreator constructor, MethodCreator methodCreator, ClassInfo interfaceClass, MethodInfo method, AssignableResultHandle invocationBuilder, IndexView index, BuildProducer<GeneratedClassBuildItem> generatedClasses, int methodIndex) {
        ResultHandle headerFiller;
        ResultHandle interfaceClassHandle = constructor.loadClass(interfaceClass.toString());
        ResultHandle parameterArray = constructor.newArray(Class.class, method.parameters().size());
        for (int i = 0; i < method.parameters().size(); ++i) {
            String parameterClass = ((Type)method.parameters().get(i)).name().toString();
            constructor.writeArrayValue(parameterArray, i, constructor.loadClass(parameterClass));
        }
        ResultHandle javaMethodHandle = constructor.invokeVirtualMethod(MethodDescriptor.ofMethod(Class.class, (String)"getMethod", Method.class, (Class[])new Class[]{String.class, Class[].class}), interfaceClassHandle, new ResultHandle[]{constructor.load(method.name()), parameterArray});
        FieldDescriptor javaMethodField = FieldDescriptor.of((String)classCreator.getClassName(), (String)("javaMethod" + methodIndex), Method.class);
        classCreator.getFieldCreator(javaMethodField).setModifiers(18);
        constructor.writeInstanceField(javaMethodField, constructor.getThis(), javaMethodHandle);
        HashMap<String, AnnotationInstance> headerFillersByName = new HashMap<String, AnnotationInstance>();
        AnnotationInstance classLevelHeader = interfaceClass.classAnnotation(DotNames.CLIENT_HEADER_PARAM);
        if (classLevelHeader != null) {
            headerFillersByName.put(classLevelHeader.value("name").asString(), classLevelHeader);
        }
        this.putAllHeaderAnnotations(headerFillersByName, this.extractAnnotations(interfaceClass.classAnnotation(DotNames.CLIENT_HEADER_PARAMS)));
        HashMap<String, AnnotationInstance> methodLevelHeadersByName = new HashMap<String, AnnotationInstance>();
        AnnotationInstance methodLevelHeader = method.annotation(DotNames.CLIENT_HEADER_PARAM);
        if (methodLevelHeader != null) {
            methodLevelHeadersByName.put(methodLevelHeader.value("name").asString(), methodLevelHeader);
        }
        this.putAllHeaderAnnotations(methodLevelHeadersByName, this.extractAnnotations(method.annotation(DotNames.CLIENT_HEADER_PARAMS)));
        headerFillersByName.putAll(methodLevelHeadersByName);
        FieldDescriptor headerFillerField = FieldDescriptor.of((String)classCreator.getClassName(), (String)("headerFiller" + methodIndex), HeaderFiller.class);
        classCreator.getFieldCreator(headerFillerField).setModifiers(18);
        if (!headerFillersByName.isEmpty()) {
            String fillerClassName = interfaceClass.toString() + "$$" + method.name() + "$$" + methodIndex;
            GeneratedClassGizmoAdaptor classOutput = new GeneratedClassGizmoAdaptor(generatedClasses, true);
            try (ClassCreator headerFillerClass = ClassCreator.builder().className(fillerClassName).interfaces(new Class[]{HeaderFiller.class}).classOutput((ClassOutput)classOutput).build();){
                FieldCreator logField = headerFillerClass.getFieldCreator("log", Logger.class);
                logField.setModifiers(26);
                MethodCreator staticConstructor = headerFillerClass.getMethodCreator("<clinit>", Void.TYPE, new Class[0]);
                staticConstructor.setModifiers(8);
                ResultHandle log = staticConstructor.invokeStaticMethod(MethodDescriptor.ofMethod(Logger.class, (String)"getLogger", Logger.class, (Class[])new Class[]{String.class}), new ResultHandle[]{staticConstructor.load(fillerClassName)});
                staticConstructor.writeStaticField(logField.getFieldDescriptor(), log);
                staticConstructor.returnValue(null);
                MethodCreator fillHeaders = headerFillerClass.getMethodCreator(MethodDescriptor.ofMethod(HeaderFiller.class, (String)"addHeaders", Void.TYPE, (Class[])new Class[]{MultivaluedMap.class}));
                for (Map.Entry headerEntry : headerFillersByName.entrySet()) {
                    this.addHeaderParam(interfaceClass, method, fillHeaders, (AnnotationInstance)headerEntry.getValue(), generatedClasses, fillerClassName, index);
                }
                fillHeaders.returnValue(null);
                headerFiller = constructor.newInstance(MethodDescriptor.ofConstructor((String)fillerClassName, (String[])new String[0]), new ResultHandle[0]);
            }
        } else {
            headerFiller = constructor.readStaticField(FieldDescriptor.of(NoOpHeaderFiller.class, (String)"INSTANCE", NoOpHeaderFiller.class));
        }
        constructor.writeInstanceField(headerFillerField, constructor.getThis(), headerFiller);
        ResultHandle javaMethod = methodCreator.readInstanceField(javaMethodField, methodCreator.getThis());
        ResultHandle javaMethodAsObject = methodCreator.checkCast(javaMethod, Object.class);
        methodCreator.assign(invocationBuilder, methodCreator.invokeInterfaceMethod(INVOCATION_BUILDER_PROPERTY_METHOD, (ResultHandle)invocationBuilder, new ResultHandle[]{methodCreator.load(INVOKED_METHOD), javaMethodAsObject}));
        ResultHandle headerFillerAsObject = methodCreator.checkCast(methodCreator.readInstanceField(headerFillerField, methodCreator.getThis()), Object.class);
        methodCreator.assign(invocationBuilder, methodCreator.invokeInterfaceMethod(INVOCATION_BUILDER_PROPERTY_METHOD, (ResultHandle)invocationBuilder, new ResultHandle[]{methodCreator.load(HeaderFiller.class.getName()), headerFillerAsObject}));
    }

    private void putAllHeaderAnnotations(Map<String, AnnotationInstance> headerMap, AnnotationInstance[] annotations) {
        for (AnnotationInstance annotation : annotations) {
            String headerName = annotation.value("name").asString();
            if (headerMap.put(headerName, annotation) == null) continue;
            throw new RestClientDefinitionException("Duplicate ClientHeaderParam annotation for header: " + headerName + " on " + annotation.target());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addHeaderParam(ClassInfo declaringClass, MethodInfo declaringMethod, MethodCreator fillHeadersCreator, AnnotationInstance annotation, BuildProducer<GeneratedClassBuildItem> generatedClasses, String fillerClassName, IndexView index) {
        String headerName = annotation.value("name").asString();
        String[] values = annotation.value().asStringArray();
        if (values.length == 0) {
            log.warnv("Ignoring ClientHeaderParam that specifies an empty array of header values for header {} on {}", (Object)annotation.value("name").asString(), (Object)annotation.target());
            return;
        }
        ResultHandle headerMap = fillHeadersCreator.getMethodParam(0);
        BytecodeCreator fillHeaders = fillHeadersCreator.ifFalse(fillHeadersCreator.invokeInterfaceMethod(MAP_CONTAINS_KEY_METHOD, headerMap, new ResultHandle[]{fillHeadersCreator.load(headerName)})).trueBranch();
        if (values.length > 1 || !values[0].startsWith("{") || !values[0].endsWith("}")) {
            ResultHandle headerList = fillHeaders.newInstance(MethodDescriptor.ofConstructor(ArrayList.class, (Class[])new Class[0]), new ResultHandle[0]);
            for (String value : values) {
                fillHeaders.invokeInterfaceMethod(LIST_ADD_METHOD, headerList, new ResultHandle[]{fillHeaders.load(value)});
            }
            fillHeaders.invokeInterfaceMethod(MAP_PUT_METHOD, headerMap, new ResultHandle[]{fillHeaders.load(headerName), headerList});
            return;
        } else {
            ResultHandle headerList;
            ResultHandle headerValue;
            boolean required = annotation.valueWithDefault(index, "required").asBoolean();
            BytecodeCreator fillHeader = fillHeaders;
            TryBlock tryBlock = null;
            if (!required) {
                tryBlock = fillHeaders.tryBlock();
                fillHeader = tryBlock;
            }
            String methodName = values[0].substring(1, values[0].length() - 1);
            MethodInfo headerFillingMethod = null;
            if (methodName.contains(".")) {
                int endOfClassName = methodName.lastIndexOf(46);
                String className = methodName.substring(0, endOfClassName);
                String staticMethodName = methodName.substring(endOfClassName + 1);
                ClassInfo clazz = index.getClassByName(DotName.createSimple((String)className));
                if (clazz == null) {
                    throw new RestClientDefinitionException("Class " + className + " used in ClientHeaderParam on " + declaringClass + " not found");
                }
                headerFillingMethod = this.findMethod(clazz, declaringClass, staticMethodName);
                if (headerFillingMethod.parameters().size() == 0) {
                    headerValue = fillHeader.invokeStaticMethod(headerFillingMethod, new ResultHandle[0]);
                } else {
                    if (headerFillingMethod.parameters().size() != 1 || !RestClientReactiveEnricher.isString((Type)headerFillingMethod.parameters().get(0))) throw new RestClientDefinitionException("ClientHeaderParam method " + declaringClass.toString() + "#" + staticMethodName + " has too many parameters, at most one parameter, header name, expected");
                    headerValue = fillHeader.invokeStaticMethod(headerFillingMethod, new ResultHandle[]{fillHeader.load(headerName)});
                }
            } else {
                String mockName = this.mockInterface(declaringClass, generatedClasses, index);
                ResultHandle interfaceMock = fillHeader.newInstance(MethodDescriptor.ofConstructor((String)mockName, (String[])new String[0]), new ResultHandle[0]);
                headerFillingMethod = this.findMethod(declaringClass, declaringClass, methodName);
                if (headerFillingMethod == null) {
                    throw new RestClientDefinitionException("ClientHeaderParam method " + methodName + " not found on " + declaringClass);
                }
                if (headerFillingMethod.parameters().size() == 0) {
                    headerValue = fillHeader.invokeInterfaceMethod(headerFillingMethod, interfaceMock, new ResultHandle[0]);
                } else {
                    if (headerFillingMethod.parameters().size() != 1 || !RestClientReactiveEnricher.isString((Type)headerFillingMethod.parameters().get(0))) throw new RestClientDefinitionException("ClientHeaderParam method " + declaringClass.toString() + "#" + methodName + " has too many parameters, at most one parameter, header name, expected");
                    headerValue = fillHeader.invokeInterfaceMethod(headerFillingMethod, interfaceMock, new ResultHandle[]{fillHeader.load(headerName)});
                }
            }
            Type returnType = headerFillingMethod.returnType();
            if (returnType.kind() == Type.Kind.ARRAY && returnType.asArrayType().component().name().equals((Object)io.quarkus.arc.processor.DotNames.STRING)) {
                headerList = fillHeader.invokeStaticMethod(MethodDescriptor.ofMethod(Arrays.class, (String)"asList", List.class, (Class[])new Class[]{Object[].class}), new ResultHandle[]{headerValue});
            } else {
                if (returnType.kind() != Type.Kind.CLASS || !returnType.name().equals((Object)io.quarkus.arc.processor.DotNames.STRING)) throw new RestClientDefinitionException("Method " + declaringClass.toString() + "#" + methodName + " has an unsupported return type for ClientHeaderParam. Only String and String[] return types are supported");
                headerList = fillHeader.newInstance(MethodDescriptor.ofConstructor(ArrayList.class, (Class[])new Class[0]), new ResultHandle[0]);
                fillHeader.invokeInterfaceMethod(LIST_ADD_METHOD, headerList, new ResultHandle[]{headerValue});
            }
            fillHeader.invokeInterfaceMethod(MAP_PUT_METHOD, headerMap, new ResultHandle[]{fillHeader.load(headerName), headerList});
            if (required) return;
            CatchBlockCreator catchBlock = tryBlock.addCatch(Exception.class);
            ResultHandle log = catchBlock.readStaticField(FieldDescriptor.of((String)fillerClassName, (String)"log", Logger.class));
            String errorMessage = String.format("Invoking header generation method '%s' for header '%s' on method '%s#%s' failed", methodName, headerName, declaringClass.name(), declaringMethod.name());
            catchBlock.invokeVirtualMethod(MethodDescriptor.ofMethod(Logger.class, (String)"warn", Void.TYPE, (Class[])new Class[]{Object.class, Throwable.class}), log, new ResultHandle[]{catchBlock.load(errorMessage), catchBlock.getCaughtException()});
        }
    }

    private MethodInfo findMethod(ClassInfo declaringClass, ClassInfo restInterface, String methodName) {
        MethodInfo headerFillingMethod = null;
        for (MethodInfo method : declaringClass.methods()) {
            if (!method.name().equals(methodName)) continue;
            if (headerFillingMethod != null) {
                throw new RestClientDefinitionException("Ambiguous ClientHeaderParam definition, more than one method of name " + methodName + " found on " + declaringClass + ". Problematic interface: " + restInterface);
            }
            headerFillingMethod = method;
        }
        return headerFillingMethod;
    }

    private static boolean isString(Type type) {
        return type.kind() == Type.Kind.CLASS && type.name().toString().equals(String.class.getName());
    }

    private String mockInterface(ClassInfo declaringClass, BuildProducer<GeneratedClassBuildItem> generatedClass, IndexView index) {
        return this.interfaceMocks.computeIfAbsent(declaringClass, classInfo -> {
            String mockName = declaringClass.toString() + HashUtil.sha1((String)declaringClass.toString());
            GeneratedClassGizmoAdaptor classOutput = new GeneratedClassGizmoAdaptor(generatedClass, true);
            List interfaceNames = declaringClass.interfaceNames();
            HashSet methods = new HashSet();
            for (DotName interfaceName : interfaceNames) {
                ClassInfo interfaceClass = index.getClassByName(interfaceName);
                methods.addAll(interfaceClass.methods());
            }
            methods.addAll(declaringClass.methods());
            try (ClassCreator classCreator = ClassCreator.builder().className(mockName).interfaces(new String[]{declaringClass.toString()}).classOutput((ClassOutput)classOutput).build();){
                for (MethodInfo method : methods) {
                    if (!Modifier.isAbstract(method.flags())) continue;
                    MethodCreator methodCreator = classCreator.getMethodCreator(MethodDescriptor.of((MethodInfo)method));
                    methodCreator.returnValue(methodCreator.loadNull());
                }
            }
            return mockName;
        });
    }

    private AnnotationInstance[] extractAnnotations(AnnotationInstance groupAnnotation) {
        AnnotationValue annotationValue;
        if (groupAnnotation != null && (annotationValue = groupAnnotation.value()) != null) {
            return annotationValue.asNestedArray();
        }
        return EMPTY_ANNOTATION_INSTANCES;
    }

    private void addProvider(MethodCreator ctor, AssignableResultHandle target, IndexView index, AnnotationInstance registerProvider) {
        ResultHandle provider = ctor.newInstance(MethodDescriptor.ofConstructor((String)registerProvider.value().asString(), (String[])new String[0]), new ResultHandle[0]);
        ResultHandle alteredTarget = ctor.invokeInterfaceMethod(MethodDescriptor.ofMethod(Configurable.class, (String)"register", Configurable.class, (Class[])new Class[]{Object.class, Integer.TYPE}), (ResultHandle)target, new ResultHandle[]{provider, ctor.load(registerProvider.valueWithDefault(index, "priority").asInt())});
        ctor.assign(target, alteredTarget);
    }
}

