/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.rest.client.reactive.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanGizmoAdaptor;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.arc.processor.ScopeInfo;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.Capability;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.ExtensionSslNativeSupportBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.jaxrs.client.reactive.deployment.JaxrsClientReactiveEnricher;
import io.quarkus.jaxrs.client.reactive.deployment.JaxrsClientReactiveEnricherBuildItem;
import io.quarkus.jaxrs.client.reactive.deployment.RestClientDefaultConsumesBuildItem;
import io.quarkus.jaxrs.client.reactive.deployment.RestClientDefaultProducesBuildItem;
import io.quarkus.rest.client.reactive.deployment.DotNames;
import io.quarkus.rest.client.reactive.deployment.RestClientReactiveEnricher;
import io.quarkus.rest.client.reactive.runtime.HeaderCapturingServerFilter;
import io.quarkus.rest.client.reactive.runtime.HeaderContainer;
import io.quarkus.rest.client.reactive.runtime.RestClientCDIDelegateBuilder;
import io.quarkus.rest.client.reactive.runtime.RestClientReactiveConfig;
import io.quarkus.rest.client.reactive.runtime.RestClientRecorder;
import io.quarkus.resteasy.reactive.spi.ContainerRequestFilterBuildItem;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.inject.Typed;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.rest.client.inject.RegisterRestClient;
import org.eclipse.microprofile.rest.client.inject.RestClient;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.CompositeIndex;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.logging.Logger;
import org.jboss.resteasy.reactive.common.processor.ResteasyReactiveDotNames;
import org.jboss.resteasy.reactive.common.processor.scanning.ResteasyReactiveScanner;
import org.objectweb.asm.Type;

class RestClientReactiveProcessor {
    private static final Logger log = Logger.getLogger(RestClientReactiveProcessor.class);
    private static final DotName REGISTER_REST_CLIENT = DotName.createSimple((String)RegisterRestClient.class.getName());
    private static final DotName SESSION_SCOPED = DotName.createSimple((String)SessionScoped.class.getName());
    private static final String DELEGATE = "delegate";
    private static final String CREATE_DELEGATE = "createDelegate";

    RestClientReactiveProcessor() {
    }

    @BuildStep
    void feature(BuildProducer<FeatureBuildItem> features) {
        features.produce((BuildItem)new FeatureBuildItem(Feature.REST_CLIENT_REACTIVE));
    }

    @BuildStep
    ExtensionSslNativeSupportBuildItem activateSslNativeSupport() {
        return new ExtensionSslNativeSupportBuildItem(Feature.REST_CLIENT_REACTIVE);
    }

    @BuildStep
    void setUpDefaultMediaType(BuildProducer<RestClientDefaultConsumesBuildItem> consumes, BuildProducer<RestClientDefaultProducesBuildItem> produces) {
        consumes.produce((BuildItem)new RestClientDefaultConsumesBuildItem("application/json", 10));
        produces.produce((BuildItem)new RestClientDefaultProducesBuildItem("application/json", 10));
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void setupAdditionalBeans(BuildProducer<AdditionalBeanBuildItem> additionalBeans, RestClientRecorder restClientRecorder) {
        restClientRecorder.setRestClientBuilderResolver();
        additionalBeans.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{RestClient.class}));
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(HeaderContainer.class));
    }

    @BuildStep
    void setupRequestCollectingFilter(BuildProducer<ContainerRequestFilterBuildItem> filters) {
        filters.produce((BuildItem)new ContainerRequestFilterBuildItem(HeaderCapturingServerFilter.class.getName()));
    }

    @BuildStep
    void addMpClientEnricher(BuildProducer<JaxrsClientReactiveEnricherBuildItem> enrichers) {
        enrichers.produce((BuildItem)new JaxrsClientReactiveEnricherBuildItem((JaxrsClientReactiveEnricher)new RestClientReactiveEnricher()));
    }

    private void searchForJaxRsMethods(List<MethodInfo> listOfKnownMethods, ClassInfo startingInterface, CompositeIndex index) {
        for (MethodInfo method : startingInterface.methods()) {
            if (!this.isRestMethod(method)) continue;
            listOfKnownMethods.add(method);
        }
        List otherImplementedInterfaces = startingInterface.interfaceNames();
        for (DotName otherInterface : otherImplementedInterfaces) {
            ClassInfo superInterface = index.getClassByName(otherInterface);
            if (superInterface == null) continue;
            this.searchForJaxRsMethods(listOfKnownMethods, superInterface, index);
        }
    }

    @BuildStep
    void registerHeaderFactoryBeans(CombinedIndexBuildItem index, BuildProducer<AdditionalBeanBuildItem> additionalBeans) {
        Collection annotations = index.getIndex().getAnnotations(DotNames.REGISTER_CLIENT_HEADERS);
        for (AnnotationInstance registerClientHeaders : annotations) {
            org.jboss.jandex.Type clientHeaderFactoryType;
            String factoryTypeName;
            AnnotationValue value = registerClientHeaders.value();
            if (value == null || RestClientReactiveEnricher.DEFAULT_HEADERS_FACTORY.equals(factoryTypeName = (clientHeaderFactoryType = value.asClass()).name().toString())) continue;
            additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf((String)factoryTypeName));
        }
    }

    @BuildStep
    void addRestClientBeans(Capabilities capabilities, CombinedIndexBuildItem combinedIndexBuildItem, BuildProducer<GeneratedBeanBuildItem> generatedBeans, RestClientReactiveConfig clientConfig) {
        CompositeIndex index = CompositeIndex.create((IndexView[])new IndexView[]{combinedIndexBuildItem.getIndex()});
        HashSet registerRestClientAnnos = new HashSet(index.getAnnotations(REGISTER_REST_CLIENT));
        for (AnnotationInstance registerRestClient : registerRestClientAnnos) {
            ClassInfo jaxrsInterface = registerRestClient.target().asClass();
            if (!Modifier.isAbstract(jaxrsInterface.flags())) continue;
            ArrayList<MethodInfo> restMethods = new ArrayList<MethodInfo>();
            this.searchForJaxRsMethods(restMethods, jaxrsInterface, index);
            if (restMethods.isEmpty()) continue;
            String wrapperClassName = jaxrsInterface.name().toString() + "$$CDIWrapper";
            ClassCreator classCreator = ClassCreator.builder().className(wrapperClassName).classOutput((ClassOutput)new GeneratedBeanGizmoAdaptor(generatedBeans)).interfaces(new String[]{jaxrsInterface.name().toString()}).build();
            Throwable throwable = null;
            try {
                String configPrefix = this.computeConfigPrefix(jaxrsInterface.name(), registerRestClient);
                ScopeInfo scope = this.computeDefaultScope(capabilities, ConfigProvider.getConfig(), jaxrsInterface, configPrefix, clientConfig);
                classCreator.addAnnotation(scope.getDotName().toString());
                classCreator.addAnnotation(RestClient.class);
                Type asmType = Type.getObjectType((String)jaxrsInterface.name().toString().replace('.', '/'));
                classCreator.addAnnotation(Typed.class.getName(), RetentionPolicy.RUNTIME).addValue("value", (Object)new Type[]{asmType});
                FieldDescriptor delegateField = FieldDescriptor.of((String)classCreator.getClassName(), (String)DELEGATE, (String)jaxrsInterface.name().toString());
                classCreator.getFieldCreator(delegateField).setModifiers(18);
                MethodCreator constructor = classCreator.getMethodCreator(MethodDescriptor.ofConstructor((String)classCreator.getClassName(), (String[])new String[0]));
                constructor.invokeSpecialMethod(MethodDescriptor.ofConstructor(Object.class, (Class[])new Class[0]), constructor.getThis(), new ResultHandle[0]);
                ResultHandle interfaceHandle = constructor.loadClass(jaxrsInterface.toString());
                AnnotationValue baseUri = registerRestClient.value("baseUri");
                ResultHandle baseUriHandle = constructor.load(baseUri != null ? baseUri.asString() : "");
                ResultHandle configPrefixHandle = constructor.load(configPrefix);
                MethodDescriptor createDelegate = MethodDescriptor.ofMethod(RestClientCDIDelegateBuilder.class, (String)CREATE_DELEGATE, Object.class, (Class[])new Class[]{Class.class, String.class, String.class});
                constructor.writeInstanceField(delegateField, constructor.getThis(), constructor.invokeStaticMethod(createDelegate, new ResultHandle[]{interfaceHandle, baseUriHandle, configPrefixHandle}));
                constructor.returnValue(null);
                for (MethodInfo method : restMethods) {
                    ResultHandle result;
                    MethodCreator methodCreator = classCreator.getMethodCreator(MethodDescriptor.of((MethodInfo)method));
                    for (AnnotationInstance annotation : method.annotations()) {
                        if (annotation.target().kind() != AnnotationTarget.Kind.METHOD || ResteasyReactiveScanner.BUILTIN_HTTP_ANNOTATIONS_TO_METHOD.containsKey(annotation.name()) || ResteasyReactiveDotNames.PATH.equals((Object)annotation.name())) continue;
                        AnnotationValue value = annotation.value();
                        if (value != null && value.kind() == AnnotationValue.Kind.ARRAY && value.componentKind() == AnnotationValue.Kind.NESTED) {
                            for (AnnotationInstance annotationInstance : value.asNestedArray()) {
                                methodCreator.addAnnotation(annotationInstance);
                            }
                            continue;
                        }
                        methodCreator.addAnnotation(annotation);
                    }
                    ResultHandle delegate = methodCreator.readInstanceField(delegateField, methodCreator.getThis());
                    int parameterCount = method.parameters().size();
                    if (parameterCount == 0) {
                        result = methodCreator.invokeInterfaceMethod(method, delegate, new ResultHandle[0]);
                    } else {
                        ResultHandle[] params = new ResultHandle[parameterCount];
                        for (int i = 0; i < parameterCount; ++i) {
                            params[i] = methodCreator.getMethodParam(i);
                        }
                        result = methodCreator.invokeInterfaceMethod(method, delegate, params);
                    }
                    methodCreator.returnValue(result);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (classCreator == null) continue;
                if (throwable != null) {
                    try {
                        classCreator.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                classCreator.close();
            }
        }
    }

    private boolean isRestMethod(MethodInfo method) {
        if (!Modifier.isAbstract(method.flags())) {
            return false;
        }
        for (AnnotationInstance annotation : method.annotations()) {
            if (annotation.target().kind() != AnnotationTarget.Kind.METHOD || !ResteasyReactiveScanner.BUILTIN_HTTP_ANNOTATIONS_TO_METHOD.containsKey(annotation.name())) continue;
            return true;
        }
        return false;
    }

    private String computeConfigPrefix(DotName interfaceName, AnnotationInstance registerRestClientAnnotation) {
        AnnotationValue configKeyValue = registerRestClientAnnotation.value("configKey");
        return configKeyValue != null ? configKeyValue.asString() : interfaceName.toString();
    }

    private ScopeInfo computeDefaultScope(Capabilities capabilities, Config config, ClassInfo restClientInterface, String configPrefix, RestClientReactiveConfig mpClientConfig) {
        BuiltinScope globalDefaultScope;
        ScopeInfo scopeToUse;
        block7: {
            block6: {
                scopeToUse = null;
                Optional scopeConfig = config.getOptionalValue(String.format("%s/mp-rest/scope", configPrefix), String.class);
                globalDefaultScope = BuiltinScope.from((DotName)DotName.createSimple((String)mpClientConfig.scope));
                if (globalDefaultScope == null) {
                    log.warnv("Unable to map the global rest client scope: '{}' to a scope. Using @ApplicationScoped", (Object)mpClientConfig.scope);
                    globalDefaultScope = BuiltinScope.APPLICATION;
                }
                if (!scopeConfig.isPresent()) break block6;
                DotName scope = DotName.createSimple((String)((String)scopeConfig.get()));
                BuiltinScope builtinScope = BuiltinScope.from((DotName)scope);
                if (builtinScope != null) {
                    scopeToUse = builtinScope.getInfo();
                } else if (capabilities.isPresent(Capability.SERVLET) && scope.equals((Object)SESSION_SCOPED)) {
                    scopeToUse = new ScopeInfo(SESSION_SCOPED, true);
                }
                if (scopeToUse != null) break block7;
                log.warnf("Unsupported default scope {} provided for rest client {}. Defaulting to {}", (Object)scope, (Object)restClientInterface.name(), (Object)globalDefaultScope.getName());
                scopeToUse = BuiltinScope.DEPENDENT.getInfo();
                break block7;
            }
            Set annotations = restClientInterface.annotations().keySet();
            for (DotName annotationName : annotations) {
                BuiltinScope builtinScope = BuiltinScope.from((DotName)annotationName);
                if (builtinScope != null) {
                    scopeToUse = builtinScope.getInfo();
                    break;
                }
                if (!annotationName.equals((Object)SESSION_SCOPED)) continue;
                scopeToUse = new ScopeInfo(SESSION_SCOPED, true);
                break;
            }
        }
        return scopeToUse != null ? scopeToUse : globalDefaultScope.getInfo();
    }
}

