/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.rest.client.reactive.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanGizmoAdaptor;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.arc.processor.MethodDescriptors;
import io.quarkus.arc.processor.ScopeInfo;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.ConfigurationTypeBuildItem;
import io.quarkus.deployment.builditem.ExtensionSslNativeSupportBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.util.AsmUtil;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.jaxrs.client.reactive.deployment.JaxrsClientReactiveEnricher;
import io.quarkus.jaxrs.client.reactive.deployment.JaxrsClientReactiveEnricherBuildItem;
import io.quarkus.jaxrs.client.reactive.deployment.RestClientDefaultConsumesBuildItem;
import io.quarkus.jaxrs.client.reactive.deployment.RestClientDefaultProducesBuildItem;
import io.quarkus.jaxrs.client.reactive.deployment.RestClientDisableSmartDefaultProduces;
import io.quarkus.rest.client.reactive.deployment.DotNames;
import io.quarkus.rest.client.reactive.deployment.MicroProfileRestClientEnricher;
import io.quarkus.rest.client.reactive.runtime.AnnotationRegisteredProviders;
import io.quarkus.rest.client.reactive.runtime.HeaderCapturingServerFilter;
import io.quarkus.rest.client.reactive.runtime.HeaderContainer;
import io.quarkus.rest.client.reactive.runtime.RestClientReactiveCDIWrapperBase;
import io.quarkus.rest.client.reactive.runtime.RestClientReactiveConfig;
import io.quarkus.rest.client.reactive.runtime.RestClientRecorder;
import io.quarkus.restclient.config.RestClientsConfig;
import io.quarkus.restclient.config.deployment.RestClientConfigUtils;
import io.quarkus.resteasy.reactive.spi.ContainerRequestFilterBuildItem;
import io.quarkus.runtime.LaunchMode;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.inject.Typed;
import javax.inject.Singleton;
import javax.ws.rs.RuntimeType;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.rest.client.ext.QueryParamStyle;
import org.eclipse.microprofile.rest.client.inject.RegisterRestClient;
import org.eclipse.microprofile.rest.client.inject.RestClient;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.CompositeIndex;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.logging.Logger;
import org.jboss.resteasy.reactive.common.processor.ResteasyReactiveDotNames;
import org.jboss.resteasy.reactive.common.processor.scanning.ResteasyReactiveScanner;
import org.objectweb.asm.Type;

class RestClientReactiveProcessor {
    private static final Logger log = Logger.getLogger(RestClientReactiveProcessor.class);
    private static final DotName REGISTER_REST_CLIENT = DotName.createSimple((String)RegisterRestClient.class.getName());
    private static final DotName SESSION_SCOPED = DotName.createSimple((String)SessionScoped.class.getName());
    private static final String DISABLE_SMART_PRODUCES_QUARKUS = "quarkus.rest-client.disable-smart-produces";

    RestClientReactiveProcessor() {
    }

    @BuildStep
    void announceFeature(BuildProducer<FeatureBuildItem> features) {
        features.produce((BuildItem)new FeatureBuildItem(Feature.REST_CLIENT_REACTIVE));
    }

    @BuildStep
    void registerQueryParamStyleForConfig(BuildProducer<ConfigurationTypeBuildItem> configurationTypes) {
        configurationTypes.produce((BuildItem)new ConfigurationTypeBuildItem(QueryParamStyle.class));
    }

    @BuildStep
    ExtensionSslNativeSupportBuildItem activateSslNativeSupport() {
        return new ExtensionSslNativeSupportBuildItem(Feature.REST_CLIENT_REACTIVE);
    }

    @BuildStep
    void setUpDefaultMediaType(BuildProducer<RestClientDefaultConsumesBuildItem> consumes, BuildProducer<RestClientDefaultProducesBuildItem> produces, BuildProducer<RestClientDisableSmartDefaultProduces> disableSmartProduces, RestClientReactiveConfig config) {
        consumes.produce((BuildItem)new RestClientDefaultConsumesBuildItem("application/json", 10));
        produces.produce((BuildItem)new RestClientDefaultProducesBuildItem("application/json", 10));
        Config mpConfig = ConfigProvider.getConfig();
        Optional disableSmartProducesConfig = mpConfig.getOptionalValue(DISABLE_SMART_PRODUCES_QUARKUS, Boolean.class);
        if (config.disableSmartProduces || disableSmartProducesConfig.orElse(false).booleanValue()) {
            disableSmartProduces.produce((BuildItem)new RestClientDisableSmartDefaultProduces());
        }
    }

    @BuildStep
    void registerRestClientListenerForTracing(Capabilities capabilities, BuildProducer<NativeImageResourceBuildItem> resource, BuildProducer<ReflectiveClassBuildItem> reflectiveClass) {
        if (capabilities.isPresent("io.quarkus.smallrye.opentracing")) {
            resource.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"META-INF/services/org.eclipse.microprofile.rest.client.spi.RestClientListener"}));
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, false, false, new String[]{"io.smallrye.opentracing.SmallRyeRestClientListener"}));
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void setupAdditionalBeans(BuildProducer<AdditionalBeanBuildItem> additionalBeans, RestClientRecorder restClientRecorder) {
        restClientRecorder.setRestClientBuilderResolver();
        additionalBeans.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{RestClient.class}));
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(HeaderContainer.class));
    }

    @BuildStep
    UnremovableBeanBuildItem makeConfigUnremovable() {
        return UnremovableBeanBuildItem.beanTypes((Class[])new Class[]{RestClientsConfig.class});
    }

    @BuildStep
    void setupRequestCollectingFilter(BuildProducer<ContainerRequestFilterBuildItem> filters) {
        filters.produce((BuildItem)new ContainerRequestFilterBuildItem(HeaderCapturingServerFilter.class.getName()));
    }

    @BuildStep
    void addMpClientEnricher(BuildProducer<JaxrsClientReactiveEnricherBuildItem> enrichers) {
        enrichers.produce((BuildItem)new JaxrsClientReactiveEnricherBuildItem((JaxrsClientReactiveEnricher)new MicroProfileRestClientEnricher()));
    }

    private void searchForJaxRsMethods(List<MethodInfo> listOfKnownMethods, ClassInfo startingInterface, CompositeIndex index) {
        for (MethodInfo method : startingInterface.methods()) {
            if (!this.isRestMethod(method)) continue;
            listOfKnownMethods.add(method);
        }
        List otherImplementedInterfaces = startingInterface.interfaceNames();
        for (DotName otherInterface : otherImplementedInterfaces) {
            ClassInfo superInterface = index.getClassByName(otherInterface);
            if (superInterface == null) continue;
            this.searchForJaxRsMethods(listOfKnownMethods, superInterface, index);
        }
    }

    @BuildStep
    void registerHeaderFactoryBeans(CombinedIndexBuildItem index, BuildProducer<AdditionalBeanBuildItem> additionalBeans) {
        Collection annotations = index.getIndex().getAnnotations(DotNames.REGISTER_CLIENT_HEADERS);
        for (AnnotationInstance registerClientHeaders : annotations) {
            org.jboss.jandex.Type clientHeaderFactoryType;
            String factoryTypeName;
            AnnotationValue value = registerClientHeaders.value();
            if (value == null || MicroProfileRestClientEnricher.DEFAULT_HEADERS_FACTORY.equals(factoryTypeName = (clientHeaderFactoryType = value.asClass()).name().toString())) continue;
            additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf((String)factoryTypeName));
        }
    }

    @BuildStep
    void registerProvidersFromAnnotations(CombinedIndexBuildItem indexBuildItem, BuildProducer<GeneratedBeanBuildItem> generatedBeans, BuildProducer<UnremovableBeanBuildItem> unremovableBeans, RestClientReactiveConfig clientConfig) {
        String targetClass;
        String annotationRegisteredProvidersImpl = AnnotationRegisteredProviders.class.getName() + "Implementation";
        IndexView index = indexBuildItem.getIndex();
        HashMap<String, List> annotationsByClassName = new HashMap<String, List>();
        for (AnnotationInstance annotation : index.getAnnotations(DotNames.REGISTER_PROVIDER)) {
            targetClass = annotation.target().asClass().name().toString();
            annotationsByClassName.computeIfAbsent(targetClass, key -> new ArrayList()).add(annotation);
        }
        for (AnnotationInstance annotation : index.getAnnotations(DotNames.REGISTER_PROVIDERS)) {
            targetClass = annotation.target().asClass().name().toString();
            annotationsByClassName.computeIfAbsent(targetClass, key -> new ArrayList()).addAll(Arrays.asList(annotation.value().asNestedArray()));
        }
        try (ClassCreator classCreator = ClassCreator.builder().className(annotationRegisteredProvidersImpl).classOutput((ClassOutput)new GeneratedBeanGizmoAdaptor(generatedBeans)).superClass(AnnotationRegisteredProviders.class).build();){
            classCreator.addAnnotation(Singleton.class.getName());
            MethodCreator constructor = classCreator.getMethodCreator(MethodDescriptor.ofConstructor((String)annotationRegisteredProvidersImpl, (String[])new String[0]));
            constructor.invokeSpecialMethod(MethodDescriptor.ofConstructor(AnnotationRegisteredProviders.class, (Class[])new Class[0]), constructor.getThis(), new ResultHandle[0]);
            if (clientConfig.providerAutodiscovery) {
                for (AnnotationInstance instance : index.getAnnotations(ResteasyReactiveDotNames.PROVIDER)) {
                    ClassInfo providerClass = instance.target().asClass();
                    AnnotationInstance constrainedToInstance = providerClass.classAnnotation(ResteasyReactiveDotNames.CONSTRAINED_TO);
                    if (constrainedToInstance != null && RuntimeType.valueOf((String)constrainedToInstance.value().asEnum()) == RuntimeType.SERVER || providerClass.interfaceNames().contains(ResteasyReactiveDotNames.FEATURE)) continue;
                    int priority = this.getAnnotatedPriority(index, providerClass.name().toString(), 5000);
                    constructor.invokeVirtualMethod(MethodDescriptor.ofMethod(AnnotationRegisteredProviders.class, (String)"addGlobalProvider", Void.TYPE, (Class[])new Class[]{Class.class, Integer.TYPE}), constructor.getThis(), new ResultHandle[]{constructor.loadClass(providerClass.name().toString()), constructor.load(priority)});
                }
            }
            for (Map.Entry annotationsForClass : annotationsByClassName.entrySet()) {
                ResultHandle map = constructor.newInstance(MethodDescriptor.ofConstructor(HashMap.class, (Class[])new Class[0]), new ResultHandle[0]);
                for (AnnotationInstance value : (List)annotationsForClass.getValue()) {
                    String className = value.value().asString();
                    AnnotationValue priorityAnnotationValue = value.value("priority");
                    int priority = priorityAnnotationValue == null ? this.getAnnotatedPriority(index, className, 5000) : priorityAnnotationValue.asInt();
                    constructor.invokeInterfaceMethod(MethodDescriptors.MAP_PUT, map, new ResultHandle[]{constructor.loadClass(className), constructor.load(priority)});
                }
                constructor.invokeVirtualMethod(MethodDescriptor.ofMethod(AnnotationRegisteredProviders.class, (String)"addProviders", Void.TYPE, (Class[])new Class[]{String.class, Map.class}), constructor.getThis(), new ResultHandle[]{constructor.load((String)annotationsForClass.getKey()), map});
            }
            constructor.returnValue(null);
        }
        unremovableBeans.produce((BuildItem)UnremovableBeanBuildItem.beanClassNames((String[])new String[]{annotationRegisteredProvidersImpl}));
    }

    private int getAnnotatedPriority(IndexView index, String className, int defaultPriority) {
        ClassInfo providerClass = index.getClassByName(DotName.createSimple((String)className));
        int priority = defaultPriority;
        if (providerClass == null) {
            log.warnv("Unindexed provider class {0}. The priority of the provider will be set to {1}. ", (Object)className, (Object)defaultPriority);
        } else {
            AnnotationInstance priorityAnnoOnProvider = providerClass.classAnnotation(ResteasyReactiveDotNames.PRIORITY);
            if (priorityAnnoOnProvider != null) {
                priority = priorityAnnoOnProvider.value().asInt();
            }
        }
        return priority;
    }

    @BuildStep
    AdditionalBeanBuildItem registerProviderBeans(CombinedIndexBuildItem combinedIndex) {
        IndexView index = combinedIndex.getIndex();
        ArrayList<AnnotationInstance> allInstances = new ArrayList<AnnotationInstance>(index.getAnnotations(DotNames.REGISTER_PROVIDER));
        for (AnnotationInstance annotation : index.getAnnotations(DotNames.REGISTER_PROVIDERS)) {
            allInstances.addAll(Arrays.asList(annotation.value().asNestedArray()));
        }
        allInstances.addAll(index.getAnnotations(DotNames.REGISTER_CLIENT_HEADERS));
        AdditionalBeanBuildItem.Builder builder = AdditionalBeanBuildItem.builder().setUnremovable();
        for (AnnotationInstance annotationInstance : allInstances) {
            AnnotationValue value = annotationInstance.value();
            if (value == null) continue;
            builder.addBeanClass(value.asClass().toString());
        }
        return builder.build();
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void addRestClientBeans(Capabilities capabilities, CombinedIndexBuildItem combinedIndexBuildItem, BuildProducer<GeneratedBeanBuildItem> generatedBeans, RestClientReactiveConfig clientConfig, RestClientRecorder recorder) {
        CompositeIndex index = CompositeIndex.create((IndexView[])new IndexView[]{combinedIndexBuildItem.getIndex()});
        HashSet registerRestClientAnnos = new HashSet(index.getAnnotations(REGISTER_REST_CLIENT));
        HashMap configKeys = new HashMap();
        for (AnnotationInstance registerRestClient : registerRestClientAnnos) {
            ClassInfo jaxrsInterface = registerRestClient.target().asClass();
            if (!Modifier.isAbstract(jaxrsInterface.flags())) continue;
            ArrayList<MethodInfo> methodsToImplement = new ArrayList<MethodInfo>();
            this.searchForJaxRsMethods(methodsToImplement, jaxrsInterface, index);
            for (MethodInfo method : jaxrsInterface.methods()) {
                boolean isDefault = !Modifier.isAbstract(method.flags());
                if (!isDefault) continue;
                methodsToImplement.add(method);
            }
            if (methodsToImplement.isEmpty()) continue;
            String wrapperClassName = jaxrsInterface.name().toString() + "$$CDIWrapper";
            ClassCreator classCreator = ClassCreator.builder().className(wrapperClassName).classOutput((ClassOutput)new GeneratedBeanGizmoAdaptor(generatedBeans)).interfaces(new String[]{jaxrsInterface.name().toString()}).superClass(RestClientReactiveCDIWrapperBase.class).build();
            try {
                Optional<String> configKey = this.getConfigKey(registerRestClient);
                configKey.ifPresent(key -> configKeys.put(jaxrsInterface.name().toString(), key));
                ScopeInfo scope = this.computeDefaultScope(capabilities, ConfigProvider.getConfig(), jaxrsInterface, configKey, clientConfig);
                classCreator.addAnnotation(scope.getDotName().toString());
                classCreator.addAnnotation(RestClient.class);
                Type asmType = Type.getObjectType((String)jaxrsInterface.name().toString().replace('.', '/'));
                classCreator.addAnnotation(Typed.class.getName(), RetentionPolicy.RUNTIME).addValue("value", (Object)new Type[]{asmType});
                MethodCreator constructor = classCreator.getMethodCreator(MethodDescriptor.ofConstructor((String)classCreator.getClassName(), (String[])new String[0]));
                AnnotationValue baseUri = registerRestClient.value("baseUri");
                ResultHandle baseUriHandle = constructor.load(baseUri != null ? baseUri.asString() : "");
                constructor.invokeSpecialMethod(MethodDescriptor.ofConstructor(RestClientReactiveCDIWrapperBase.class, (Class[])new Class[]{Class.class, String.class, String.class}), constructor.getThis(), new ResultHandle[]{constructor.loadClass(jaxrsInterface.toString()), baseUriHandle, configKey.isPresent() ? constructor.load(configKey.get()) : constructor.loadNull()});
                constructor.returnValue(null);
                for (MethodInfo method : methodsToImplement) {
                    ResultHandle result;
                    MethodCreator methodCreator = classCreator.getMethodCreator(MethodDescriptor.of((MethodInfo)method));
                    methodCreator.setSignature(AsmUtil.getSignatureIfRequired((MethodInfo)method));
                    for (AnnotationInstance annotation : method.annotations()) {
                        if (annotation.target().kind() != AnnotationTarget.Kind.METHOD || ResteasyReactiveScanner.BUILTIN_HTTP_ANNOTATIONS_TO_METHOD.containsKey(annotation.name()) || ResteasyReactiveDotNames.PATH.equals((Object)annotation.name())) continue;
                        methodCreator.addAnnotation(annotation);
                    }
                    int parameterCount = method.parameters().size();
                    ResultHandle[] params = new ResultHandle[parameterCount];
                    for (int i = 0; i < parameterCount; ++i) {
                        params[i] = methodCreator.getMethodParam(i);
                    }
                    if (Modifier.isAbstract(method.flags())) {
                        ResultHandle delegate = methodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(RestClientReactiveCDIWrapperBase.class, (String)"getDelegate", Object.class, (Class[])new Class[0]), methodCreator.getThis(), new ResultHandle[0]);
                        result = methodCreator.invokeInterfaceMethod(method, delegate, params);
                    } else {
                        result = methodCreator.invokeSpecialInterfaceMethod(method, methodCreator.getThis(), params);
                    }
                    methodCreator.returnValue(result);
                }
            }
            finally {
                if (classCreator == null) continue;
                classCreator.close();
            }
        }
        if (LaunchMode.current() == LaunchMode.DEVELOPMENT) {
            recorder.setConfigKeys(configKeys);
        }
    }

    private boolean isRestMethod(MethodInfo method) {
        if (!Modifier.isAbstract(method.flags())) {
            return false;
        }
        for (AnnotationInstance annotation : method.annotations()) {
            if (annotation.target().kind() == AnnotationTarget.Kind.METHOD && ResteasyReactiveScanner.BUILTIN_HTTP_ANNOTATIONS_TO_METHOD.containsKey(annotation.name())) {
                return true;
            }
            if (!annotation.name().equals((Object)ResteasyReactiveDotNames.PATH)) continue;
            return true;
        }
        return false;
    }

    private Optional<String> getConfigKey(AnnotationInstance registerRestClientAnnotation) {
        AnnotationValue configKeyValue = registerRestClientAnnotation.value("configKey");
        return configKeyValue != null ? Optional.of(configKeyValue.asString()) : Optional.empty();
    }

    private ScopeInfo computeDefaultScope(Capabilities capabilities, Config config, ClassInfo restClientInterface, Optional<String> configKey, RestClientReactiveConfig mpClientConfig) {
        BuiltinScope globalDefaultScope;
        ScopeInfo scopeToUse;
        block7: {
            block6: {
                scopeToUse = null;
                Optional scopeConfig = RestClientConfigUtils.findConfiguredScope((Config)config, (ClassInfo)restClientInterface, configKey);
                globalDefaultScope = BuiltinScope.from((DotName)DotName.createSimple((String)mpClientConfig.scope));
                if (globalDefaultScope == null) {
                    log.warnv("Unable to map the global rest client scope: '{}' to a scope. Using @ApplicationScoped", (Object)mpClientConfig.scope);
                    globalDefaultScope = BuiltinScope.APPLICATION;
                }
                if (!scopeConfig.isPresent()) break block6;
                DotName scope = DotName.createSimple((String)((String)scopeConfig.get()));
                BuiltinScope builtinScope = this.builtinScopeFromName(scope);
                if (builtinScope != null) {
                    scopeToUse = builtinScope.getInfo();
                } else if (capabilities.isPresent("io.quarkus.servlet") && (scope.equals((Object)SESSION_SCOPED) || scope.toString().equalsIgnoreCase(SESSION_SCOPED.withoutPackagePrefix()))) {
                    scopeToUse = new ScopeInfo(SESSION_SCOPED, true);
                }
                if (scopeToUse != null) break block7;
                log.warnf("Unsupported default scope {} provided for rest client {}. Defaulting to {}", (Object)scope, (Object)restClientInterface.name(), (Object)globalDefaultScope.getName());
                scopeToUse = BuiltinScope.DEPENDENT.getInfo();
                break block7;
            }
            Set annotations = restClientInterface.annotations().keySet();
            for (DotName annotationName : annotations) {
                BuiltinScope builtinScope = BuiltinScope.from((DotName)annotationName);
                if (builtinScope != null) {
                    scopeToUse = builtinScope.getInfo();
                    break;
                }
                if (!annotationName.equals((Object)SESSION_SCOPED)) continue;
                scopeToUse = new ScopeInfo(SESSION_SCOPED, true);
                break;
            }
        }
        return scopeToUse != null ? scopeToUse : globalDefaultScope.getInfo();
    }

    private BuiltinScope builtinScopeFromName(DotName scopeName) {
        BuiltinScope scope = BuiltinScope.from((DotName)scopeName);
        if (scope == null) {
            for (BuiltinScope builtinScope : BuiltinScope.values()) {
                if (!builtinScope.getName().withoutPackagePrefix().equalsIgnoreCase(scopeName.toString())) continue;
                scope = builtinScope;
            }
        }
        return scope;
    }
}

