/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.rest.client.reactive.deployment;

import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.deployment.GeneratedClassGizmoAdaptor;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.gizmo.AssignableResultHandle;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.CatchBlockCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FieldCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.gizmo.TryBlock;
import io.quarkus.jaxrs.client.reactive.deployment.JaxrsClientReactiveEnricher;
import io.quarkus.rest.client.reactive.HeaderFiller;
import io.quarkus.rest.client.reactive.deployment.DotNames;
import io.quarkus.rest.client.reactive.runtime.ClientQueryParamSupport;
import io.quarkus.rest.client.reactive.runtime.ConfigUtils;
import io.quarkus.rest.client.reactive.runtime.MicroProfileRestClientRequestFilter;
import io.quarkus.rest.client.reactive.runtime.NoOpHeaderFiller;
import io.quarkus.runtime.util.HashUtil;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.Configurable;
import jakarta.ws.rs.core.MultivaluedMap;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.microprofile.rest.client.RestClientDefinitionException;
import org.eclipse.microprofile.rest.client.ext.ClientHeadersFactory;
import org.eclipse.microprofile.rest.client.ext.DefaultClientHeadersFactoryImpl;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;
import org.jboss.resteasy.reactive.client.impl.WebTargetImpl;

class MicroProfileRestClientEnricher
implements JaxrsClientReactiveEnricher {
    private static final Logger log = Logger.getLogger(MicroProfileRestClientEnricher.class);
    public static final String DEFAULT_HEADERS_FACTORY = DefaultClientHeadersFactoryImpl.class.getName();
    private static final AnnotationInstance[] EMPTY_ANNOTATION_INSTANCES = new AnnotationInstance[0];
    private static final MethodDescriptor INVOCATION_BUILDER_PROPERTY_METHOD = MethodDescriptor.ofMethod(Invocation.Builder.class, (String)"property", Invocation.Builder.class, (Class[])new Class[]{String.class, Object.class});
    private static final MethodDescriptor LIST_ADD_METHOD = MethodDescriptor.ofMethod(List.class, (String)"add", Boolean.TYPE, (Class[])new Class[]{Object.class});
    private static final MethodDescriptor MAP_PUT_METHOD = MethodDescriptor.ofMethod(Map.class, (String)"put", Object.class, (Class[])new Class[]{Object.class, Object.class});
    private static final MethodDescriptor MAP_CONTAINS_KEY_METHOD = MethodDescriptor.ofMethod(Map.class, (String)"containsKey", Boolean.TYPE, (Class[])new Class[]{Object.class});
    public static final String INVOKED_METHOD = "org.eclipse.microprofile.rest.client.invokedMethod";
    private static final MethodDescriptor WEB_TARGET_IMPL_QUERY_PARAMS = MethodDescriptor.ofMethod(WebTargetImpl.class, (String)"queryParam", WebTargetImpl.class, (Class[])new Class[]{String.class, Collection.class});
    private final Map<ClassInfo, String> interfaceMocks = new HashMap<ClassInfo, String>();

    MicroProfileRestClientEnricher() {
    }

    public void forClass(MethodCreator constructor, AssignableResultHandle webTargetBase, ClassInfo interfaceClass, IndexView index) {
        ResultHandle clientHeadersFactory = null;
        AnnotationInstance registerClientHeaders = interfaceClass.classAnnotation(DotNames.REGISTER_CLIENT_HEADERS);
        if (registerClientHeaders != null) {
            String headersFactoryClass = registerClientHeaders.valueWithDefault(index).asClass().name().toString();
            if (!headersFactoryClass.equals(DEFAULT_HEADERS_FACTORY)) {
                ResultHandle containerHandle = constructor.invokeStaticMethod(MethodDescriptor.ofMethod(Arc.class, (String)"container", ArcContainer.class, (Class[])new Class[0]), new ResultHandle[0]);
                ResultHandle instanceHandle = constructor.invokeInterfaceMethod(MethodDescriptor.ofMethod(ArcContainer.class, (String)"instance", InstanceHandle.class, (Class[])new Class[]{Class.class, Annotation[].class}), containerHandle, new ResultHandle[]{constructor.loadClassFromTCCL(headersFactoryClass), constructor.newArray(Annotation.class, 0)});
                clientHeadersFactory = constructor.invokeInterfaceMethod(MethodDescriptor.ofMethod(InstanceHandle.class, (String)"get", Object.class, (Class[])new Class[0]), instanceHandle, new ResultHandle[0]);
            } else {
                clientHeadersFactory = constructor.newInstance(MethodDescriptor.ofConstructor((String)DEFAULT_HEADERS_FACTORY, (String[])new String[0]), new ResultHandle[0]);
            }
        } else {
            clientHeadersFactory = constructor.loadNull();
        }
        ResultHandle restClientFilter = constructor.newInstance(MethodDescriptor.ofConstructor(MicroProfileRestClientRequestFilter.class, (Class[])new Class[]{ClientHeadersFactory.class}), new ResultHandle[]{clientHeadersFactory});
        constructor.assign(webTargetBase, constructor.invokeInterfaceMethod(MethodDescriptor.ofMethod(Configurable.class, (String)"register", Configurable.class, (Class[])new Class[]{Object.class}), (ResultHandle)webTargetBase, new ResultHandle[]{restClientFilter}));
    }

    public void forWebTarget(MethodCreator methodCreator, IndexView index, ClassInfo interfaceClass, MethodInfo method, AssignableResultHandle webTarget, BuildProducer<GeneratedClassBuildItem> generatedClasses) {
        HashMap<String, QueryData> queryParamsByName = new HashMap<String, QueryData>();
        this.collectClientQueryParamData(interfaceClass, method, queryParamsByName);
        for (Map.Entry headerEntry : queryParamsByName.entrySet()) {
            this.addQueryParam(method, methodCreator, (QueryData)headerEntry.getValue(), webTarget, generatedClasses, index);
        }
    }

    public void forSubResourceWebTarget(MethodCreator methodCreator, IndexView index, ClassInfo rootInterfaceClass, ClassInfo subInterfaceClass, MethodInfo rootMethod, MethodInfo subMethod, AssignableResultHandle webTarget, BuildProducer<GeneratedClassBuildItem> generatedClasses) {
        HashMap<String, QueryData> queryParamsByName = new HashMap<String, QueryData>();
        this.collectClientQueryParamData(rootInterfaceClass, rootMethod, queryParamsByName);
        this.collectClientQueryParamData(subInterfaceClass, subMethod, queryParamsByName);
        for (Map.Entry headerEntry : queryParamsByName.entrySet()) {
            this.addQueryParam(subMethod, methodCreator, (QueryData)headerEntry.getValue(), webTarget, generatedClasses, index);
        }
    }

    private void collectClientQueryParamData(ClassInfo interfaceClass, MethodInfo method, Map<String, QueryData> headerFillersByName) {
        AnnotationInstance classLevelHeader = interfaceClass.declaredAnnotation(DotNames.CLIENT_QUERY_PARAM);
        if (classLevelHeader != null) {
            headerFillersByName.put(classLevelHeader.value("name").asString(), new QueryData(classLevelHeader, interfaceClass));
        }
        this.putAllQueryAnnotations(headerFillersByName, interfaceClass, this.extractAnnotations(interfaceClass.declaredAnnotation(DotNames.CLIENT_QUERY_PARAMS)));
        HashMap<String, QueryData> methodLevelHeadersByName = new HashMap<String, QueryData>();
        AnnotationInstance methodLevelHeader = method.annotation(DotNames.CLIENT_QUERY_PARAM);
        if (methodLevelHeader != null) {
            methodLevelHeadersByName.put(methodLevelHeader.value("name").asString(), new QueryData(methodLevelHeader, interfaceClass));
        }
        this.putAllQueryAnnotations(methodLevelHeadersByName, interfaceClass, this.extractAnnotations(method.annotation(DotNames.CLIENT_QUERY_PARAMS)));
        headerFillersByName.putAll(methodLevelHeadersByName);
    }

    private void putAllQueryAnnotations(Map<String, QueryData> headerMap, ClassInfo interfaceClass, AnnotationInstance[] annotations) {
        for (AnnotationInstance annotation : annotations) {
            String name = annotation.value("name").asString();
            if (headerMap.put(name, new QueryData(annotation, interfaceClass)) == null) continue;
            throw new RestClientDefinitionException("Duplicate ClientQueryParam annotation for query parameter: " + name + " on " + annotation.target());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addQueryParam(MethodInfo declaringMethod, MethodCreator methodCreator, QueryData queryData, AssignableResultHandle webTargetImpl, BuildProducer<GeneratedClassBuildItem> generatedClasses, IndexView index) {
        AnnotationInstance annotation = queryData.annotation;
        ClassInfo declaringClass = queryData.definingClass;
        String queryName = annotation.value("name").asString();
        ResultHandle queryNameHandle = methodCreator.load(queryName);
        ResultHandle isQueryParamPresent = methodCreator.invokeStaticMethod(MethodDescriptor.ofMethod(ClientQueryParamSupport.class, (String)"isQueryParamPresent", Boolean.TYPE, (Class[])new Class[]{WebTargetImpl.class, String.class}), new ResultHandle[]{webTargetImpl, queryNameHandle});
        BytecodeCreator creator = methodCreator.ifTrue(isQueryParamPresent).falseBranch();
        String[] values = annotation.value().asStringArray();
        if (values.length == 0) {
            log.warnv("Ignoring ClientQueryParam that specifies an empty array of header values for header {} on {}", (Object)annotation.value("name").asString(), (Object)annotation.target());
            return;
        }
        if (values.length > 1 || !values[0].startsWith("{") || !values[0].endsWith("}")) {
            boolean required = annotation.valueWithDefault(index, "required").asBoolean();
            ResultHandle valuesList = creator.newInstance(MethodDescriptor.ofConstructor(ArrayList.class, (Class[])new Class[0]), new ResultHandle[0]);
            for (String value : values) {
                if (value.contains("${")) {
                    ResultHandle queryValueFromConfig = creator.invokeStaticMethod(MethodDescriptor.ofMethod(ConfigUtils.class, (String)"interpolate", String.class, (Class[])new Class[]{String.class, Boolean.TYPE}), new ResultHandle[]{creator.load(value), creator.load(required)});
                    creator.ifNotNull(queryValueFromConfig).trueBranch().invokeInterfaceMethod(LIST_ADD_METHOD, valuesList, new ResultHandle[]{queryValueFromConfig});
                    continue;
                }
                creator.invokeInterfaceMethod(LIST_ADD_METHOD, valuesList, new ResultHandle[]{creator.load(value)});
            }
            creator.assign(webTargetImpl, creator.invokeVirtualMethod(WEB_TARGET_IMPL_QUERY_PARAMS, (ResultHandle)webTargetImpl, new ResultHandle[]{queryNameHandle, valuesList}));
            return;
        } else {
            ResultHandle valuesList;
            ResultHandle queryValue;
            MethodInfo queryValueMethod;
            String methodName;
            boolean required = annotation.valueWithDefault(index, "required").asBoolean();
            BytecodeCreator methodCallCreator = creator;
            TryBlock tryBlock = null;
            if (!required) {
                tryBlock = creator.tryBlock();
                methodCallCreator = tryBlock;
            }
            if ((methodName = values[0].substring(1, values[0].length() - 1)).contains(".")) {
                int endOfClassName = methodName.lastIndexOf(46);
                String className = methodName.substring(0, endOfClassName);
                String staticMethodName = methodName.substring(endOfClassName + 1);
                ClassInfo clazz = index.getClassByName(DotName.createSimple((String)className));
                if (clazz == null) {
                    throw new RestClientDefinitionException("Class " + className + " used in ClientQueryParam on " + declaringClass + " not found");
                }
                queryValueMethod = this.findMethod(clazz, declaringClass, staticMethodName, DotNames.CLIENT_QUERY_PARAM.toString());
                if (queryValueMethod.parametersCount() == 0) {
                    queryValue = methodCallCreator.invokeStaticMethod(queryValueMethod, new ResultHandle[0]);
                } else {
                    if (queryValueMethod.parametersCount() != 1 || !MicroProfileRestClientEnricher.isString(queryValueMethod.parameterType(0))) throw new RestClientDefinitionException("ClientQueryParam method " + declaringClass.toString() + "#" + staticMethodName + " has too many parameters, at most one parameter, header name, expected");
                    queryValue = methodCallCreator.invokeStaticMethod(queryValueMethod, new ResultHandle[]{methodCallCreator.load(queryName)});
                }
            } else {
                String mockName = this.mockInterface(declaringClass, generatedClasses, index);
                ResultHandle interfaceMock = methodCallCreator.newInstance(MethodDescriptor.ofConstructor((String)mockName, (String[])new String[0]), new ResultHandle[0]);
                queryValueMethod = this.findMethod(declaringClass, declaringClass, methodName, DotNames.CLIENT_QUERY_PARAM.toString());
                if (queryValueMethod == null) {
                    throw new RestClientDefinitionException("ClientQueryParam method " + methodName + " not found on " + declaringClass);
                }
                if (queryValueMethod.parametersCount() == 0) {
                    queryValue = methodCallCreator.invokeInterfaceMethod(queryValueMethod, interfaceMock, new ResultHandle[0]);
                } else {
                    if (queryValueMethod.parametersCount() != 1 || !MicroProfileRestClientEnricher.isString(queryValueMethod.parameterType(0))) throw new RestClientDefinitionException("ClientQueryParam method " + declaringClass + "#" + methodName + " has too many parameters, at most one parameter, header name, expected");
                    queryValue = methodCallCreator.invokeInterfaceMethod(queryValueMethod, interfaceMock, new ResultHandle[]{methodCallCreator.load(queryName)});
                }
            }
            Type returnType = queryValueMethod.returnType();
            if (returnType.kind() == Type.Kind.ARRAY && returnType.asArrayType().component().name().equals((Object)io.quarkus.arc.processor.DotNames.STRING)) {
                valuesList = methodCallCreator.invokeStaticMethod(MethodDescriptor.ofMethod(Arrays.class, (String)"asList", List.class, (Class[])new Class[]{Object[].class}), new ResultHandle[]{queryValue});
            } else {
                if (returnType.kind() != Type.Kind.CLASS || !returnType.name().equals((Object)io.quarkus.arc.processor.DotNames.STRING)) throw new RestClientDefinitionException("Method " + declaringClass.toString() + "#" + methodName + " has an unsupported return type for ClientQueryParam. Only String and String[] return types are supported");
                valuesList = methodCallCreator.newInstance(MethodDescriptor.ofConstructor(ArrayList.class, (Class[])new Class[0]), new ResultHandle[0]);
                methodCallCreator.invokeInterfaceMethod(LIST_ADD_METHOD, valuesList, new ResultHandle[]{queryValue});
            }
            methodCallCreator.assign(webTargetImpl, methodCallCreator.invokeVirtualMethod(WEB_TARGET_IMPL_QUERY_PARAMS, (ResultHandle)webTargetImpl, new ResultHandle[]{queryNameHandle, valuesList}));
            if (required) return;
            CatchBlockCreator catchBlock = tryBlock.addCatch(Exception.class);
            ResultHandle log = catchBlock.invokeStaticMethod(MethodDescriptor.ofMethod(Logger.class, (String)"getLogger", Logger.class, (Class[])new Class[]{String.class}), new ResultHandle[]{catchBlock.load(declaringClass.name().toString())});
            String errorMessage = String.format("Invoking query param generation method '%s' for '%s' on method '%s#%s' failed", methodName, queryName, declaringClass.name(), declaringMethod.name());
            catchBlock.invokeVirtualMethod(MethodDescriptor.ofMethod(Logger.class, (String)"warn", Void.TYPE, (Class[])new Class[]{Object.class, Throwable.class}), log, new ResultHandle[]{catchBlock.load(errorMessage), catchBlock.getCaughtException()});
        }
    }

    public void forSubResourceMethod(ClassCreator subClassCreator, MethodCreator subConstructor, MethodCreator subClinit, MethodCreator subMethodCreator, ClassInfo rootInterfaceClass, ClassInfo subInterfaceClass, MethodInfo subMethod, MethodInfo rootMethod, AssignableResultHandle invocationBuilder, IndexView index, BuildProducer<GeneratedClassBuildItem> generatedClasses, int methodIndex, int subMethodIndex, FieldDescriptor javaMethodField) {
        this.addJavaMethodToContext(javaMethodField, subMethodCreator, invocationBuilder);
        HashMap<String, HeaderData> headerFillersByName = new HashMap<String, HeaderData>();
        this.collectHeaderFillers(rootInterfaceClass, rootMethod, headerFillersByName);
        this.collectHeaderFillers(subInterfaceClass, subMethod, headerFillersByName);
        String subHeaderFillerName = subInterfaceClass.name().toString() + org.jboss.resteasy.reactive.common.processor.HashUtil.sha1((String)rootInterfaceClass.name().toString()) + "$$" + methodIndex + "$$" + subMethodIndex;
        this.createAndReturnHeaderFiller(subClassCreator, subConstructor, subMethodCreator, subMethod, invocationBuilder, index, generatedClasses, subMethodIndex, subHeaderFillerName, headerFillersByName);
    }

    public void forMethod(ClassCreator classCreator, MethodCreator constructor, MethodCreator clinit, MethodCreator methodCreator, ClassInfo interfaceClass, MethodInfo method, AssignableResultHandle invocationBuilder, IndexView index, BuildProducer<GeneratedClassBuildItem> generatedClasses, int methodIndex, FieldDescriptor javaMethodField) {
        this.addJavaMethodToContext(javaMethodField, methodCreator, invocationBuilder);
        HashMap<String, HeaderData> headerFillersByName = new HashMap<String, HeaderData>();
        this.collectHeaderFillers(interfaceClass, method, headerFillersByName);
        this.createAndReturnHeaderFiller(classCreator, constructor, methodCreator, method, invocationBuilder, index, generatedClasses, methodIndex, interfaceClass + "$$" + method.name() + "$$" + methodIndex, headerFillersByName);
    }

    private void createAndReturnHeaderFiller(ClassCreator classCreator, MethodCreator constructor, MethodCreator methodCreator, MethodInfo method, AssignableResultHandle invocationBuilder, IndexView index, BuildProducer<GeneratedClassBuildItem> generatedClasses, int methodIndex, String fillerClassName, Map<String, HeaderData> headerFillersByName) {
        ResultHandle headerFiller;
        FieldDescriptor headerFillerField = FieldDescriptor.of((String)classCreator.getClassName(), (String)("headerFiller" + methodIndex), HeaderFiller.class);
        classCreator.getFieldCreator(headerFillerField).setModifiers(18);
        if (!headerFillersByName.isEmpty()) {
            GeneratedClassGizmoAdaptor classOutput = new GeneratedClassGizmoAdaptor(generatedClasses, true);
            try (ClassCreator headerFillerClass = ClassCreator.builder().className(fillerClassName).interfaces(new Class[]{HeaderFiller.class}).classOutput((ClassOutput)classOutput).build();){
                FieldCreator logField = headerFillerClass.getFieldCreator("log", Logger.class);
                logField.setModifiers(26);
                MethodCreator staticConstructor = headerFillerClass.getMethodCreator("<clinit>", Void.TYPE, new Class[0]);
                staticConstructor.setModifiers(8);
                ResultHandle log = staticConstructor.invokeStaticMethod(MethodDescriptor.ofMethod(Logger.class, (String)"getLogger", Logger.class, (Class[])new Class[]{String.class}), new ResultHandle[]{staticConstructor.load(fillerClassName)});
                staticConstructor.writeStaticField(logField.getFieldDescriptor(), log);
                staticConstructor.returnValue(null);
                MethodCreator fillHeaders = headerFillerClass.getMethodCreator(MethodDescriptor.ofMethod(HeaderFiller.class, (String)"addHeaders", Void.TYPE, (Class[])new Class[]{MultivaluedMap.class}));
                for (Map.Entry<String, HeaderData> headerEntry : headerFillersByName.entrySet()) {
                    this.addHeaderParam(method, fillHeaders, headerEntry.getValue(), generatedClasses, fillerClassName, index);
                }
                fillHeaders.returnValue(null);
                headerFiller = constructor.newInstance(MethodDescriptor.ofConstructor((String)fillerClassName, (String[])new String[0]), new ResultHandle[0]);
            }
        } else {
            headerFiller = constructor.readStaticField(FieldDescriptor.of(NoOpHeaderFiller.class, (String)"INSTANCE", NoOpHeaderFiller.class));
        }
        constructor.writeInstanceField(headerFillerField, constructor.getThis(), headerFiller);
        ResultHandle headerFillerAsObject = methodCreator.checkCast(methodCreator.readInstanceField(headerFillerField, methodCreator.getThis()), Object.class);
        methodCreator.assign(invocationBuilder, methodCreator.invokeInterfaceMethod(INVOCATION_BUILDER_PROPERTY_METHOD, (ResultHandle)invocationBuilder, new ResultHandle[]{methodCreator.load(HeaderFiller.class.getName()), headerFillerAsObject}));
    }

    private void collectHeaderFillers(ClassInfo interfaceClass, MethodInfo method, Map<String, HeaderData> headerFillersByName) {
        AnnotationInstance classLevelHeader = interfaceClass.classAnnotation(DotNames.CLIENT_HEADER_PARAM);
        if (classLevelHeader != null) {
            headerFillersByName.put(classLevelHeader.value("name").asString(), new HeaderData(classLevelHeader, interfaceClass));
        }
        this.putAllHeaderAnnotations(headerFillersByName, interfaceClass, this.extractAnnotations(interfaceClass.classAnnotation(DotNames.CLIENT_HEADER_PARAMS)));
        HashMap<String, HeaderData> methodLevelHeadersByName = new HashMap<String, HeaderData>();
        AnnotationInstance methodLevelHeader = method.annotation(DotNames.CLIENT_HEADER_PARAM);
        if (methodLevelHeader != null) {
            methodLevelHeadersByName.put(methodLevelHeader.value("name").asString(), new HeaderData(methodLevelHeader, interfaceClass));
        }
        this.putAllHeaderAnnotations(methodLevelHeadersByName, interfaceClass, this.extractAnnotations(method.annotation(DotNames.CLIENT_HEADER_PARAMS)));
        headerFillersByName.putAll(methodLevelHeadersByName);
    }

    private void addJavaMethodToContext(FieldDescriptor javaMethodField, MethodCreator methodCreator, AssignableResultHandle invocationBuilder) {
        ResultHandle javaMethod = methodCreator.readStaticField(javaMethodField);
        ResultHandle javaMethodAsObject = methodCreator.checkCast(javaMethod, Object.class);
        methodCreator.assign(invocationBuilder, methodCreator.invokeInterfaceMethod(INVOCATION_BUILDER_PROPERTY_METHOD, (ResultHandle)invocationBuilder, new ResultHandle[]{methodCreator.load(INVOKED_METHOD), javaMethodAsObject}));
    }

    private void putAllHeaderAnnotations(Map<String, HeaderData> headerMap, ClassInfo interfaceClass, AnnotationInstance[] annotations) {
        for (AnnotationInstance annotation : annotations) {
            String headerName = annotation.value("name").asString();
            if (headerMap.put(headerName, new HeaderData(annotation, interfaceClass)) == null) continue;
            throw new RestClientDefinitionException("Duplicate ClientHeaderParam annotation for header: " + headerName + " on " + annotation.target());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addHeaderParam(MethodInfo declaringMethod, MethodCreator fillHeadersCreator, HeaderData headerData, BuildProducer<GeneratedClassBuildItem> generatedClasses, String fillerClassName, IndexView index) {
        AnnotationInstance annotation = headerData.annotation;
        ClassInfo declaringClass = headerData.definingClass;
        String headerName = annotation.value("name").asString();
        String[] values = annotation.value().asStringArray();
        if (values.length == 0) {
            log.warnv("Ignoring ClientHeaderParam that specifies an empty array of header values for header {} on {}", (Object)annotation.value("name").asString(), (Object)annotation.target());
            return;
        }
        ResultHandle headerMap = fillHeadersCreator.getMethodParam(0);
        BytecodeCreator fillHeaders = fillHeadersCreator.ifFalse(fillHeadersCreator.invokeInterfaceMethod(MAP_CONTAINS_KEY_METHOD, headerMap, new ResultHandle[]{fillHeadersCreator.load(headerName)})).trueBranch();
        if (values.length > 1 || !values[0].startsWith("{") || !values[0].endsWith("}")) {
            boolean required = annotation.valueWithDefault(index, "required").asBoolean();
            ResultHandle headerList = fillHeaders.newInstance(MethodDescriptor.ofConstructor(ArrayList.class, (Class[])new Class[0]), new ResultHandle[0]);
            for (String value : values) {
                if (value.contains("${")) {
                    ResultHandle headerValueFromConfig = fillHeaders.invokeStaticMethod(MethodDescriptor.ofMethod(ConfigUtils.class, (String)"interpolate", String.class, (Class[])new Class[]{String.class, Boolean.TYPE}), new ResultHandle[]{fillHeaders.load(value), fillHeaders.load(required)});
                    fillHeaders.ifNotNull(headerValueFromConfig).trueBranch().invokeInterfaceMethod(LIST_ADD_METHOD, headerList, new ResultHandle[]{headerValueFromConfig});
                    continue;
                }
                fillHeaders.invokeInterfaceMethod(LIST_ADD_METHOD, headerList, new ResultHandle[]{fillHeaders.load(value)});
            }
            fillHeaders.invokeInterfaceMethod(MAP_PUT_METHOD, headerMap, new ResultHandle[]{fillHeaders.load(headerName), headerList});
            return;
        } else {
            ResultHandle headerList;
            ResultHandle headerValue;
            MethodInfo headerFillingMethod;
            String methodName;
            boolean required = annotation.valueWithDefault(index, "required").asBoolean();
            BytecodeCreator fillHeader = fillHeaders;
            TryBlock tryBlock = null;
            if (!required) {
                tryBlock = fillHeaders.tryBlock();
                fillHeader = tryBlock;
            }
            if ((methodName = values[0].substring(1, values[0].length() - 1)).contains(".")) {
                int endOfClassName = methodName.lastIndexOf(46);
                String className = methodName.substring(0, endOfClassName);
                String staticMethodName = methodName.substring(endOfClassName + 1);
                ClassInfo clazz = index.getClassByName(DotName.createSimple((String)className));
                if (clazz == null) {
                    throw new RestClientDefinitionException("Class " + className + " used in ClientHeaderParam on " + declaringClass + " not found");
                }
                headerFillingMethod = this.findMethod(clazz, declaringClass, staticMethodName, DotNames.CLIENT_HEADER_PARAM.toString());
                if (headerFillingMethod.parametersCount() == 0) {
                    headerValue = fillHeader.invokeStaticMethod(headerFillingMethod, new ResultHandle[0]);
                } else {
                    if (headerFillingMethod.parametersCount() != 1 || !MicroProfileRestClientEnricher.isString(headerFillingMethod.parameterType(0))) throw new RestClientDefinitionException("ClientHeaderParam method " + declaringClass.toString() + "#" + staticMethodName + " has too many parameters, at most one parameter, header name, expected");
                    headerValue = fillHeader.invokeStaticMethod(headerFillingMethod, new ResultHandle[]{fillHeader.load(headerName)});
                }
            } else {
                String mockName = this.mockInterface(declaringClass, generatedClasses, index);
                ResultHandle interfaceMock = fillHeader.newInstance(MethodDescriptor.ofConstructor((String)mockName, (String[])new String[0]), new ResultHandle[0]);
                headerFillingMethod = this.findMethod(declaringClass, declaringClass, methodName, DotNames.CLIENT_HEADER_PARAM.toString());
                if (headerFillingMethod == null) {
                    throw new RestClientDefinitionException("ClientHeaderParam method " + methodName + " not found on " + declaringClass);
                }
                if (headerFillingMethod.parametersCount() == 0) {
                    headerValue = fillHeader.invokeInterfaceMethod(headerFillingMethod, interfaceMock, new ResultHandle[0]);
                } else {
                    if (headerFillingMethod.parametersCount() != 1 || !MicroProfileRestClientEnricher.isString(headerFillingMethod.parameterType(0))) throw new RestClientDefinitionException("ClientHeaderParam method " + declaringClass + "#" + methodName + " has too many parameters, at most one parameter, header name, expected");
                    headerValue = fillHeader.invokeInterfaceMethod(headerFillingMethod, interfaceMock, new ResultHandle[]{fillHeader.load(headerName)});
                }
            }
            Type returnType = headerFillingMethod.returnType();
            if (returnType.kind() == Type.Kind.ARRAY && returnType.asArrayType().component().name().equals((Object)io.quarkus.arc.processor.DotNames.STRING)) {
                headerList = fillHeader.invokeStaticMethod(MethodDescriptor.ofMethod(Arrays.class, (String)"asList", List.class, (Class[])new Class[]{Object[].class}), new ResultHandle[]{headerValue});
            } else {
                if (returnType.kind() != Type.Kind.CLASS || !returnType.name().equals((Object)io.quarkus.arc.processor.DotNames.STRING)) throw new RestClientDefinitionException("Method " + declaringClass.toString() + "#" + methodName + " has an unsupported return type for ClientHeaderParam. Only String and String[] return types are supported");
                headerList = fillHeader.newInstance(MethodDescriptor.ofConstructor(ArrayList.class, (Class[])new Class[0]), new ResultHandle[0]);
                fillHeader.invokeInterfaceMethod(LIST_ADD_METHOD, headerList, new ResultHandle[]{headerValue});
            }
            fillHeader.invokeInterfaceMethod(MAP_PUT_METHOD, headerMap, new ResultHandle[]{fillHeader.load(headerName), headerList});
            if (required) return;
            CatchBlockCreator catchBlock = tryBlock.addCatch(Exception.class);
            ResultHandle log = catchBlock.readStaticField(FieldDescriptor.of((String)fillerClassName, (String)"log", Logger.class));
            String errorMessage = String.format("Invoking header generation method '%s' for header '%s' on method '%s#%s' failed", methodName, headerName, declaringClass.name(), declaringMethod.name());
            catchBlock.invokeVirtualMethod(MethodDescriptor.ofMethod(Logger.class, (String)"warn", Void.TYPE, (Class[])new Class[]{Object.class, Throwable.class}), log, new ResultHandle[]{catchBlock.load(errorMessage), catchBlock.getCaughtException()});
        }
    }

    private MethodInfo findMethod(ClassInfo declaringClass, ClassInfo restInterface, String methodName, String sourceAnnotationName) {
        MethodInfo result = null;
        for (MethodInfo method : declaringClass.methods()) {
            if (!method.name().equals(methodName)) continue;
            if (result != null) {
                throw new RestClientDefinitionException(String.format("Ambiguous %s definition, more than one method of name %s found on %s. Problematic interface: %s", sourceAnnotationName, methodName, declaringClass, restInterface));
            }
            result = method;
        }
        return result;
    }

    private static boolean isString(Type type) {
        return type.kind() == Type.Kind.CLASS && type.name().toString().equals(String.class.getName());
    }

    private String mockInterface(ClassInfo declaringClass, BuildProducer<GeneratedClassBuildItem> generatedClass, IndexView index) {
        return this.interfaceMocks.computeIfAbsent(declaringClass, classInfo -> {
            String mockName = declaringClass.toString() + HashUtil.sha1((String)declaringClass.toString());
            GeneratedClassGizmoAdaptor classOutput = new GeneratedClassGizmoAdaptor(generatedClass, true);
            List interfaceNames = declaringClass.interfaceNames();
            HashSet methods = new HashSet();
            for (DotName interfaceName : interfaceNames) {
                ClassInfo interfaceClass = index.getClassByName(interfaceName);
                methods.addAll(interfaceClass.methods());
            }
            methods.addAll(declaringClass.methods());
            try (ClassCreator classCreator = ClassCreator.builder().className(mockName).interfaces(new String[]{declaringClass.toString()}).classOutput((ClassOutput)classOutput).build();){
                for (MethodInfo method : methods) {
                    if (!Modifier.isAbstract(method.flags())) continue;
                    MethodCreator methodCreator = classCreator.getMethodCreator(MethodDescriptor.of((MethodInfo)method));
                    methodCreator.throwException(IllegalStateException.class, "This should never be called");
                }
            }
            return mockName;
        });
    }

    private AnnotationInstance[] extractAnnotations(AnnotationInstance groupAnnotation) {
        AnnotationValue annotationValue;
        if (groupAnnotation != null && (annotationValue = groupAnnotation.value()) != null) {
            return annotationValue.asNestedArray();
        }
        return EMPTY_ANNOTATION_INSTANCES;
    }

    private static class QueryData {
        private final AnnotationInstance annotation;
        private final ClassInfo definingClass;

        public QueryData(AnnotationInstance annotation, ClassInfo definingClass) {
            this.annotation = annotation;
            this.definingClass = definingClass;
        }
    }

    private static class HeaderData {
        private final AnnotationInstance annotation;
        private final ClassInfo definingClass;

        public HeaderData(AnnotationInstance annotation, ClassInfo definingClass) {
            this.annotation = annotation;
            this.definingClass = definingClass;
        }
    }
}

