/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.rest.client.reactive.deployment;

import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.deployment.GeneratedClassGizmoAdaptor;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.gizmo.AssignableResultHandle;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.CatchBlockCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FieldCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.ForEachLoop;
import io.quarkus.gizmo.Gizmo;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.gizmo.TryBlock;
import io.quarkus.jaxrs.client.reactive.deployment.JaxrsClientReactiveEnricher;
import io.quarkus.rest.client.reactive.ClientFormParam;
import io.quarkus.rest.client.reactive.ClientQueryParam;
import io.quarkus.rest.client.reactive.ComputedParamContext;
import io.quarkus.rest.client.reactive.HeaderFiller;
import io.quarkus.rest.client.reactive.deployment.DotNames;
import io.quarkus.rest.client.reactive.runtime.ClientQueryParamSupport;
import io.quarkus.rest.client.reactive.runtime.ComputedParamContextImpl;
import io.quarkus.rest.client.reactive.runtime.ConfigUtils;
import io.quarkus.rest.client.reactive.runtime.ExtendedHeaderFiller;
import io.quarkus.rest.client.reactive.runtime.HeaderFillerUtil;
import io.quarkus.rest.client.reactive.runtime.MicroProfileRestClientRequestFilter;
import io.quarkus.rest.client.reactive.runtime.NoOpHeaderFiller;
import io.quarkus.runtime.util.HashUtil;
import jakarta.ws.rs.client.ClientRequestContext;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.Configurable;
import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.eclipse.microprofile.rest.client.RestClientDefinitionException;
import org.eclipse.microprofile.rest.client.ext.ClientHeadersFactory;
import org.eclipse.microprofile.rest.client.ext.DefaultClientHeadersFactoryImpl;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.MethodParameterInfo;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;
import org.jboss.resteasy.reactive.client.api.ClientMultipartForm;
import org.jboss.resteasy.reactive.client.impl.WebTargetImpl;
import org.jboss.resteasy.reactive.client.impl.multipart.QuarkusMultipartForm;
import org.jboss.resteasy.reactive.client.spi.ResteasyReactiveClientRequestContext;
import org.jboss.resteasy.reactive.common.processor.ResteasyReactiveDotNames;

class MicroProfileRestClientEnricher
implements JaxrsClientReactiveEnricher {
    private static final Logger log = Logger.getLogger(MicroProfileRestClientEnricher.class);
    public static final String DEFAULT_HEADERS_FACTORY = DefaultClientHeadersFactoryImpl.class.getName();
    private static final AnnotationInstance[] EMPTY_ANNOTATION_INSTANCES = new AnnotationInstance[0];
    private static final MethodDescriptor INVOCATION_BUILDER_PROPERTY_METHOD = MethodDescriptor.ofMethod(Invocation.Builder.class, (String)"property", Invocation.Builder.class, (Class[])new Class[]{String.class, Object.class});
    private static final MethodDescriptor LIST_ADD_METHOD = MethodDescriptor.ofMethod(List.class, (String)"add", Boolean.TYPE, (Class[])new Class[]{Object.class});
    private static final MethodDescriptor STRING_BUILDER_APPEND = MethodDescriptor.ofMethod(StringBuilder.class, (String)"append", StringBuilder.class, (Class[])new Class[]{String.class});
    private static final MethodDescriptor STRING_LENGTH = MethodDescriptor.ofMethod(String.class, (String)"length", Integer.TYPE, (Class[])new Class[0]);
    private static final MethodDescriptor MAP_PUT_METHOD = MethodDescriptor.ofMethod(Map.class, (String)"put", Object.class, (Class[])new Class[]{Object.class, Object.class});
    private static final MethodDescriptor HEADER_FILLER_UTIL_SHOULD_ADD_HEADER = MethodDescriptor.ofMethod(HeaderFillerUtil.class, (String)"shouldAddHeader", Boolean.TYPE, (Class[])new Class[]{String.class, MultivaluedMap.class, ClientRequestContext.class});
    private static final MethodDescriptor WEB_TARGET_IMPL_QUERY_PARAMS = MethodDescriptor.ofMethod(WebTargetImpl.class, (String)"queryParam", WebTargetImpl.class, (Class[])new Class[]{String.class, Collection.class});
    private static final MethodDescriptor ARRAYS_AS_LIST = MethodDescriptor.ofMethod(Arrays.class, (String)"asList", List.class, (Class[])new Class[]{Object[].class});
    private static final MethodDescriptor COMPUTER_PARAM_CONTEXT_IMPL_CTOR = MethodDescriptor.ofConstructor(ComputedParamContextImpl.class, (Class[])new Class[]{String.class, ClientRequestContext.class});
    private static final MethodDescriptor COMPUTER_PARAM_CONTEXT_IMPL_GET_METHOD_PARAM = MethodDescriptor.ofMethod(ComputedParamContextImpl.class, (String)"getMethodParameterFromContext", Object.class, (Class[])new Class[]{ClientRequestContext.class, Integer.TYPE});
    private static final MethodDescriptor MAP_CONTAINS_KEY_METHOD = MethodDescriptor.ofMethod(Map.class, (String)"containsKey", Boolean.TYPE, (Class[])new Class[]{Object.class});
    private static final MethodDescriptor MULTIVALUED_MAP_ADD_ALL_METHOD = MethodDescriptor.ofMethod(MultivaluedMap.class, (String)"addAll", Void.TYPE, (Class[])new Class[]{Object.class, List.class});
    private static final MethodDescriptor QUARKUS_MULTIPART_FORM_ATTRIBUTE_METHOD = MethodDescriptor.ofMethod(ClientMultipartForm.class, (String)"attribute", ClientMultipartForm.class, (Class[])new Class[]{String.class, String.class, String.class});
    private static final Type STRING_TYPE = Type.create((DotName)DotName.STRING_NAME, (Type.Kind)Type.Kind.CLASS);
    private final Map<ClassInfo, String> interfaceMocks = new HashMap<ClassInfo, String>();

    MicroProfileRestClientEnricher() {
    }

    public void forClass(MethodCreator constructor, AssignableResultHandle webTargetBase, ClassInfo interfaceClass, IndexView index) {
        ResultHandle clientHeadersFactory = null;
        AnnotationInstance registerClientHeaders = interfaceClass.declaredAnnotation(DotNames.REGISTER_CLIENT_HEADERS);
        if (registerClientHeaders != null) {
            String headersFactoryClass = registerClientHeaders.valueWithDefault(index).asClass().name().toString();
            if (!headersFactoryClass.equals(DEFAULT_HEADERS_FACTORY)) {
                ResultHandle containerHandle = constructor.invokeStaticMethod(MethodDescriptor.ofMethod(Arc.class, (String)"container", ArcContainer.class, (Class[])new Class[0]), new ResultHandle[0]);
                ResultHandle instanceHandle = constructor.invokeInterfaceMethod(MethodDescriptor.ofMethod(ArcContainer.class, (String)"instance", InstanceHandle.class, (Class[])new Class[]{Class.class, Annotation[].class}), containerHandle, new ResultHandle[]{constructor.loadClassFromTCCL(headersFactoryClass), constructor.newArray(Annotation.class, 0)});
                clientHeadersFactory = constructor.invokeInterfaceMethod(MethodDescriptor.ofMethod(InstanceHandle.class, (String)"get", Object.class, (Class[])new Class[0]), instanceHandle, new ResultHandle[0]);
            } else {
                clientHeadersFactory = constructor.newInstance(MethodDescriptor.ofConstructor((String)DEFAULT_HEADERS_FACTORY, (String[])new String[0]), new ResultHandle[0]);
            }
        } else {
            clientHeadersFactory = constructor.loadNull();
        }
        ResultHandle restClientFilter = constructor.newInstance(MethodDescriptor.ofConstructor(MicroProfileRestClientRequestFilter.class, (Class[])new Class[]{ClientHeadersFactory.class}), new ResultHandle[]{clientHeadersFactory});
        constructor.assign(webTargetBase, constructor.invokeInterfaceMethod(MethodDescriptor.ofMethod(Configurable.class, (String)"register", Configurable.class, (Class[])new Class[]{Object.class}), (ResultHandle)webTargetBase, new ResultHandle[]{restClientFilter}));
    }

    public void forWebTarget(MethodCreator methodCreator, IndexView index, ClassInfo interfaceClass, MethodInfo method, AssignableResultHandle webTarget, BuildProducer<GeneratedClassBuildItem> generatedClasses) {
        HashMap<String, ParamData> queryParamsByName = new HashMap<String, ParamData>();
        this.collectClientParamData(interfaceClass, method, queryParamsByName, DotNames.CLIENT_QUERY_PARAM, DotNames.CLIENT_QUERY_PARAMS, ClientQueryParam.class.getSimpleName());
        for (Map.Entry queryEntry : queryParamsByName.entrySet()) {
            this.addQueryParam(method, methodCreator, (ParamData)queryEntry.getValue(), webTarget, generatedClasses, index);
        }
    }

    public void forSubResourceWebTarget(MethodCreator methodCreator, IndexView index, ClassInfo rootInterfaceClass, ClassInfo subInterfaceClass, MethodInfo rootMethod, MethodInfo subMethod, AssignableResultHandle webTarget, BuildProducer<GeneratedClassBuildItem> generatedClasses) {
        HashMap<String, ParamData> queryParamsByName = new HashMap<String, ParamData>();
        this.collectClientParamData(rootInterfaceClass, rootMethod, queryParamsByName, DotNames.CLIENT_QUERY_PARAM, DotNames.CLIENT_QUERY_PARAMS, ClientQueryParam.class.getSimpleName());
        this.collectClientParamData(subInterfaceClass, subMethod, queryParamsByName, DotNames.CLIENT_QUERY_PARAM, DotNames.CLIENT_QUERY_PARAMS, ClientQueryParam.class.getSimpleName());
        for (Map.Entry headerEntry : queryParamsByName.entrySet()) {
            this.addQueryParam(subMethod, methodCreator, (ParamData)headerEntry.getValue(), webTarget, generatedClasses, index);
        }
    }

    public AssignableResultHandle handleFormParams(MethodCreator methodCreator, IndexView index, ClassInfo interfaceClass, MethodInfo method, BuildProducer<GeneratedClassBuildItem> generatedClasses, AssignableResultHandle formParams, boolean multipart) {
        HashMap<String, ParamData> formParamsByName = new HashMap<String, ParamData>();
        this.collectClientParamData(interfaceClass, method, formParamsByName, DotNames.CLIENT_FORM_PARAM, DotNames.CLIENT_FORM_PARAMS, ClientFormParam.class.getSimpleName());
        if (!formParamsByName.isEmpty() && formParams == null) {
            formParams = this.createFormData((BytecodeCreator)methodCreator, multipart);
        }
        for (Map.Entry formEntry : formParamsByName.entrySet()) {
            this.addFormParam(method, methodCreator, (ParamData)formEntry.getValue(), generatedClasses, index, formParams, multipart);
        }
        return formParams;
    }

    public AssignableResultHandle handleFormParamsForSubResource(MethodCreator methodCreator, IndexView index, ClassInfo rootInterfaceClass, ClassInfo subInterfaceClass, MethodInfo rootMethod, MethodInfo subMethod, AssignableResultHandle webTarget, BuildProducer<GeneratedClassBuildItem> generatedClasses, AssignableResultHandle formParams, boolean multipart) {
        HashMap<String, ParamData> formParamsByName = new HashMap<String, ParamData>();
        this.collectClientParamData(rootInterfaceClass, rootMethod, formParamsByName, DotNames.CLIENT_FORM_PARAM, DotNames.CLIENT_FORM_PARAMS, ClientFormParam.class.getSimpleName());
        this.collectClientParamData(subInterfaceClass, subMethod, formParamsByName, DotNames.CLIENT_FORM_PARAM, DotNames.CLIENT_FORM_PARAMS, ClientFormParam.class.getSimpleName());
        if (!formParamsByName.isEmpty() && formParams == null) {
            formParams = this.createFormData((BytecodeCreator)methodCreator, multipart);
        }
        for (Map.Entry formEntry : formParamsByName.entrySet()) {
            this.addFormParam(subMethod, methodCreator, (ParamData)formEntry.getValue(), generatedClasses, index, formParams, multipart);
        }
        return formParams;
    }

    private AssignableResultHandle createFormData(BytecodeCreator methodCreator, boolean multipart) {
        AssignableResultHandle formParams;
        if (multipart) {
            formParams = methodCreator.createVariable(QuarkusMultipartForm.class);
            methodCreator.assign(formParams, methodCreator.newInstance(MethodDescriptor.ofConstructor(QuarkusMultipartForm.class, (Class[])new Class[0]), new ResultHandle[0]));
        } else {
            formParams = methodCreator.createVariable(MultivaluedMap.class);
            methodCreator.assign(formParams, methodCreator.newInstance(MethodDescriptor.ofConstructor(MultivaluedHashMap.class, (Class[])new Class[0]), new ResultHandle[0]));
        }
        return formParams;
    }

    private void addQueryParam(MethodInfo declaringMethod, MethodCreator methodCreator, ParamData paramData, AssignableResultHandle webTargetImpl, BuildProducer<GeneratedClassBuildItem> generatedClasses, IndexView index) {
        String paramName = paramData.annotation.value("name").asString();
        Supplier<ResultHandle> existenceChecker = () -> methodCreator.invokeStaticMethod(MethodDescriptor.ofMethod(ClientQueryParamSupport.class, (String)"isQueryParamPresent", Boolean.TYPE, (Class[])new Class[]{WebTargetImpl.class, String.class}), new ResultHandle[]{webTargetImpl, methodCreator.load(paramName)});
        BiConsumer<BytecodeCreator, ResultHandle> paramAdder = (creator, valuesList) -> creator.assign(webTargetImpl, creator.invokeVirtualMethod(WEB_TARGET_IMPL_QUERY_PARAMS, (ResultHandle)webTargetImpl, new ResultHandle[]{methodCreator.load(paramName), valuesList}));
        this.addParam(declaringMethod, methodCreator, paramData, generatedClasses, index, DotNames.CLIENT_QUERY_PARAM, ClientQueryParam.class.getSimpleName(), paramName, existenceChecker, paramAdder);
    }

    private void addFormParam(MethodInfo declaringMethod, MethodCreator methodCreator, ParamData paramData, BuildProducer<GeneratedClassBuildItem> generatedClasses, IndexView index, AssignableResultHandle formParams, boolean multipart) {
        String paramName = paramData.annotation.value("name").asString();
        Supplier<ResultHandle> existenceChecker = () -> methodCreator.invokeInterfaceMethod(MAP_CONTAINS_KEY_METHOD, (ResultHandle)formParams, new ResultHandle[]{methodCreator.load(paramName)});
        BiConsumer<BytecodeCreator, ResultHandle> paramAdder = (creator, valuesList) -> {
            if (multipart) {
                String filename = null;
                AnnotationInstance partFileName = declaringMethod.annotation(ResteasyReactiveDotNames.PART_FILE_NAME);
                if (partFileName != null && partFileName.value() != null) {
                    filename = partFileName.value().asString();
                }
                ForEachLoop loop = creator.forEach(valuesList);
                BytecodeCreator block = loop.block();
                block.invokeVirtualMethod(QUARKUS_MULTIPART_FORM_ATTRIBUTE_METHOD, (ResultHandle)formParams, new ResultHandle[]{block.load(paramName), loop.element(), block.load(filename)});
            } else {
                creator.invokeInterfaceMethod(MULTIVALUED_MAP_ADD_ALL_METHOD, (ResultHandle)formParams, new ResultHandle[]{creator.load(paramName), valuesList});
            }
        };
        this.addParam(declaringMethod, methodCreator, paramData, generatedClasses, index, DotNames.CLIENT_FORM_PARAM, ClientFormParam.class.getSimpleName(), paramName, existenceChecker, paramAdder);
    }

    private void collectClientParamData(ClassInfo interfaceClass, MethodInfo method, Map<String, ParamData> paramFillersByName, DotName clientParamAnnotation, DotName clientParamsAnnotation, String annotationName) {
        AnnotationInstance classLevelParam = interfaceClass.declaredAnnotation(clientParamAnnotation);
        if (classLevelParam != null) {
            paramFillersByName.put(classLevelParam.value("name").asString(), new ParamData(classLevelParam, interfaceClass));
        }
        this.putAllParamAnnotations(paramFillersByName, interfaceClass, this.extractAnnotations(interfaceClass.declaredAnnotation(clientParamsAnnotation)), annotationName);
        HashMap<String, ParamData> methodLevelParamsByName = new HashMap<String, ParamData>();
        AnnotationInstance methodLevelParam = method.annotation(clientParamAnnotation);
        if (methodLevelParam != null) {
            methodLevelParamsByName.put(methodLevelParam.value("name").asString(), new ParamData(methodLevelParam, interfaceClass));
        }
        this.putAllParamAnnotations(methodLevelParamsByName, interfaceClass, this.extractAnnotations(method.annotation(clientParamsAnnotation)), annotationName);
        paramFillersByName.putAll(methodLevelParamsByName);
    }

    private void putAllParamAnnotations(Map<String, ParamData> paramMap, ClassInfo interfaceClass, AnnotationInstance[] annotations, String annotationName) {
        for (AnnotationInstance annotation : annotations) {
            String name = annotation.value("name").asString();
            if (paramMap.put(name, new ParamData(annotation, interfaceClass)) == null) continue;
            throw new RestClientDefinitionException("Duplicate " + annotationName + " annotation for parameter: " + name + " on " + annotation.target());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addParam(MethodInfo declaringMethod, MethodCreator methodCreator, ParamData paramData, BuildProducer<GeneratedClassBuildItem> generatedClasses, IndexView index, DotName clientParamAnnotation, String annotationName, String paramName, Supplier<ResultHandle> existenceChecker, BiConsumer<BytecodeCreator, ResultHandle> paramAdder) {
        AnnotationInstance annotation = paramData.annotation;
        ClassInfo declaringClass = paramData.definingClass;
        ResultHandle isParamPresent = existenceChecker.get();
        BytecodeCreator creator = methodCreator.ifTrue(isParamPresent).falseBranch();
        String[] values = annotation.value().asStringArray();
        if (values.length == 0) {
            log.warnv("Ignoring {} that specifies an empty array of values for parameter {} on {}", (Object)annotationName, (Object)annotation.value("name").asString(), (Object)annotation.target());
            return;
        }
        if (values.length > 1 || !values[0].startsWith("{") || !values[0].endsWith("}")) {
            boolean required = annotation.valueWithDefault(index, "required").asBoolean();
            ResultHandle valuesList = creator.newInstance(MethodDescriptor.ofConstructor(ArrayList.class, (Class[])new Class[0]), new ResultHandle[0]);
            for (String value : values) {
                if (value.contains("${")) {
                    ResultHandle paramValueFromConfig = creator.invokeStaticMethod(MethodDescriptor.ofMethod(ConfigUtils.class, (String)"interpolate", String.class, (Class[])new Class[]{String.class, Boolean.TYPE}), new ResultHandle[]{creator.load(value), creator.load(required)});
                    creator.ifNotNull(paramValueFromConfig).trueBranch().invokeInterfaceMethod(LIST_ADD_METHOD, valuesList, new ResultHandle[]{paramValueFromConfig});
                    continue;
                }
                creator.invokeInterfaceMethod(LIST_ADD_METHOD, valuesList, new ResultHandle[]{creator.load(value)});
            }
            paramAdder.accept(creator, valuesList);
            return;
        } else {
            ResultHandle valuesList;
            ResultHandle paramValue;
            MethodInfo paramValueMethod;
            String methodName;
            boolean required = annotation.valueWithDefault(index, "required").asBoolean();
            BytecodeCreator methodCallCreator = creator;
            TryBlock tryBlock = null;
            if (!required) {
                tryBlock = creator.tryBlock();
                methodCallCreator = tryBlock;
            }
            if ((methodName = values[0].substring(1, values[0].length() - 1)).contains(".")) {
                int endOfClassName = methodName.lastIndexOf(46);
                String className = methodName.substring(0, endOfClassName);
                String staticMethodName = methodName.substring(endOfClassName + 1);
                ClassInfo clazz = index.getClassByName(DotName.createSimple((String)className));
                if (clazz == null) {
                    throw new RestClientDefinitionException("Class " + className + " used in " + annotationName + " on " + declaringClass + " not found");
                }
                paramValueMethod = this.findMethod(clazz, declaringClass, staticMethodName, clientParamAnnotation.toString());
                if (paramValueMethod.parametersCount() == 0) {
                    paramValue = methodCallCreator.invokeStaticMethod(paramValueMethod, new ResultHandle[0]);
                } else {
                    if (paramValueMethod.parametersCount() != 1 || !MicroProfileRestClientEnricher.isString(paramValueMethod.parameterType(0))) throw new RestClientDefinitionException(annotationName + " method " + declaringClass.toString() + "#" + staticMethodName + " has too many parameters, at most one parameter, param name, expected");
                    paramValue = methodCallCreator.invokeStaticMethod(paramValueMethod, new ResultHandle[]{methodCallCreator.load(paramName)});
                }
            } else {
                String mockName = this.mockInterface(declaringClass, generatedClasses, index);
                ResultHandle interfaceMock = methodCallCreator.newInstance(MethodDescriptor.ofConstructor((String)mockName, (String[])new String[0]), new ResultHandle[0]);
                paramValueMethod = this.findMethod(declaringClass, declaringClass, methodName, clientParamAnnotation.toString());
                if (paramValueMethod == null) {
                    throw new RestClientDefinitionException(annotationName + " method " + methodName + " not found on " + declaringClass);
                }
                if (paramValueMethod.parametersCount() == 0) {
                    paramValue = methodCallCreator.invokeInterfaceMethod(paramValueMethod, interfaceMock, new ResultHandle[0]);
                } else {
                    if (paramValueMethod.parametersCount() != 1 || !MicroProfileRestClientEnricher.isString(paramValueMethod.parameterType(0))) throw new RestClientDefinitionException(annotationName + " method " + declaringClass + "#" + methodName + " has too many parameters, at most one parameter, param name, expected");
                    paramValue = methodCallCreator.invokeInterfaceMethod(paramValueMethod, interfaceMock, new ResultHandle[]{methodCallCreator.load(paramName)});
                }
            }
            Type returnType = paramValueMethod.returnType();
            if (MicroProfileRestClientEnricher.isStringArray(returnType)) {
                valuesList = methodCallCreator.invokeStaticMethod(ARRAYS_AS_LIST, new ResultHandle[]{paramValue});
            } else {
                if (!MicroProfileRestClientEnricher.isString(returnType)) throw new RestClientDefinitionException("Method " + declaringClass.toString() + "#" + methodName + " has an unsupported return type for " + annotationName + ". Only String and String[] return types are supported");
                valuesList = methodCallCreator.newInstance(MethodDescriptor.ofConstructor(ArrayList.class, (Class[])new Class[0]), new ResultHandle[0]);
                methodCallCreator.invokeInterfaceMethod(LIST_ADD_METHOD, valuesList, new ResultHandle[]{paramValue});
            }
            paramAdder.accept(methodCallCreator, valuesList);
            if (required) return;
            CatchBlockCreator catchBlock = tryBlock.addCatch(Exception.class);
            ResultHandle log = catchBlock.invokeStaticMethod(MethodDescriptor.ofMethod(Logger.class, (String)"getLogger", Logger.class, (Class[])new Class[]{String.class}), new ResultHandle[]{catchBlock.load(declaringClass.name().toString())});
            String errorMessage = String.format("Invoking param generation method '%s' for '%s' on method '%s#%s' failed", methodName, paramName, declaringClass.name(), declaringMethod.name());
            catchBlock.invokeVirtualMethod(MethodDescriptor.ofMethod(Logger.class, (String)"warn", Void.TYPE, (Class[])new Class[]{Object.class, Throwable.class}), log, new ResultHandle[]{catchBlock.load(errorMessage), catchBlock.getCaughtException()});
        }
    }

    public void forSubResourceMethod(ClassCreator subClassCreator, MethodCreator subConstructor, MethodCreator subClinit, MethodCreator subMethodCreator, ClassInfo rootInterfaceClass, ClassInfo subInterfaceClass, MethodInfo subMethod, MethodInfo rootMethod, AssignableResultHandle invocationBuilder, IndexView index, BuildProducer<GeneratedClassBuildItem> generatedClasses, int methodIndex, int subMethodIndex, FieldDescriptor javaMethodField) {
        this.addJavaMethodToContext(javaMethodField, subMethodCreator, invocationBuilder);
        HashMap<String, ParamData> headerFillersByName = new HashMap<String, ParamData>();
        this.collectHeaderFillers(rootInterfaceClass, rootMethod, headerFillersByName);
        this.collectHeaderFillers(subInterfaceClass, subMethod, headerFillersByName);
        String subHeaderFillerName = subInterfaceClass.name().toString() + org.jboss.resteasy.reactive.common.processor.HashUtil.sha1((String)rootInterfaceClass.name().toString()) + "$$" + methodIndex + "$$" + subMethodIndex;
        this.createAndReturnHeaderFiller(subClassCreator, subConstructor, subMethodCreator, subMethod, invocationBuilder, index, generatedClasses, subMethodIndex, subHeaderFillerName, headerFillersByName);
    }

    public void forMethod(ClassCreator classCreator, MethodCreator constructor, MethodCreator clinit, MethodCreator methodCreator, ClassInfo interfaceClass, MethodInfo method, AssignableResultHandle invocationBuilder, IndexView index, BuildProducer<GeneratedClassBuildItem> generatedClasses, int methodIndex, FieldDescriptor javaMethodField) {
        this.addJavaMethodToContext(javaMethodField, methodCreator, invocationBuilder);
        HashMap<String, ParamData> headerFillersByName = new HashMap<String, ParamData>();
        this.collectHeaderFillers(interfaceClass, method, headerFillersByName);
        this.createAndReturnHeaderFiller(classCreator, constructor, methodCreator, method, invocationBuilder, index, generatedClasses, methodIndex, interfaceClass + "$$" + method.name() + "$$" + methodIndex, headerFillersByName);
    }

    private void createAndReturnHeaderFiller(ClassCreator classCreator, MethodCreator constructor, MethodCreator methodCreator, MethodInfo method, AssignableResultHandle invocationBuilder, IndexView index, BuildProducer<GeneratedClassBuildItem> generatedClasses, int methodIndex, String fillerClassName, Map<String, ParamData> headerFillersByName) {
        ResultHandle headerFiller;
        FieldDescriptor headerFillerField = FieldDescriptor.of((String)classCreator.getClassName(), (String)("headerFiller" + methodIndex), HeaderFiller.class);
        classCreator.getFieldCreator(headerFillerField).setModifiers(18);
        if (!headerFillersByName.isEmpty()) {
            GeneratedClassGizmoAdaptor classOutput = new GeneratedClassGizmoAdaptor(generatedClasses, true);
            try (ClassCreator headerFillerClass = ClassCreator.builder().className(fillerClassName).interfaces(new Class[]{ExtendedHeaderFiller.class}).classOutput((ClassOutput)classOutput).build();){
                FieldCreator logField = headerFillerClass.getFieldCreator("log", Logger.class);
                logField.setModifiers(26);
                MethodCreator staticConstructor = headerFillerClass.getMethodCreator("<clinit>", Void.TYPE, new Class[0]);
                staticConstructor.setModifiers(8);
                ResultHandle log = staticConstructor.invokeStaticMethod(MethodDescriptor.ofMethod(Logger.class, (String)"getLogger", Logger.class, (Class[])new Class[]{String.class}), new ResultHandle[]{staticConstructor.load(fillerClassName)});
                staticConstructor.writeStaticField(logField.getFieldDescriptor(), log);
                staticConstructor.returnValue(null);
                MethodCreator fillHeaders = headerFillerClass.getMethodCreator(MethodDescriptor.ofMethod(HeaderFiller.class, (String)"addHeaders", Void.TYPE, (Class[])new Class[]{MultivaluedMap.class, ResteasyReactiveClientRequestContext.class}));
                for (Map.Entry<String, ParamData> headerEntry : headerFillersByName.entrySet()) {
                    this.addHeaderParam(method, fillHeaders, headerEntry.getValue(), generatedClasses, fillerClassName, index);
                }
                fillHeaders.returnValue(null);
                headerFiller = constructor.newInstance(MethodDescriptor.ofConstructor((String)fillerClassName, (String[])new String[0]), new ResultHandle[0]);
            }
        } else {
            headerFiller = constructor.readStaticField(FieldDescriptor.of(NoOpHeaderFiller.class, (String)"INSTANCE", NoOpHeaderFiller.class));
        }
        constructor.writeInstanceField(headerFillerField, constructor.getThis(), headerFiller);
        ResultHandle headerFillerAsObject = methodCreator.checkCast(methodCreator.readInstanceField(headerFillerField, methodCreator.getThis()), Object.class);
        methodCreator.assign(invocationBuilder, methodCreator.invokeInterfaceMethod(INVOCATION_BUILDER_PROPERTY_METHOD, (ResultHandle)invocationBuilder, new ResultHandle[]{methodCreator.load(HeaderFiller.class.getName()), headerFillerAsObject}));
        ResultHandle parametersList = null;
        if (method.parametersCount() == 0) {
            parametersList = methodCreator.invokeStaticMethod(MethodDescriptor.ofMethod(Collections.class, (String)"emptyList", List.class, (Class[])new Class[0]), new ResultHandle[0]);
        } else {
            ResultHandle parametersArray = methodCreator.newArray(Object.class, method.parametersCount());
            for (int i = 0; i < method.parametersCount(); ++i) {
                methodCreator.writeArrayValue(parametersArray, i, methodCreator.getMethodParam(i));
            }
            parametersList = methodCreator.invokeStaticMethod(ARRAYS_AS_LIST, new ResultHandle[]{parametersArray});
        }
        methodCreator.assign(invocationBuilder, methodCreator.invokeInterfaceMethod(INVOCATION_BUILDER_PROPERTY_METHOD, (ResultHandle)invocationBuilder, new ResultHandle[]{methodCreator.load("io.quarkus.rest.client.invokedMethodParameters"), parametersList}));
    }

    private void collectHeaderFillers(ClassInfo interfaceClass, MethodInfo method, Map<String, ParamData> headerFillersByName) {
        AnnotationInstance classLevelHeader = interfaceClass.declaredAnnotation(DotNames.CLIENT_HEADER_PARAM);
        if (classLevelHeader != null) {
            headerFillersByName.put(classLevelHeader.value("name").asString(), new ParamData(classLevelHeader, interfaceClass));
        }
        this.putAllHeaderAnnotations(headerFillersByName, interfaceClass, this.extractAnnotations(interfaceClass.declaredAnnotation(DotNames.CLIENT_HEADER_PARAMS)));
        HashMap<String, ParamData> methodLevelHeadersByName = new HashMap<String, ParamData>();
        AnnotationInstance methodLevelHeader = method.annotation(DotNames.CLIENT_HEADER_PARAM);
        if (methodLevelHeader != null) {
            methodLevelHeadersByName.put(methodLevelHeader.value("name").asString(), new ParamData(methodLevelHeader, interfaceClass));
        }
        this.putAllHeaderAnnotations(methodLevelHeadersByName, interfaceClass, this.extractAnnotations(method.annotation(DotNames.CLIENT_HEADER_PARAMS)));
        headerFillersByName.putAll(methodLevelHeadersByName);
    }

    private void addJavaMethodToContext(FieldDescriptor javaMethodField, MethodCreator methodCreator, AssignableResultHandle invocationBuilder) {
        ResultHandle javaMethod = methodCreator.readStaticField(javaMethodField);
        ResultHandle javaMethodAsObject = methodCreator.checkCast(javaMethod, Object.class);
        methodCreator.assign(invocationBuilder, methodCreator.invokeInterfaceMethod(INVOCATION_BUILDER_PROPERTY_METHOD, (ResultHandle)invocationBuilder, new ResultHandle[]{methodCreator.load("org.eclipse.microprofile.rest.client.invokedMethod"), javaMethodAsObject}));
    }

    private void putAllHeaderAnnotations(Map<String, ParamData> headerMap, ClassInfo interfaceClass, AnnotationInstance[] annotations) {
        for (AnnotationInstance annotation : annotations) {
            String headerName = annotation.value("name").asString();
            if (headerMap.put(headerName, new ParamData(annotation, interfaceClass)) == null) continue;
            throw new RestClientDefinitionException("Duplicate ClientHeaderParam annotation for header: " + headerName + " on " + annotation.target());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addHeaderParam(MethodInfo declaringMethod, MethodCreator fillHeadersCreator, ParamData paramData, final BuildProducer<GeneratedClassBuildItem> generatedClasses, String fillerClassName, final IndexView index) {
        AnnotationInstance annotation = paramData.annotation;
        final ClassInfo declaringClass = paramData.definingClass;
        final String headerName = annotation.value("name").asString();
        String[] values = annotation.value().asStringArray();
        if (values.length == 0) {
            log.warnv("Ignoring ClientHeaderParam that specifies an empty array of header values for header {0} on {1}", (Object)annotation.value("name").asString(), (Object)annotation.target());
            return;
        }
        ResultHandle headerMap = fillHeadersCreator.getMethodParam(0);
        final ResultHandle requestContext = fillHeadersCreator.getMethodParam(1);
        BytecodeCreator fillHeaders = fillHeadersCreator.ifTrue(fillHeadersCreator.invokeStaticMethod(HEADER_FILLER_UTIL_SHOULD_ADD_HEADER, new ResultHandle[]{fillHeadersCreator.load(headerName), headerMap, requestContext})).trueBranch();
        if (values.length > 1) {
            boolean required = annotation.valueWithDefault(index, "required").asBoolean();
            ResultHandle headerList = Gizmo.newArrayList((BytecodeCreator)fillHeaders, (int)1);
            for (String value : values) {
                if (value.contains("${")) {
                    ResultHandle headerValueFromConfig = fillHeaders.invokeStaticMethod(MethodDescriptor.ofMethod(ConfigUtils.class, (String)"interpolate", String.class, (Class[])new Class[]{String.class, Boolean.TYPE}), new ResultHandle[]{fillHeaders.load(value), fillHeaders.load(required)});
                    fillHeaders.ifNotNull(headerValueFromConfig).trueBranch().invokeInterfaceMethod(LIST_ADD_METHOD, headerList, new ResultHandle[]{headerValueFromConfig});
                    continue;
                }
                fillHeaders.invokeInterfaceMethod(LIST_ADD_METHOD, headerList, new ResultHandle[]{fillHeaders.load(value)});
            }
            fillHeaders.invokeInterfaceMethod(MAP_PUT_METHOD, headerMap, new ResultHandle[]{fillHeaders.load(headerName), headerList});
            return;
        } else {
            BytecodeCreator fillHeader;
            TryBlock tryBlock;
            List<RestClientAnnotationExpressionParser.Node> nodes = new RestClientAnnotationExpressionParser(values[0], declaringMethod.declaringClass().name().toString() + "#" + declaringMethod.name()).parse();
            final boolean required = annotation.valueWithDefault(index, "required").asBoolean();
            if (required) {
                tryBlock = null;
                fillHeader = fillHeaders;
            } else {
                tryBlock = fillHeaders.tryBlock();
                fillHeader = tryBlock;
            }
            List headerFillerInfos = nodes.stream().map(n -> {
                if (n instanceof RestClientAnnotationExpressionParser.Verbatim) {
                    return new HeaderFillerInfo(STRING_TYPE, (RestClientAnnotationExpressionParser.Node)n, new Supplier<ResultHandle>(){

                        @Override
                        public ResultHandle get() {
                            return fillHeader.load(n.getValue());
                        }
                    });
                }
                if (n instanceof RestClientAnnotationExpressionParser.ConfigName) {
                    return new HeaderFillerInfo(STRING_TYPE, (RestClientAnnotationExpressionParser.Node)n, new Supplier<ResultHandle>(){

                        @Override
                        public ResultHandle get() {
                            return fillHeader.invokeStaticMethod(MethodDescriptor.ofMethod(ConfigUtils.class, (String)"doGetConfigValue", String.class, (Class[])new Class[]{String.class, Boolean.TYPE, String.class}), new ResultHandle[]{fillHeader.load("${" + n.getValue() + "}"), fillHeader.load(required), fillHeader.load(n.getValue())});
                        }
                    });
                }
                if (n instanceof RestClientAnnotationExpressionParser.Accessible) {
                    Supplier<ResultHandle> supplier;
                    MethodInfo headerFillingMethod;
                    AccessibleType accessibleType;
                    String accessibleName = n.getValue();
                    AccessibleType accessibleType2 = accessibleType = accessibleName.contains(".") ? AccessibleType.STATIC_METHOD : AccessibleType.INTERFACE_METHOD;
                    if (accessibleType == AccessibleType.STATIC_METHOD) {
                        int endOfClassName = accessibleName.lastIndexOf(46);
                        String className = accessibleName.substring(0, endOfClassName);
                        String staticMethodName = accessibleName.substring(endOfClassName + 1);
                        ClassInfo clazz = index.getClassByName(DotName.createSimple((String)className));
                        if (clazz == null) {
                            throw new RestClientDefinitionException(String.format("Invalid %s definition, unable to determine class %s. Problematic interface: %s", DotNames.CLIENT_HEADER_PARAM, className, declaringClass));
                        }
                        headerFillingMethod = this.findMethod(clazz, declaringClass, staticMethodName, DotNames.CLIENT_HEADER_PARAM.toString());
                    } else if (accessibleType == AccessibleType.INTERFACE_METHOD) {
                        headerFillingMethod = this.findMethod(declaringClass, declaringClass, accessibleName, DotNames.CLIENT_HEADER_PARAM.toString());
                    } else {
                        throw new IllegalStateException("Unknown type " + accessibleType);
                    }
                    Type valueType = null;
                    final AtomicInteger parameterPosition = new AtomicInteger(-1);
                    if (headerFillingMethod == null) {
                        for (MethodParameterInfo parameter : declaringMethod.parameters()) {
                            if (!accessibleName.equals(parameter.name())) continue;
                            if (!MicroProfileRestClientEnricher.isString(parameter.type())) {
                                throw new RestClientDefinitionException(String.format("Invalid %s definition, method parameter %s is not of String type. Problematic interface: %s", DotNames.CLIENT_HEADER_PARAM, accessibleName, declaringClass));
                            }
                            accessibleType = AccessibleType.METHOD_PARAMETER;
                            valueType = parameter.type();
                            parameterPosition.set(parameter.position());
                            break;
                        }
                        if (valueType == null) {
                            throw new RestClientDefinitionException(String.format("Invalid %s definition, unable to determine target method '%s'. Problematic interface: %s", DotNames.CLIENT_HEADER_PARAM, accessibleName, declaringClass));
                        }
                    } else {
                        valueType = headerFillingMethod.returnType();
                    }
                    if (accessibleType == AccessibleType.STATIC_METHOD) {
                        supplier = new Supplier<ResultHandle>(){

                            @Override
                            public ResultHandle get() {
                                if (headerFillingMethod.parametersCount() == 0) {
                                    return fillHeader.invokeStaticMethod(headerFillingMethod, new ResultHandle[0]);
                                }
                                if (headerFillingMethod.parametersCount() == 1 && MicroProfileRestClientEnricher.isString(headerFillingMethod.parameterType(0))) {
                                    return fillHeader.invokeStaticMethod(headerFillingMethod, new ResultHandle[]{fillHeader.load(headerName)});
                                }
                                if (headerFillingMethod.parametersCount() == 1 && MicroProfileRestClientEnricher.isComputedParamContext(headerFillingMethod.parameterType(0))) {
                                    ResultHandle fillerParam = fillHeader.newInstance(COMPUTER_PARAM_CONTEXT_IMPL_CTOR, new ResultHandle[]{fillHeader.load(headerName), requestContext});
                                    return fillHeader.invokeStaticMethod(headerFillingMethod, new ResultHandle[]{fillerParam});
                                }
                                throw new RestClientDefinitionException("@ClientHeaderParam method " + headerFillingMethod.declaringClass().toString() + "#" + headerFillingMethod.name() + " has too many parameters, at most one parameter, header name, expected");
                            }
                        };
                    } else if (accessibleType == AccessibleType.INTERFACE_METHOD) {
                        supplier = new Supplier<ResultHandle>(){

                            @Override
                            public ResultHandle get() {
                                String mockName = MicroProfileRestClientEnricher.this.mockInterface(declaringClass, (BuildProducer<GeneratedClassBuildItem>)generatedClasses, index);
                                ResultHandle interfaceMock = fillHeader.newInstance(MethodDescriptor.ofConstructor((String)mockName, (String[])new String[0]), new ResultHandle[0]);
                                if (headerFillingMethod.parametersCount() == 0) {
                                    return fillHeader.invokeInterfaceMethod(headerFillingMethod, interfaceMock, new ResultHandle[0]);
                                }
                                if (headerFillingMethod.parametersCount() == 1 && MicroProfileRestClientEnricher.isString(headerFillingMethod.parameterType(0))) {
                                    return fillHeader.invokeInterfaceMethod(headerFillingMethod, interfaceMock, new ResultHandle[]{fillHeader.load(headerName)});
                                }
                                if (headerFillingMethod.parametersCount() == 1 && MicroProfileRestClientEnricher.isComputedParamContext(headerFillingMethod.parameterType(0))) {
                                    ResultHandle fillerParam = fillHeader.newInstance(COMPUTER_PARAM_CONTEXT_IMPL_CTOR, new ResultHandle[]{fillHeader.load(headerName), requestContext});
                                    return fillHeader.invokeInterfaceMethod(headerFillingMethod, interfaceMock, new ResultHandle[]{fillerParam});
                                }
                                throw new RestClientDefinitionException("@ClientHeaderParam method " + headerFillingMethod.declaringClass().toString() + "#" + headerFillingMethod.name() + " has too many parameters, at most one parameter, header name, expected");
                            }
                        };
                    } else if (accessibleType == AccessibleType.METHOD_PARAMETER) {
                        supplier = new Supplier<ResultHandle>(){

                            @Override
                            public ResultHandle get() {
                                return fillHeader.invokeStaticMethod(COMPUTER_PARAM_CONTEXT_IMPL_GET_METHOD_PARAM, new ResultHandle[]{requestContext, fillHeader.load(parameterPosition.get())});
                            }
                        };
                    } else {
                        throw new IllegalStateException("Unknown type " + accessibleType);
                    }
                    if (nodes.size() == 1) {
                        if (!MicroProfileRestClientEnricher.isString(valueType) && !MicroProfileRestClientEnricher.isStringArray(valueType)) {
                            throw new RestClientDefinitionException("Method " + headerFillingMethod.declaringClass().toString() + "#" + headerFillingMethod.name() + " has an unsupported return type for ClientHeaderParam. Only String and String[] return types are supported");
                        }
                    } else if (!MicroProfileRestClientEnricher.isString(valueType)) {
                        throw new RestClientDefinitionException("Method " + headerFillingMethod.declaringClass().toString() + "#" + headerFillingMethod.name() + " has an unsupported return type for ClientHeaderParam. Only String is supported when using complex expressions");
                    }
                    return new HeaderFillerInfo(valueType, (RestClientAnnotationExpressionParser.Node)n, supplier);
                }
                throw new IllegalStateException("Unknown node type " + n.getClass().getName());
            }).collect(Collectors.toList());
            AssignableResultHandle headerList = fillHeader.createVariable(List.class);
            fillHeader.assign(headerList, fillHeader.loadNull());
            if (headerFillerInfos.size() == 1) {
                HeaderFillerInfo headerFillerInfo = (HeaderFillerInfo)headerFillerInfos.get(0);
                ResultHandle headerFillerResult = headerFillerInfo.getResultHandleSupplier().get();
                BytecodeCreator notNullBranchTrue = fillHeader.ifNotNull(headerFillerResult).trueBranch();
                Type headerFillerMethodReturnType = headerFillerInfo.getValueType();
                if (MicroProfileRestClientEnricher.isStringArray(headerFillerMethodReturnType)) {
                    ResultHandle asList = notNullBranchTrue.invokeStaticMethod(ARRAYS_AS_LIST, new ResultHandle[]{headerFillerResult});
                    notNullBranchTrue.assign(headerList, asList);
                } else {
                    if (!MicroProfileRestClientEnricher.isString(headerFillerMethodReturnType)) throw new IllegalStateException("Unhandled type: " + headerFillerMethodReturnType);
                    notNullBranchTrue.assign(headerList, Gizmo.newArrayList((BytecodeCreator)notNullBranchTrue, (int)1));
                    notNullBranchTrue.invokeInterfaceMethod(LIST_ADD_METHOD, (ResultHandle)headerList, new ResultHandle[]{headerFillerResult});
                }
            } else {
                ResultHandle nonNullValuesList = Gizmo.newArrayList((BytecodeCreator)fillHeader, (int)headerFillerInfos.size());
                for (HeaderFillerInfo headerFillerInfo : headerFillerInfos) {
                    if (!MicroProfileRestClientEnricher.isString(headerFillerInfo.getValueType())) {
                        throw new IllegalStateException("Unhandled type: " + headerFillerInfo.getValueType());
                    }
                    ResultHandle value = headerFillerInfo.getResultHandleSupplier().get();
                    BytecodeCreator notNullBranch = fillHeader.ifNotNull(value).trueBranch();
                    notNullBranch.invokeInterfaceMethod(LIST_ADD_METHOD, nonNullValuesList, new ResultHandle[]{value});
                }
                ResultHandle sb = fillHeader.newInstance(MethodDescriptor.ofConstructor(StringBuilder.class, (Class[])new Class[0]), new ResultHandle[0]);
                ForEachLoop loop = fillHeader.forEach(nonNullValuesList);
                BytecodeCreator block = loop.block();
                block.invokeVirtualMethod(STRING_BUILDER_APPEND, sb, new ResultHandle[]{loop.element()});
                ResultHandle stringValue = Gizmo.toString((BytecodeCreator)fillHeader, (ResultHandle)sb);
                ResultHandle stringValueLength = fillHeader.invokeVirtualMethod(STRING_LENGTH, stringValue, new ResultHandle[0]);
                BytecodeCreator notEmptyStringBranchTrue = fillHeader.ifNonZero(stringValueLength).trueBranch();
                notEmptyStringBranchTrue.assign(headerList, Gizmo.newArrayList((BytecodeCreator)notEmptyStringBranchTrue, (int)1));
                notEmptyStringBranchTrue.invokeInterfaceMethod(LIST_ADD_METHOD, (ResultHandle)headerList, new ResultHandle[]{stringValue});
            }
            BytecodeCreator headerListNotNull = fillHeader.ifNotNull((ResultHandle)headerList).trueBranch();
            headerListNotNull.invokeInterfaceMethod(MAP_PUT_METHOD, headerMap, new ResultHandle[]{headerListNotNull.load(headerName), headerList});
            if (required) return;
            CatchBlockCreator catchBlock = tryBlock.addCatch(Exception.class);
            ResultHandle log = catchBlock.readStaticField(FieldDescriptor.of((String)fillerClassName, (String)"log", Logger.class));
            String errorMessage = String.format("Invoking header for header '%s' failed", headerName);
            catchBlock.invokeVirtualMethod(MethodDescriptor.ofMethod(Logger.class, (String)"warn", Void.TYPE, (Class[])new Class[]{Object.class, Throwable.class}), log, new ResultHandle[]{catchBlock.load(errorMessage), catchBlock.getCaughtException()});
        }
    }

    private MethodInfo findMethod(ClassInfo declaringClass, ClassInfo restInterface, String methodName, String sourceAnnotationName) {
        MethodInfo result = null;
        for (MethodInfo method : declaringClass.methods()) {
            if (!method.name().equals(methodName)) continue;
            if (result != null) {
                throw new RestClientDefinitionException(String.format("Ambiguous %s definition, more than one method of name %s found on %s. Problematic interface: %s", sourceAnnotationName, methodName, declaringClass, restInterface));
            }
            result = method;
        }
        return result;
    }

    private static boolean isString(Type type) {
        return type.kind() == Type.Kind.CLASS && type.name().toString().equals(String.class.getName());
    }

    private static boolean isStringArray(Type returnType) {
        return returnType.kind() == Type.Kind.ARRAY && returnType.asArrayType().constituent().name().equals((Object)io.quarkus.arc.processor.DotNames.STRING);
    }

    private static boolean isComputedParamContext(Type type) {
        return type.kind() == Type.Kind.CLASS && type.name().toString().equals(ComputedParamContext.class.getName());
    }

    private String mockInterface(ClassInfo declaringClass, BuildProducer<GeneratedClassBuildItem> generatedClass, IndexView index) {
        return this.interfaceMocks.computeIfAbsent(declaringClass, classInfo -> {
            String mockName = declaringClass.toString() + HashUtil.sha1((String)declaringClass.toString());
            GeneratedClassGizmoAdaptor classOutput = new GeneratedClassGizmoAdaptor(generatedClass, true);
            List interfaceNames = declaringClass.interfaceNames();
            HashSet methods = new HashSet();
            for (DotName interfaceName : interfaceNames) {
                ClassInfo interfaceClass = index.getClassByName(interfaceName);
                methods.addAll(interfaceClass.methods());
            }
            methods.addAll(declaringClass.methods());
            try (ClassCreator classCreator = ClassCreator.builder().className(mockName).interfaces(new String[]{declaringClass.toString()}).classOutput((ClassOutput)classOutput).build();){
                for (MethodInfo method : methods) {
                    if (!Modifier.isAbstract(method.flags())) continue;
                    MethodCreator methodCreator = classCreator.getMethodCreator(MethodDescriptor.of((MethodInfo)method));
                    methodCreator.throwException(IllegalStateException.class, "This should never be called");
                }
            }
            return mockName;
        });
    }

    private AnnotationInstance[] extractAnnotations(AnnotationInstance groupAnnotation) {
        AnnotationValue annotationValue;
        if (groupAnnotation != null && (annotationValue = groupAnnotation.value()) != null) {
            return annotationValue.asNestedArray();
        }
        return EMPTY_ANNOTATION_INSTANCES;
    }

    private static class ParamData {
        private final AnnotationInstance annotation;
        private final ClassInfo definingClass;

        public ParamData(AnnotationInstance annotation, ClassInfo definingClass) {
            this.annotation = annotation;
            this.definingClass = definingClass;
        }
    }

    static class RestClientAnnotationExpressionParser {
        private final String input;
        private final String sourceMethod;

        RestClientAnnotationExpressionParser(String input, String sourceMethod) {
            this.input = Objects.requireNonNull(input);
            this.sourceMethod = sourceMethod;
        }

        List<Node> parse() {
            int i = 0;
            int configStart = -1;
            int accessibleStart = -1;
            int verbatimStart = -1;
            ArrayList<Node> nodes = new ArrayList<Node>();
            while (i < this.input.length()) {
                char c = this.input.charAt(i);
                if (c == '$') {
                    if (configStart != -1 || accessibleStart != -1) {
                        throw new IllegalArgumentException(this.createEffectiveErrorMessage("Cannot mix expressions"));
                    }
                    if (i == this.input.length() - 1) {
                        throw new IllegalArgumentException(this.createEffectiveErrorMessage("Illegal end of expression"));
                    }
                    if (this.input.charAt(i + 1) != '{') {
                        throw new IllegalArgumentException(this.createEffectiveErrorMessage("'$' must always be followed by '{'"));
                    }
                    if (verbatimStart != -1) {
                        nodes.add(new Verbatim(this.input.substring(verbatimStart, i)));
                    }
                    configStart = i += 2;
                    verbatimStart = -1;
                    continue;
                }
                if (c == '{') {
                    if (configStart != -1 || accessibleStart != -1) {
                        throw new IllegalArgumentException(this.createEffectiveErrorMessage("Cannot mix expressions"));
                    }
                    if (i == this.input.length() - 1) {
                        throw new IllegalArgumentException(this.createEffectiveErrorMessage("Illegal end of expression"));
                    }
                    if (verbatimStart != -1) {
                        nodes.add(new Verbatim(this.input.substring(verbatimStart, i)));
                    }
                    accessibleStart = ++i;
                    verbatimStart = -1;
                    continue;
                }
                if (c == '}') {
                    if (configStart == -1 && accessibleStart == -1) {
                        throw new IllegalArgumentException(this.createEffectiveErrorMessage("Illegal end of expression"));
                    }
                    if (configStart != -1) {
                        nodes.add(new ConfigName(this.input.substring(configStart, i)));
                    } else {
                        nodes.add(new Accessible(this.input.substring(accessibleStart, i)));
                    }
                    configStart = -1;
                    accessibleStart = -1;
                    ++i;
                    continue;
                }
                if (verbatimStart == -1 && configStart == -1 && accessibleStart == -1) {
                    verbatimStart = i;
                }
                ++i;
            }
            if (verbatimStart != -1) {
                nodes.add(new Verbatim(this.input.substring(verbatimStart)));
            }
            return nodes;
        }

        private String createEffectiveErrorMessage(String errorMessage) {
            return "Invalid REST Client annotation value expression '" + this.input + "'" + (String)(this.sourceMethod != null ? "found on method '" + this.sourceMethod + "'" : "") + ". Error is : '" + errorMessage + "'";
        }

        static class Verbatim
        extends Node {
            Verbatim(String value) {
                super(value);
            }

            public String toString() {
                return "Verbatim{value='" + this.value + "'}";
            }
        }

        static class ConfigName
        extends Node {
            ConfigName(String value) {
                super(value);
            }

            public String toString() {
                return "ConfigName{value='" + this.value + "'}";
            }
        }

        static class Accessible
        extends Node {
            Accessible(String value) {
                super(value);
            }

            public String toString() {
                return "Accessible{value='" + this.value + "'}";
            }
        }

        static abstract class Node {
            protected final String value;

            Node(String value) {
                this.value = Objects.requireNonNull(value);
            }

            String getValue() {
                return this.value;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (!(o instanceof Node)) {
                    return false;
                }
                Node node = (Node)o;
                return Objects.equals(this.value, node.value);
            }

            public int hashCode() {
                return Objects.hash(this.value);
            }
        }
    }

    private static class HeaderFillerInfo {
        private final Type valueType;
        private final Supplier<ResultHandle> resultHandleSupplier;
        private final RestClientAnnotationExpressionParser.Node source;

        HeaderFillerInfo(Type valueType, RestClientAnnotationExpressionParser.Node source, Supplier<ResultHandle> resultHandleSupplier) {
            this.valueType = valueType;
            this.source = source;
            this.resultHandleSupplier = resultHandleSupplier;
        }

        Type getValueType() {
            return this.valueType;
        }

        Supplier<ResultHandle> getResultHandleSupplier() {
            return this.resultHandleSupplier;
        }

        HeaderFillerInfo mapResultHandle(Function<Supplier<ResultHandle>, Supplier<ResultHandle>> mapper) {
            return new HeaderFillerInfo(this.valueType, this.source, mapper.apply(this.resultHandleSupplier));
        }
    }

    static enum AccessibleType {
        INTERFACE_METHOD,
        STATIC_METHOD,
        METHOD_PARAMETER;

    }
}

