/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.rest.client.reactive.jackson.runtime.serialisers;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import javax.inject.Inject;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import org.jboss.resteasy.reactive.client.impl.RestClientRequestContext;
import org.jboss.resteasy.reactive.client.spi.ClientRestHandler;
import org.jboss.resteasy.reactive.server.jackson.JacksonMessageBodyWriterUtil;

public class ClientJacksonMessageBodyWriter
implements MessageBodyWriter<Object>,
ClientRestHandler {
    protected final ObjectMapper originalMapper;
    protected final ObjectWriter defaultWriter;
    private final ConcurrentMap<ObjectMapper, ObjectWriter> contextResolverMap = new ConcurrentHashMap<ObjectMapper, ObjectWriter>();
    private RestClientRequestContext context;

    @Inject
    public ClientJacksonMessageBodyWriter(ObjectMapper mapper) {
        this.originalMapper = mapper;
        this.defaultWriter = JacksonMessageBodyWriterUtil.createDefaultWriter((ObjectMapper)mapper);
    }

    public boolean isWriteable(Class type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return true;
    }

    public void writeTo(Object o, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        JacksonMessageBodyWriterUtil.doLegacyWrite((Object)o, (Annotation[])annotations, httpHeaders, (OutputStream)entityStream, (ObjectWriter)this.getEffectiveWriter());
    }

    public void handle(RestClientRequestContext requestContext) throws Exception {
        this.context = this.context;
    }

    protected ObjectWriter getEffectiveWriter() {
        if (this.context == null) {
            return this.defaultWriter;
        }
        ObjectMapper objectMapper = (ObjectMapper)this.context.getConfiguration().getFromContext(ObjectMapper.class);
        if (objectMapper == null) {
            return this.defaultWriter;
        }
        return this.contextResolverMap.computeIfAbsent(objectMapper, new Function<ObjectMapper, ObjectWriter>(){

            @Override
            public ObjectWriter apply(ObjectMapper objectMapper) {
                return JacksonMessageBodyWriterUtil.createDefaultWriter((ObjectMapper)objectMapper);
            }
        });
    }
}

