/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.rest.client.reactive.jackson.runtime.serialisers;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import io.quarkus.rest.client.reactive.jackson.runtime.serialisers.JacksonUtil;
import io.quarkus.rest.client.reactive.jackson.runtime.serialisers.ResolverMapKey;
import jakarta.inject.Inject;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import org.jboss.resteasy.reactive.client.impl.RestClientRequestContext;
import org.jboss.resteasy.reactive.client.spi.ClientRestHandler;
import org.jboss.resteasy.reactive.server.jackson.JacksonMessageBodyWriterUtil;

public class ClientJacksonMessageBodyWriter
implements MessageBodyWriter<Object>,
ClientRestHandler {
    protected final ObjectMapper originalMapper;
    protected final ObjectWriter defaultWriter;
    private final ConcurrentMap<ResolverMapKey, ObjectMapper> contextResolverMap = new ConcurrentHashMap<ResolverMapKey, ObjectMapper>();
    private final ConcurrentMap<ObjectMapper, ObjectWriter> objectWriterMap = new ConcurrentHashMap<ObjectMapper, ObjectWriter>();
    private RestClientRequestContext context;

    @Inject
    public ClientJacksonMessageBodyWriter(ObjectMapper mapper) {
        this.originalMapper = mapper;
        this.defaultWriter = JacksonMessageBodyWriterUtil.createDefaultWriter((ObjectMapper)mapper);
    }

    public boolean isWriteable(Class type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return true;
    }

    public void writeTo(Object o, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        JacksonMessageBodyWriterUtil.doLegacyWrite((Object)o, (Annotation[])annotations, httpHeaders, (OutputStream)entityStream, (ObjectWriter)this.getEffectiveWriter(type, mediaType));
    }

    public void handle(RestClientRequestContext requestContext) throws Exception {
        this.context = requestContext;
    }

    protected ObjectWriter getEffectiveWriter(Class<?> type, MediaType responseMediaType) {
        ObjectMapper objectMapper = JacksonUtil.getObjectMapperFromContext(type, responseMediaType, this.context, this.contextResolverMap);
        if (objectMapper == null) {
            return this.defaultWriter;
        }
        return this.objectWriterMap.computeIfAbsent(objectMapper, new Function<ObjectMapper, ObjectWriter>(){

            @Override
            public ObjectWriter apply(ObjectMapper objectMapper) {
                return JacksonMessageBodyWriterUtil.createDefaultWriter((ObjectMapper)objectMapper);
            }
        });
    }
}

