/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.rest.client.reactive.runtime;

import io.netty.handler.codec.http.multipart.HttpPostRequestEncoder;
import io.quarkus.arc.Arc;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.restclient.config.RestClientConfig;
import io.quarkus.restclient.config.RestClientsConfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import org.eclipse.microprofile.rest.client.RestClientBuilder;
import org.eclipse.microprofile.rest.client.ext.QueryParamStyle;

public class RestClientCDIDelegateBuilder<T> {
    private static final String REST_URL_FORMAT = "quarkus.rest-client.%s.url";
    private static final String REST_URI_FORMAT = "quarkus.rest-client.%s.uri";
    private final Class<T> jaxrsInterface;
    private final String baseUriFromAnnotation;
    private final String configKey;
    private final RestClientsConfig configRoot;

    public static <T> T createDelegate(Class<T> jaxrsInterface, String baseUriFromAnnotation, String configKey) {
        return new RestClientCDIDelegateBuilder<T>(jaxrsInterface, baseUriFromAnnotation, configKey).build();
    }

    private RestClientCDIDelegateBuilder(Class<T> jaxrsInterface, String baseUriFromAnnotation, String configKey) {
        this(jaxrsInterface, baseUriFromAnnotation, configKey, RestClientCDIDelegateBuilder.getConfigRoot());
    }

    RestClientCDIDelegateBuilder(Class<T> jaxrsInterface, String baseUriFromAnnotation, String configKey, RestClientsConfig configRoot) {
        this.jaxrsInterface = jaxrsInterface;
        this.baseUriFromAnnotation = baseUriFromAnnotation;
        this.configKey = configKey;
        this.configRoot = configRoot;
    }

    private T build() {
        RestClientBuilder builder = RestClientBuilder.newBuilder();
        return this.build(builder);
    }

    T build(RestClientBuilder builder) {
        this.configureBaseUrl(builder);
        this.configureTimeouts(builder);
        this.configureProviders(builder);
        this.configureSsl(builder);
        this.configureRedirects(builder);
        this.configureQueryParamStyle(builder);
        this.configureProxy(builder);
        this.configureCustomProperties(builder);
        return (T)builder.build(this.jaxrsInterface);
    }

    private void configureCustomProperties(RestClientBuilder builder) {
        Optional<T> connectionTTL;
        Optional<T> poolSize;
        Optional encoder = this.configRoot.multipartPostEncoderMode;
        if (encoder.isPresent()) {
            HttpPostRequestEncoder.EncoderMode mode = HttpPostRequestEncoder.EncoderMode.valueOf((String)((String)encoder.get()).toUpperCase(Locale.ROOT));
            builder.property("io.quarkus.rest.client.multipart-post-encoder-mode", (Object)mode);
        }
        if ((poolSize = RestClientCDIDelegateBuilder.oneOf(this.clientConfigByClassName().connectionPoolSize, this.clientConfigByConfigKey().connectionPoolSize)).isPresent()) {
            builder.property("io.quarkus.rest.client.connection-pool-size", poolSize.get());
        }
        if ((connectionTTL = RestClientCDIDelegateBuilder.oneOf(this.clientConfigByClassName().connectionTTL, this.clientConfigByConfigKey().connectionTTL)).isPresent()) {
            int connectionTTLSeconds = (Integer)connectionTTL.get() / 1000;
            builder.property("io.quarkus.rest.client.connection-ttl", (Object)connectionTTLSeconds);
        }
    }

    private void configureProxy(RestClientBuilder builder) {
        Optional<T> maybeProxy = RestClientCDIDelegateBuilder.oneOf(this.clientConfigByClassName().proxyAddress, this.clientConfigByConfigKey().proxyAddress);
        if (maybeProxy.isPresent()) {
            int port;
            String proxyString = (String)maybeProxy.get();
            int lastColonIndex = proxyString.lastIndexOf(58);
            if (lastColonIndex <= 0 || lastColonIndex == proxyString.length() - 1) {
                throw new RuntimeException("Invalid proxy string. Expected <hostname>:<port>, found '" + proxyString + "'");
            }
            String host = proxyString.substring(0, lastColonIndex);
            try {
                port = Integer.parseInt(proxyString.substring(lastColonIndex + 1));
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("Invalid proxy setting. The port is not a number in '" + proxyString + "'", e);
            }
            builder.proxyAddress(host, port);
        }
    }

    private void configureQueryParamStyle(RestClientBuilder builder) {
        Optional<T> maybeQueryParamStyle = RestClientCDIDelegateBuilder.oneOf(this.clientConfigByClassName().queryParamStyle, this.clientConfigByConfigKey().queryParamStyle);
        if (maybeQueryParamStyle.isPresent()) {
            QueryParamStyle queryParamStyle = (QueryParamStyle)maybeQueryParamStyle.get();
            builder.queryParamStyle(queryParamStyle);
        }
    }

    private void configureRedirects(RestClientBuilder builder) {
        Optional<T> maybeFollowRedirects;
        Optional<T> maxRedirects = RestClientCDIDelegateBuilder.oneOf(this.clientConfigByClassName().maxRedirects, this.clientConfigByConfigKey().maxRedirects);
        if (maxRedirects.isPresent()) {
            builder.property("io.quarkus.rest.client.max-redirects", maxRedirects.get());
        }
        if ((maybeFollowRedirects = RestClientCDIDelegateBuilder.oneOf(this.clientConfigByClassName().followRedirects, this.clientConfigByConfigKey().followRedirects)).isPresent()) {
            builder.followRedirects(((Boolean)maybeFollowRedirects.get()).booleanValue());
        }
    }

    private void configureSsl(RestClientBuilder builder) {
        Optional<T> maybeHostnameVerifier;
        Optional<T> maybeKeyStore;
        Optional<T> maybeTrustStore = RestClientCDIDelegateBuilder.oneOf(this.clientConfigByClassName().trustStore, this.clientConfigByConfigKey().trustStore);
        if (maybeTrustStore.isPresent()) {
            this.registerTrustStore((String)maybeTrustStore.get(), builder);
        }
        if ((maybeKeyStore = RestClientCDIDelegateBuilder.oneOf(this.clientConfigByClassName().keyStore, this.clientConfigByConfigKey().keyStore)).isPresent()) {
            this.registerKeyStore((String)maybeKeyStore.get(), builder);
        }
        if ((maybeHostnameVerifier = RestClientCDIDelegateBuilder.oneOf(this.clientConfigByClassName().hostnameVerifier, this.clientConfigByConfigKey().hostnameVerifier)).isPresent()) {
            this.registerHostnameVerifier((String)maybeHostnameVerifier.get(), builder);
        }
    }

    private void registerHostnameVerifier(String verifier, RestClientBuilder builder) {
        try {
            Class<?> verifierClass = Thread.currentThread().getContextClassLoader().loadClass(verifier);
            builder.hostnameVerifier((HostnameVerifier)verifierClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Could not find a public, no-argument constructor for the hostname verifier class " + verifier, e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Could not find hostname verifier class " + verifier, e);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException("Failed to instantiate hostname verifier class " + verifier + ". Make sure it has a public, no-argument constructor", e);
        }
        catch (ClassCastException e) {
            throw new RuntimeException("The provided hostname verifier " + verifier + " is not an instance of HostnameVerifier", e);
        }
    }

    private void registerKeyStore(String keyStorePath, RestClientBuilder builder) {
        Optional<T> keyStorePassword = RestClientCDIDelegateBuilder.oneOf(this.clientConfigByClassName().keyStorePassword, this.clientConfigByConfigKey().keyStorePassword);
        Optional<String> keyStoreType = RestClientCDIDelegateBuilder.oneOf(this.clientConfigByClassName().keyStoreType, this.clientConfigByConfigKey().keyStoreType);
        try {
            KeyStore keyStore = KeyStore.getInstance(keyStoreType.orElse("JKS"));
            if (keyStorePassword.isEmpty()) {
                throw new IllegalArgumentException("No password provided for keystore");
            }
            String password = (String)keyStorePassword.get();
            try (InputStream input = this.locateStream(keyStorePath);){
                keyStore.load(input, password.toCharArray());
            }
            catch (IOException | NoSuchAlgorithmException | CertificateException e) {
                throw new IllegalArgumentException("Failed to initialize trust store from classpath resource " + keyStorePath, e);
            }
            builder.keyStore(keyStore, password);
        }
        catch (KeyStoreException e) {
            throw new IllegalArgumentException("Failed to initialize trust store from " + keyStorePath, e);
        }
    }

    private void registerTrustStore(String trustStorePath, RestClientBuilder builder) {
        Optional<T> maybeTrustStorePassword = RestClientCDIDelegateBuilder.oneOf(this.clientConfigByClassName().trustStorePassword, this.clientConfigByConfigKey().trustStorePassword);
        Optional<String> maybeTrustStoreType = RestClientCDIDelegateBuilder.oneOf(this.clientConfigByClassName().trustStoreType, this.clientConfigByConfigKey().trustStoreType);
        try {
            KeyStore trustStore = KeyStore.getInstance(maybeTrustStoreType.orElse("JKS"));
            if (maybeTrustStorePassword.isEmpty()) {
                throw new IllegalArgumentException("No password provided for truststore");
            }
            String password = (String)maybeTrustStorePassword.get();
            try (InputStream input = this.locateStream(trustStorePath);){
                trustStore.load(input, password.toCharArray());
            }
            catch (IOException | NoSuchAlgorithmException | CertificateException e) {
                throw new IllegalArgumentException("Failed to initialize trust store from classpath resource " + trustStorePath, e);
            }
            builder.trustStore(trustStore);
        }
        catch (KeyStoreException e) {
            throw new IllegalArgumentException("Failed to initialize trust store from " + trustStorePath, e);
        }
    }

    private InputStream locateStream(String path) throws FileNotFoundException {
        File certificateFile;
        if (path.startsWith("classpath:")) {
            path = path.replaceFirst("classpath:", "");
            InputStream resultStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(path);
            if (resultStream == null) {
                resultStream = this.getClass().getResourceAsStream(path);
            }
            if (resultStream == null) {
                throw new IllegalArgumentException("Classpath resource " + path + " not found for MicroProfile Rest Client SSL configuration");
            }
            return resultStream;
        }
        if (path.startsWith("file:")) {
            path = path.replaceFirst("file:", "");
        }
        if (!(certificateFile = new File(path)).isFile()) {
            throw new IllegalArgumentException("Certificate file: " + path + " not found for MicroProfile Rest Client SSL configuration");
        }
        return new FileInputStream(certificateFile);
    }

    private void configureProviders(RestClientBuilder builder) {
        Optional<T> maybeProviders = RestClientCDIDelegateBuilder.oneOf(this.clientConfigByClassName().providers, this.clientConfigByConfigKey().providers);
        if (maybeProviders.isPresent()) {
            this.registerProviders(builder, (String)maybeProviders.get());
        }
    }

    private void registerProviders(RestClientBuilder builder, String providersAsString) {
        for (String s : providersAsString.split(",")) {
            builder.register(this.providerClassForName(s.trim()));
        }
    }

    private Class<?> providerClassForName(String name) {
        try {
            return Class.forName(name, true, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Could not find provider class: " + name);
        }
    }

    private void configureTimeouts(RestClientBuilder builder) {
        Optional<T> readTimeout;
        Optional<T> connectTimeout = RestClientCDIDelegateBuilder.oneOf(this.clientConfigByClassName().connectTimeout, this.clientConfigByConfigKey().connectTimeout);
        if (connectTimeout.isPresent()) {
            builder.connectTimeout(((Long)connectTimeout.get()).longValue(), TimeUnit.MILLISECONDS);
        }
        if ((readTimeout = RestClientCDIDelegateBuilder.oneOf(this.clientConfigByClassName().readTimeout, this.clientConfigByConfigKey().readTimeout)).isPresent()) {
            builder.readTimeout(((Long)readTimeout.get()).longValue(), TimeUnit.MILLISECONDS);
        }
    }

    private void configureBaseUrl(RestClientBuilder builder) {
        Optional<String> propertyOptional = RestClientCDIDelegateBuilder.oneOf(this.clientConfigByClassName().uri, this.clientConfigByConfigKey().uri);
        if (propertyOptional.isEmpty()) {
            propertyOptional = RestClientCDIDelegateBuilder.oneOf(this.clientConfigByClassName().url, this.clientConfigByConfigKey().url);
        }
        if ((this.baseUriFromAnnotation == null || this.baseUriFromAnnotation.isEmpty()) && propertyOptional.isEmpty()) {
            String propertyPrefix = this.configKey != null ? this.configKey : "\"" + this.jaxrsInterface.getName() + "\"";
            throw new IllegalArgumentException(String.format("Unable to determine the proper baseUrl/baseUri. Consider registering using @RegisterRestClient(baseUri=\"someuri\"), @RegisterRestClient(configKey=\"orkey\"), or by adding '%s' or '%s' to your Quarkus configuration", String.format(REST_URL_FORMAT, propertyPrefix), String.format(REST_URI_FORMAT, propertyPrefix)));
        }
        String baseUrl = propertyOptional.orElse(this.baseUriFromAnnotation);
        try {
            builder.baseUri(new URI(baseUrl));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("The value of URL was invalid " + baseUrl, e);
        }
    }

    private static RestClientsConfig getConfigRoot() {
        InstanceHandle configHandle = Arc.container().instance(RestClientsConfig.class, new Annotation[0]);
        if (!configHandle.isAvailable()) {
            throw new IllegalStateException("Unable to find the RestClientsConfig");
        }
        return (RestClientsConfig)configHandle.get();
    }

    private RestClientConfig clientConfigByConfigKey() {
        return this.configRoot.getClientConfig(this.configKey);
    }

    private RestClientConfig clientConfigByClassName() {
        return this.configRoot.getClientConfig(this.jaxrsInterface);
    }

    private static <T> Optional<T> oneOf(Optional<T> o1, Optional<T> o2) {
        if (o1.isPresent()) {
            return o1;
        }
        return o2;
    }
}

