/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.rest.client.reactive.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.rest.client.reactive.HeaderFiller;
import io.quarkus.rest.client.reactive.ReactiveClientHeadersFactory;
import io.quarkus.rest.client.reactive.runtime.HeaderContainer;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Priority;
import javax.enterprise.context.RequestScoped;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import org.eclipse.microprofile.rest.client.ext.ClientHeadersFactory;
import org.eclipse.microprofile.rest.client.ext.DefaultClientHeadersFactoryImpl;
import org.jboss.resteasy.reactive.client.spi.ResteasyReactiveClientRequestContext;

@Priority(value=-2147483648)
public class MicroProfileRestClientRequestFilter
implements ClientRequestFilter {
    private static final MultivaluedMap<String, String> EMPTY_MAP = new MultivaluedHashMap();
    private final ClientHeadersFactory clientHeadersFactory;

    public MicroProfileRestClientRequestFilter(ClientHeadersFactory clientHeadersFactory) {
        this.clientHeadersFactory = clientHeadersFactory;
    }

    public void filter(ClientRequestContext requestContext) {
        Object headerContainer;
        HeaderFiller headerFiller = (HeaderFiller)requestContext.getProperty(HeaderFiller.class.getName());
        MultivaluedHashMap headers = new MultivaluedHashMap();
        for (Map.Entry headerEntry : requestContext.getHeaders().entrySet()) {
            headers.put((Object)((String)headerEntry.getKey()), MicroProfileRestClientRequestFilter.castToListOfStrings((List)headerEntry.getValue()));
        }
        if (headerFiller != null) {
            headerFiller.addHeaders((MultivaluedMap<String, String>)headers);
        }
        MultivaluedMap incomingHeaders = EMPTY_MAP;
        if (Arc.container().getActiveContext(RequestScoped.class) != null && (headerContainer = (HeaderContainer)Arc.container().instance(HeaderContainer.class, new Annotation[0]).get()) != null) {
            incomingHeaders = ((HeaderContainer)headerContainer).getHeaders();
        }
        if (this.clientHeadersFactory instanceof DefaultClientHeadersFactoryImpl) {
            for (Map.Entry headerEntry : headers.entrySet()) {
                requestContext.getHeaders().put((Object)((String)headerEntry.getKey()), MicroProfileRestClientRequestFilter.castToListOfObjects((List)headerEntry.getValue()));
            }
        }
        if (this.clientHeadersFactory != null) {
            if (this.clientHeadersFactory instanceof ReactiveClientHeadersFactory) {
                ResteasyReactiveClientRequestContext reactiveRequestContext = (ResteasyReactiveClientRequestContext)requestContext;
                ReactiveClientHeadersFactory reactiveClientHeadersFactory = (ReactiveClientHeadersFactory)this.clientHeadersFactory;
                reactiveRequestContext.suspend();
                MultivaluedMap outgoingHeaders = incomingHeaders;
                reactiveClientHeadersFactory.getHeaders((MultivaluedMap<String, String>)incomingHeaders).subscribe().with(newHeaders -> {
                    outgoingHeaders.putAll((Map)newHeaders);
                    reactiveRequestContext.resume();
                }, arg_0 -> ((ResteasyReactiveClientRequestContext)reactiveRequestContext).resume(arg_0));
            } else {
                incomingHeaders = this.clientHeadersFactory.update(incomingHeaders, (MultivaluedMap)headers);
            }
        }
        for (Map.Entry headerEntry : incomingHeaders.entrySet()) {
            requestContext.getHeaders().put((Object)((String)headerEntry.getKey()), MicroProfileRestClientRequestFilter.castToListOfObjects((List)headerEntry.getValue()));
        }
    }

    private static List<String> castToListOfStrings(List<Object> values) {
        ArrayList<String> result = new ArrayList<String>();
        for (Object value : values) {
            if (value instanceof String) {
                result.add((String)value);
                continue;
            }
            result.add(String.valueOf(value));
        }
        return result;
    }

    private static List<Object> castToListOfObjects(List<String> values) {
        return values;
    }
}

