/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.rest.client.reactive.runtime;

import io.quarkus.rest.client.reactive.runtime.ResteasyReactiveResponseExceptionMapper;
import jakarta.ws.rs.client.ClientRequestContext;
import jakarta.ws.rs.client.ClientResponseContext;
import jakarta.ws.rs.client.ClientResponseFilter;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.List;
import org.eclipse.microprofile.rest.client.ext.ResponseExceptionMapper;
import org.jboss.resteasy.reactive.client.handlers.ClientResponseCompleteRestHandler;
import org.jboss.resteasy.reactive.client.impl.ClientRequestContextImpl;
import org.jboss.resteasy.reactive.client.impl.RestClientRequestContext;
import org.jboss.resteasy.reactive.common.core.UnwrappableException;
import org.jboss.resteasy.reactive.common.jaxrs.ResponseImpl;

public class MicroProfileRestClientResponseFilter
implements ClientResponseFilter {
    private final List<ResponseExceptionMapper<?>> exceptionMappers;

    public MicroProfileRestClientResponseFilter(List<ResponseExceptionMapper<?>> exceptionMappers) {
        if (exceptionMappers == null) {
            throw new NullPointerException("exceptionMappers cannot be null");
        }
        this.exceptionMappers = exceptionMappers;
    }

    public void filter(ClientRequestContext requestContext, ClientResponseContext responseContext) throws IOException {
        for (ResponseExceptionMapper<?> exceptionMapper : this.exceptionMappers) {
            if (!exceptionMapper.handles(responseContext.getStatus(), responseContext.getHeaders())) continue;
            RestClientRequestContext restClientContext = ((ClientRequestContextImpl)requestContext).getRestClientRequestContext();
            ResponseImpl response = ClientResponseCompleteRestHandler.mapToResponse((RestClientRequestContext)restClientContext, (boolean)false);
            Throwable throwable = exceptionMapper instanceof ResteasyReactiveResponseExceptionMapper ? ((ResteasyReactiveResponseExceptionMapper)exceptionMapper).toThrowable((Response)response, restClientContext) : exceptionMapper.toThrowable((Response)response);
            if (throwable == null) continue;
            throw new UnwrappableException(throwable);
        }
    }
}

