/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.rest.client.reactive.runtime;

import io.quarkus.rest.client.reactive.ComputedParamContext;
import jakarta.ws.rs.client.ClientRequestContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ComputedParamContextImpl
implements ComputedParamContext {
    private final String name;
    private final List<ComputedParamContext.MethodParameter> parameters;

    public ComputedParamContextImpl(String name, ClientRequestContext context) {
        this.name = name;
        this.parameters = ComputedParamContextImpl.createParameters(context);
    }

    private static List<ComputedParamContext.MethodParameter> createParameters(ClientRequestContext context) {
        Object property = context.getProperty("io.quarkus.rest.client.invokedMethodParameters");
        if (property == null) {
            throw new IllegalStateException("property io.quarkus.rest.client.invokedMethodParameters should have been part of the client context");
        }
        List methodParameterValues = (List)property;
        if (methodParameterValues.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ComputedParamContext.MethodParameter> result = new ArrayList<ComputedParamContext.MethodParameter>(methodParameterValues.size());
        for (Object value : methodParameterValues) {
            result.add(new MethodParameterImpl(value));
        }
        return result;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public List<ComputedParamContext.MethodParameter> methodParameters() {
        return this.parameters;
    }

    private static class MethodParameterImpl
    implements ComputedParamContext.MethodParameter {
        private final Object value;

        private MethodParameterImpl(Object value) {
            this.value = value;
        }

        @Override
        public Object value() {
            return this.value;
        }
    }
}

